/*
 * QtTelepathy, the Tapioca Qt4 Telepathy Client Library
 * Copyright (C) 2006 by Tobias Hunger <tobias.hunger@basyskom.de>
 * Copyright (C) 2006 by INdT
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef QTTELEPATHY_PROPERTIESTYPES_H
#define QTTELEPATHY_PROPERTIESTYPES_H

#include <QtCore/QList>
#include <QtCore/QString>
#include <QtDBus/QDBusArgument>
#include <QtDBus/QDBusVariant>
#include <QtTelepathy/Common/BaseTypes>

namespace org {
namespace freedesktop {
namespace Telepathy {

enum PropertyFlag {
    PROPERTY_FLAG_NONE  = 0x00000000,
    PROPERTY_FLAG_READ  = 0x00000001,
    PROPERTY_FLAG_WRITE = 0x00000002,
    PROPERTY_FLAG_ALL   = 0xFFFFFFFF
};
Q_DECLARE_FLAGS(PropertyFlags, PropertyFlag)

class Property
{
public:
    uint id;
    QDBusVariant value;
};
typedef QList<Property> PropertyList;

class PropertyDefinition
{
public:
    uint id;
    QString name;
    QString type;
    quint32 flags;
};
typedef QList<PropertyDefinition> PropertyDefinitionList;

class PropertyFlagChange
{
public:
    uint id;
    quint32 newFlags;
};
typedef QList<PropertyFlagChange> PropertyFlagChangeList;

} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PropertyDefinition)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PropertyDefinitionList)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::Property)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PropertyList)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PropertyFlagChange)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PropertyFlagChangeList)

Q_DECLARE_OPERATORS_FOR_FLAGS(org::freedesktop::Telepathy::PropertyFlags)

const QDBusArgument &operator>>(const QDBusArgument &, org::freedesktop::Telepathy::Property &);
QDBusArgument &operator<<(QDBusArgument &, const org::freedesktop::Telepathy::Property &);

const QDBusArgument &operator>>(const QDBusArgument &, org::freedesktop::Telepathy::PropertyDefinition &);
QDBusArgument &operator<<(QDBusArgument &, const org::freedesktop::Telepathy::PropertyDefinition &);

const QDBusArgument &operator>>(const QDBusArgument &, org::freedesktop::Telepathy::PropertyFlagChange &);
QDBusArgument &operator<<(QDBusArgument &, const org::freedesktop::Telepathy::PropertyFlagChange &);

#endif

