<?php
 /*
   Tiquit Is Quality User Incident Tracking
   Copyright (C) 2006 Jonathan Ciesla
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
  */
require_once("config.php");
require_once("functionlib.php");
authentication(0, 0);
favicon();
  
$link = dbms_connect($dbhost, $dbuser, $dbpass, $dbname);

echo "<link rel=stylesheet href=css.php>";
echo "<title>$sitetitle</title>";
echo "<h1>$sitetitle</h1>";

$date_a = array(date("Y"), date("m"), date("d"));
$date = implode("-", $date_a);
$time_a = array(date("H"), date("i"), date("s"));
$time = implode(":", $time_a);
$date = $date . " " . $time;

$numtext = $_POST['numtext'];
if($numtext){
  $num=dbms_escape_string($numtext);
 } else { 
  $num = $_POST['num'];
 };

if(!$num){ echo "No incident number specified.";
  echo "<meta http-equiv=refresh content=2;url=$siteaddress/main.php />";
  exit;
 };

$user_id = dbms_escape_string($_SESSION['tiquitid']);

$time_a = array(date("H"), date("i"), "00");
$time = implode(":", $time_a);

kickout();

locking($num, $time, $user_id);

$update=$_POST['update'];
if($update=="yes"){
  $query = "SELECT type,usr,agent,status,severity,parent FROM incident WHERE number = '$num';";
  $result = dbms_query($query);
  $line = dbms_fetch_array($result, "ASSOC");
  dbms_free_result($result);
  
  $user = $_POST['name'];
  $type = $_POST['type'];
  $agent = $_POST['agent'];
  $status = $_POST['status'];
  if(!$status){$status="Open";};
  $resolution = $_POST['resolution'];
  if(!$resolution){$resolution="Unresolved";};
  $severity = $_POST['severity'];
  
  $parenttext = $_POST['parenttext'];
  if($parenttext){
    $parent=dbms_escape_string($parenttext);
  } else { 
    $parent = $_POST['parent'];
  };
   
  if($parent==$num){$parent="";};

  $newparent = $parent;
  while($newparent){
    $query1 = "SELECT parent FROM incident WHERE number = '$newparent';";
    $result1 = dbms_query($query1);
    $line1 = dbms_fetch_array($result1, "NUM");
    if($line1[0]){
      if($newparent==$line1[0]){$line1[0]=="";};
      $newparent = $line1[0];
    } else {
      $parent = $newparent;
      $newparent = "";
    };
    dbms_free_result($result1);
  };
   
  if($status=="Closed"){
    $closechild = $_POST['closechild'];
    if($closechild){
      $query1 = "SELECT number FROM incident WHERE parent = '$num' and status <>'Closed';";
      $result1 = dbms_query($query1);
      while($line1 = dbms_fetch_array($result1, "NUM")){
	close_child($line1[0], $resolution, $closed, $num, $date);
      };
      dbms_free_result($result1);
    };
    $kb = $_POST['kb'];
    if($kb){

      $topic = dbms_escape_string("From Incident $num");
      $text = dbms_escape_string($resolution);

      $kbdate_a = array(date("Y"), date("m"), date("d"));
      $kbdatenew = implode("-", $kbdate_a);
      $kbtime_a = array(date("H"), date("i"), date("s"));
      $kbtime = implode(":", $kbtime_a);
      $kbdatenew = $kbdatenew . " " . $kbtime;
      
      $query1 = "SELECT number FROM knowledgebase ORDER BY number DESC LIMIT 1;";
      $result1 = dbms_query($query1);
      $line1 = dbms_fetch_array($result1, "NUM");
      $value = $line1[0];
      $value++;
      dbms_free_result($result1);
      
      $query = "INSERT INTO knowledgebase (number,topic,text,lastagent,date) VALUES ('$value','$topic','$text','$user_id','$kbdatenew');";
      $result = dbms_query($query);
      echo $query;
    };
  };
  
  $user=dbms_escape_string($user);
  if($user==$line['usr']){$change_user=0;}else{$change_user=1; $olduser=$line['user'];};
  
  $type=dbms_escape_string($type);
  if($type==$line['type']){$change_type=0;}else{$change_type=1; $oldtype=$line['type'];};
  
  $agent=dbms_escape_string($agent);
  if($agent==$line['agent']){$change_agent=0;}else{$change_agent=1; $oldagent=$line['agent'];};
  
  $status=dbms_escape_string($status);
  if($status==$line['status']){$change_status=0;}else{$change_status=1; $oldstatus=$line['status'];};
  if($status=="Closed"&&$change_status==1){$closed=$date;}else{$closed="";};

  $resolution=dbms_escape_string($resolution);
  
  $closed = dbms_escape_string($closed);
  
  $severity = dbms_escape_string($severity);
  if($severity==$line['severity']){$change_severity=0;}else{$change_severity=1; $oldseverity=$line['severity'];};
  
  $parent=dbms_escape_string($parent);
  if($parent){
    if($parent==$line['parent']){$change_parent=0;}else{$change_parent=1; $oldparent=$line['parent'];};
  };
  if (($type)&&($user)&&($agent)) {
    $query = "UPDATE incident SET type='$type',usr='$user',agent='$agent',status='$status',resolution='$resolution',";
    if($closed&&$change_status==1){$query .= "closed='$closed',";};
    $query .= "severity='$severity',";
    if($parent){$query .= "parent='$parent',";}else{$query .= "parent=NULL,";};
    $query2 = "SELECT number FROM agent WHERE id = '$user_id';";
    $result2 = dbms_query($query2);
    $line2 = dbms_fetch_array($result2, "NUM");
    dbms_free_result($result2);
    $agent_id = $line2[0];
    if($status=="Closed"){$query .= "closer='$agent_id'";}else{$query .= "closer=0";};
    $query .= " WHERE number = '$num'";
    $result = dbms_query($query, $link);
    
    $query = "SELECT lname,fname FROM users WHERE number = '$user';";
    $result = dbms_query($query, $link);
    $line = dbms_fetch_array($result, "ASSOC");
    $fname = $line['fname']; $lname = $line['lname'];
    dbms_free_result($result);
    
    $rep = agent_name($agent);
 
    if(($change_agent=="1")||($change_status=="1")||($change_severity=="1")||($change_user=="1")||($change_type=="1")||($change_parent=="1")){
      $query = "SELECT notify,address,name,assign_attach,assign_diary,res_text,use_res_text FROM universal";
      $result = dbms_query($query);
      $line = dbms_fetch_array($result, "ASSOC");
      dbms_free_result($result);
      if($line['notify']=="1"){
	$mime_boundary=md5(time()); 
	$assign_attach = $line['assign_attach'];
	$assign_diary = $line['assign_diary'];

	$sender = $line['address'];
	$name = $line['name'];
	$from = "-f" . $sender;
	
	$query1 = "SELECT email FROM users WHERE number = '$user';";
	$result1 = dbms_query($query1);
	$line1 = dbms_fetch_array($result1, "ASSOC");
	dbms_free_result($result1);
	$user_email = $line1['email'];
	
	$type_name = type_name($type);
	
	$agent_name = $rep;
	
	$oldagent_name = agent_name($oldagent);

	$query1 = "SELECT name,email FROM agent WHERE number = '$agent';";
	$result1 = dbms_query($query1);
	$line1 = dbms_fetch_array($result1, "ASSOC");
	dbms_free_result($result1);
	$assignee_name = $line1['name'];
	$agent_email = $line1['email'];
	
	$oldtype_name = type_name($oldtype);
	
	$query1 = "SELECT lname,fname FROM users WHERE number = '$olduser';";
	$result1 = dbms_query($query1, $link);
	$line1 = dbms_fetch_array($result1, "ASSOC");
	$oldfname = $line1['fname']; $oldlname = $line1['lname'];
	dbms_free_result($result1);
	$olduser_name = $oldlname . ", " . $oldfname;
	
	$sub = "Tiquit Incident # $num Updated";
	
	$message = "<html>";
	$message .= "<h2><b>Incident # $num for:</b> $fname $lname";
	if($change_user==1){$message .= "<small><i> ($olduser_name)</i></small>";};
	$message .= "</h2>";
	$message .= "<h3><b>Type:</b> $type_name";
	if($change_type==1){$message .= "<small><i> ($oldtype_name)</i></small>";};
	$message .= "</h3>";
	$message .= "<h3><b>Severity:</b> $severity";
	if($change_severity==1){$message .= "<small><i> ($oldseverity)</i></small>";};
	$message .= "</h3>";
	$message .= "<h3><b>Updated by:</b> $agent_name</h3>";
	$message .= "<h3><b>Assigned to:</b> $assignee_name";
	if($change_agent==1){$message .= "<small><i> ($oldagent_name)</i></small>";};
	$message .= "</h3>";
	if($change_status==1){$message .= "<h3><b>Status has been changed from</b> $oldstatus <b>to</b> $status<b>.</b></h3>";};
	if($parent){
	  $message .= "<h3><b>Parent Incident:</b> $parent";
	  if($change_parent==1){$message .= "<small><i> ($oldparent)</i></small>";};
	  $message .= "</h3>";
	};
	$addy = $siteaddress . "/index.php?name=" . $user;
	$message .= "<p>Click <a href=$addy>here</a> to view your incidents";
	
	//check, add diaries
	if($assign_diary=='1'){
	  $message .= "<table border=1 cellpadding=5 align=center>";
	  $message .= "<CAPTION>Diary Entries</CAPTION>";
	  $query2 = "SELECT number,agent,text,date FROM diary WHERE incident = '$num' ORDER BY date;";
	  $result2 = dbms_query($query2);
	  while($line2 = dbms_fetch_array($result2, "ASSOC")){
	    $message .= "<tr>";
	    $message .= "<td>{$line2['number']}</td>";  
	    $rep = agent_name($line2['agent']);
	    $message .= "<td>$rep</td>";
	    $message .= "<td>{$line2['text']}</td>";
	    $message .= "<td>{$line2['date']}</td>";
	    $message .= "</tr>";
	  };
	  $message .= "</table>";
	  dbms_free_result($result2);
	};
	
	//Add resolution
	if($status=="Closed"){
	  $message .= "<table border=1 cellpadding=5 align=center>";
	  $message .= "<CAPTION>Resolution</CAPTION>";
	  $message .= "<tr>";
	  $message .= "<td>$resolution</td>";  
	  $message .= "</tr>";
	  $message .= "</table>";
	  //Add custom resolution text if any
	  if($line['use_res_text']==1){
	    $new_text = preg_replace("/\&incident\&/", $num, $line['res_text']);
	    $message .= $new_text;
	  };
	};

	$message .= "</html>";

	$headers = "From: $name <$sender>\r\n";
	$headers .= "Reply-to: $sender\r\n";
	$headers .= "Cc: $user_email\r\n";
	$headers .= "MIME-Version: 1.0\r\n";
	$headers .= "Content-Type: multipart/mixed; boundary=\"" . $mime_boundary . "\";\r\n"; 

	$test_message = "<h2>Foo bar</h2>";

	$mess_head .= "--" . $mime_boundary . "\r\n";
	$mess_head .= "Content-Type: text/html; charset=\"iso-8859-1\"\r\n";
	$mess_head .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
	$mess_head .= $message . "\r\n";
	
	//check, add attachments
	if($assign_attach=='1'){
	  $attach = '';
	  $query2 = "SELECT content,name,mime FROM files WHERE incident = '$num' ORDER BY number;";
	  $result2 = dbms_query($query2);
	  while($line2 = dbms_fetch_array($result2, "ASSOC")){
	    $attach .= "--" . $mime_boundary . "\r\n";
	    $attach .= "Content-Type: " . $line2['mime'] . "; name=\"" . $line2['name'] . "\";\r\n";
	    $attach .= "Content-Transfer-Encoding: base64\n\r";
	    $attach .= "Content-Disposition: attachment; filename=\"" . $line2['name'] . "\"\r\n";
	    $attach .= chunk_split(base64_encode($line2['content'])) . "\r\n";
	  };  
	  dbms_free_result($result2);
	  $mess_head .= $attach;
	};
	$mess_head .= "--" . $mime_boundary . "--\r\n";
	
	mail($agent_email, $sub, $mess_head, $headers, $from);
      }; //notify
    }; //change_agent/status
    
    if($change_user==1){
      $value = audit_number();
      
      $query1 = "SELECT lname,fname FROM users WHERE number = '$olduser';";
      $result1 = dbms_query($query1, $link);
      $line1 = dbms_fetch_array($result1, "ASSOC");
      dbms_free_result($result1);
      $oldval = $line1['lname'] . ", " . $line1['fname'];
      
      $action = dbms_escape_string("User"); 
      
      $query = "SELECT lname,fname FROM users WHERE number = '$user';";
      $result = dbms_query($query, $link);
      $line = dbms_fetch_array($result, "ASSOC");
      dbms_free_result($result);
      $newval = $line['lname'] . ", " . $line['fname'];
      
      $query = "INSERT INTO audit (number,incident,date,action,agent,oldval,newval) VALUES ('$value','$num','$date','$action','$user_id','$oldval','$newval')";
      dbms_query($query);
    };
    
    if($change_agent==1){
      $value = audit_number();
      
      $oldval = agent_name($oldagent);
      
      $action = dbms_escape_string("Agent"); 
      
      $newval = agent_name($agent);
      
      $query = "INSERT INTO audit (number,incident,date,action,agent,oldval,newval) VALUES ('$value','$num','$date','$action','$user_id','$oldval','$newval')";
      dbms_query($query);
    };
    
    if($change_type==1){
      $value = audit_number();
      
      $oldval = type_name($oldtype);
      
      $action = dbms_escape_string("Type"); 
      
      $newval = type_name($type);
      
      $query = "INSERT INTO audit (number,incident,date,action,agent,oldval,newval) VALUES ('$value','$num','$date','$action','$user_id','$oldval','$newval')";
      dbms_query($query);
    };
    
    if($change_status==1){
      $value = audit_number();
      
      $oldval = $oldstatus;
      
      $action = dbms_escape_string("Status"); 
      
      $newval = $status;
      
      $query = "INSERT INTO audit (number,incident,date,action,agent,oldval,newval) VALUES ('$value','$num','$date','$action','$user_id','$oldval','$newval')";
      dbms_query($query);
    };
    
    if($change_parent==1){
      $value = audit_number();
      
      $oldval = $oldparent;
      
      $action = dbms_escape_string("Parent"); 
      
      $newval = $parent;
      
      $query = "INSERT INTO audit (number,incident,date,action,agent,oldval,newval) VALUES ('$value','$num','$date','$action','$user_id','$oldval','$newval')";
      dbms_query($query);
      
      $query = "SELECT number FROM incident WHERE parent = '$num';";
      $result = dbms_query($query);
      while($line = dbms_fetch_array($result, "NUM")){
	foreach($line as $x){
	  $query1 = "UPDATE incident SET parent = '$parent' WHERE number = '$x';";
	  $result1 = dbms_query($query1);
	  
	  $value = audit_number();
	  
	  $oldval = $num;
	  
	  $action = dbms_escape_string("Parent"); 
	  
	  $newval = $parent;
	  
	  $query = "INSERT INTO audit (number,incident,date,action,agent,oldval,newval) VALUES ('$value','$x','$date','$action','$user_id','$oldval','$newval')";
	  dbms_query($query);
	};
      };
      dbms_free_result($result);
    };
    
    if($change_severity==1){
      $value = audit_number();
      
      $oldval = $oldseverity;
      
      $action = dbms_escape_string("Severity"); 
      
      $newval = $severity;
      
      $query = "INSERT INTO audit (number,incident,date,action,agent,oldval,newval) VALUES ('$value','$num','$date','$action','$user_id','$oldval','$newval')";
      dbms_query($query);
    };
    
  }; //type/user/agent
 }; //update

$query = "SELECT number,type,usr,agent,description,status,resolution,date,closed,severity,parent,logged FROM incident WHERE number = '$num'";
$result = dbms_query($query);
while($line = dbms_fetch_array($result, "ASSOC")){
  $current_type = $line['type'];
  $current_user = $line['usr'];
  $current_agent = $line['agent'];
  $current_description = $line['description'];
  $current_diary = $line['description'];
  $current_status = $line['status'];
  $current_resolution = $line['resolution'];
  $current_date = $line['date'];
  $current_closed = $line['closed'];
  $current_severity = $line['severity'];
  $current_parent = $line['parent'];
  $logged_by = agent_name($line['logged']);
};
dbms_free_result($result);

echo "<h2>Update Incident # $num</h2>";

//new table
echo "<table align=center border=1>";
echo "<tr><td valign=top>";

echo "<table align=center cellpadding=5>";

echo "<tr><td>&nbsp;</td></tr>";

$query = "SELECT COUNT(number) FROM diary WHERE incident = '$num';";
$result = dbms_query($query);
$line = dbms_fetch_array($result, "NUM");
dbms_free_result($result);
if($line[0]>0){$tag = "bgcolor=#00FF00";} else {$tag = "";};

echo "<tr>";
echo "<td align=center $tag>";
echo "<form action=incident_diary.php method=post>";
echo "<input type=hidden name=num value=$num>";
echo "<input type=hidden name=status value=$current_status>";
echo "<input type=submit value=\"Diary Entries\" />";
echo "</form>";
echo "</td>";
echo "</tr>";

echo "<tr><td>&nbsp;</td></tr>";

$query = "SELECT COUNT(number) FROM files WHERE incident = '$num';";
$result = dbms_query($query);
$line = dbms_fetch_array($result, "NUM");
dbms_free_result($result);
if($line[0]>0){$tag = "bgcolor=#00FF00";} else {$tag = "";};

echo "<tr>";
echo "<td align=center $tag>";
echo "<form action=attachments.php method=post>";
echo "<input type=hidden name=num value=$num>";
echo "<input type=submit value=\"File Attachments\" />";
echo "</form>";
echo "</td>";
echo "</tr>";

echo "<tr><td>&nbsp;</td></tr>";

echo "<tr>";
echo "<td align=center>";
echo "<form action=request_info.php method=post>";
echo "<input type=hidden name=num value=$num>";
echo "<input type=submit value=\"Request Info\" />";
echo "</form>";
echo "</td>";
echo "</tr>";

echo "<tr><td>&nbsp;</td></tr>";

$query = "SELECT count(number) FROM incident WHERE parent = '$num';";
$result = dbms_query($query);
$line = dbms_fetch_array($result, "NUM");
if($line[0]>=1){
  echo "<tr>";
  echo "<td align=center>";
  echo "<form action=incident_children.php method=post>";
  echo "<input type=hidden name=num value=$num>";
  echo "<input type=submit value=\"Children\" />";
  echo "</form>";
  echo "</td>";
  echo "</tr>";
 };
if($current_parent){
  echo "<tr>";
  echo "<td align=center>";
  echo "<form action=incident_update.php method=post>";
  echo "<input type=hidden name=num value=$current_parent>";
  echo "<input type=submit value=\"Parent\" />";
  echo "</form>";
  echo "</td>";
  echo "</tr>";
 };
echo "<tr><td>&nbsp;</td></tr>";
echo "<tr><td>&nbsp;</td></tr>";

echo "<tr>";
echo "<td align=center>";
echo "<form action=audit_display.php method=post>";
echo "<input type=hidden name=num value=$num>";
echo "<input type=submit value=\"Audit History\" />";
echo "</form>";
echo "</td>";
echo "</tr>";

echo "<tr><td>&nbsp;</td></tr>";
echo "<tr><td align=center>";
if($feta=="1"){
  echo "<form action=system_specs.php method=post>";
  echo "<input type=hidden name=num value=$num>";
  echo "<input type=submit value=\"Feta System Specs\" />";
  echo "</form>";
 } else {
  echo "&nbsp;";
 };
echo "</td></tr>";

echo "</table>";

echo "</td><td>";

echo "<table align=center border=1><tr>";
echo "<td align=center>";

echo "<table align=center border=1>";
echo "<tr>";
$query = "SELECT lname,fname FROM users WHERE number = '$current_user';";
$result = dbms_query($query);
$line = dbms_fetch_array($result, "NUM");
echo "<td colspan=2 align=center>{$line['0']}, {$line['1']}</td>";
dbms_free_result($result);
echo "</tr><tr>";
echo "<td>";
echo "<form action=name_select.php method=post>";
name_widget(1);
echo "</td>";
echo "<td>";
echo "<input type=hidden name=form value=incupdate>";
echo "<input type=hidden name=num value=\"$num\">";
echo "<input type=hidden name=type value=\"$current_type\">";
echo "<input type=hidden name=agent value=\"$current_agent\">";
echo "<input type=hidden name=severity value=\"$current_severity\">";
echo "<input type=hidden name=description value=\"$current_description\">";
echo "<input type=hidden name=parent value=\"$current_parent\">";
echo "<input type=hidden name=status value=\"$current_status\">";
echo "<input type=hidden name=resolution value=\"$current_resolution\">";
echo "<input type=hidden name=update value=yes>";
echo "<input type=submit value=Reassign></td>";
echo "</tr>";
echo "</form>";
echo "</table>";

echo "<form action=incident_update.php method=post>";
echo "<input type=hidden name=name value=$current_user>";

echo " Incident Type:<select name=type />";
echo "<option value=\"\">";
$query = "SELECT name,number FROM type WHERE enabled = '1';";
$result = dbms_query($query);
while ($line = dbms_fetch_array($result, "NUM")){
  if($line[1]==$current_type){$flag="selected";}else{$flag="";};
  echo "<option value={$line['1']} $flag>{$line['0']}";
 };
dbms_free_result($result);

echo "</select><br />";

$arr = array("5", "4", "3", "2", "1");

echo "Severity Level:<select name=severity />";
echo "<option value=\"\">";
foreach($arr as $ar){
  if($ar==$current_severity){$flag="selected";}else{$flag="";};
  echo "<option value=$ar $flag>$ar";
};
echo "</select>";

echo " Assign to Agent:<select name=agent />";
echo "<option value=\"\">";
$query = "SELECT name,number FROM agent WHERE enabled = '1';";
$result = dbms_query($query);
while ($line = dbms_fetch_array($result, "NUM")){
  if($line[1]==$current_agent){$flag="selected";}else{$flag="";};
  echo "<option value={$line['1']} $flag>{$line['0']}";
 };
dbms_free_result($result);

echo "</select><br />";

echo "Incident date: $current_date Logged by: $logged_by<br />";
echo "Closed date: $current_closed<br />";

echo "<table border=1>";
echo "<style> p{ background-color: #CCCCCC } </style>";
echo "<tr><td>";
echo "<p>$current_description</p>";
echo "</td></tr></table>";

echo "</td>";
echo "</tr><tr>";

echo "<td align=center colspan=2>";

echo "Status:<select name=status />";
echo "<option value=\"\">";
if($current_status=="Open"){$openflag="selected";}else{$openflag="";};
if($current_status=="Hold"){$holdflag="selected";}else{$holdflag="";};
if($current_status=="Closed"){$closedflag="selected";}else{$closedflag="";};
echo "<option value=Open $openflag>Open";
echo "<option value=Hold $holdflag>Hold";
echo "<option value=Closed $closedflag>Closed";
echo "</select>";
echo "Parent:";
echo "<input type=text name=parenttext size=5 value=$current_parent>";
$query = "SELECT number FROM incident ORDER BY number DESC LIMIT 10";
$result = dbms_query($query);
echo "<select name=parent>";
echo "<option value =\"\">";
while($line = dbms_fetch_array($result, "NUM")){
  echo "<option value={$line['0']}>{$line['0']}";
 };
dbms_free_result($result);
echo "</select>";
echo "Close Child incidents:";
echo "<input type=checkbox name=closechild />";
echo "<br />";

if($current_status=="Closed"){$resflag="disabled";}else{$resflag="";};

echo "<textarea rows=12 cols=45 name=resolution $resflag>$current_resolution</textarea><br />";

echo "Add Resolution to Knowledgebase<input type=checkbox name=kb />";

echo "</td>";

echo "</tr><tr>";

echo "<td align=center>";
echo "<input type=hidden name=num value=\"$num\">";
echo "<input type=hidden name=update value=yes>";
echo "<input type=submit value=Submit>";
echo "</form>";
echo "</td>";

echo "</tr></table>";

//end new table
echo "</td></tr>";
echo "</table>";

echo "<form action=main.php method=post>";
echo "<input type=hidden name=incident value=$num>";
echo "<input type=submit value=Back />";
echo "</form>";

?>