<?php
 /*
   Tiquit Is Quality User Incident Tracking
   Copyright (C) 2006 Jonathan Ciesla
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
  */
require_once("config.php");
require_once("functionlib.php");
favicon();

$link = dbms_connect($dbhost, $dbuser, $dbpass, $dbname);

$incnew=$_POST['incnew'];
if($incnew=="yes"){
  $date_a = array(date("Y"), date("m"), date("d"));
  $datenew = implode("-", $date_a);
  $time_a = array(date("H"), date("i"), date("s"));
  $time = implode(":", $time_a);
  $datenew = $datenew . " " . $time;
  
  $query = "SELECT number FROM incident ORDER BY number DESC LIMIT 1;";
  $result = dbms_query($query);
  $line = dbms_fetch_array($result, "NUM");
  $num = $line[0];
  $num++;
  dbms_free_result($result);
  
  $type = dbms_escape_string($_POST['type']);
  $description = dbms_escape_string($_POST['description']);
  $severity = dbms_escape_string($_POST['severity']);
  $authcode = dbms_escape_string($_POST['authcode']);
  
  $query = "SELECT number FROM users WHERE authcode = '$authcode';";
  $result = dbms_query($query);
  $line = dbms_fetch_array($result, "NUM");
  $user = $line[0];

  if (($type)&&($user)&&($description)&&($authcode)) {
    $query = "INSERT INTO incident (number,type,usr,agent,description,status,resolution,date,closed,severity,parent) VALUES ('$num','$type','$user',NULL,'$description','Open','$resolution','$datenew',NULL,'$severity',NULL);";
    $result = dbms_query($query, $link);
    
    $query = "SELECT lname,fname FROM users WHERE number = '$user';";
    $result = dbms_query($query, $link);
    $line = dbms_fetch_array($result, "ASSOC");
    $fname = $line['fname']; $lname = $line['lname'];
    dbms_free_result($result);
    
    $rep = agent_name($agent);
    
    //notification
    
    $query = "SELECT notify,address FROM universal";
    $result = dbms_query($query);
    $line = dbms_fetch_array($result, "ASSOC");
    dbms_free_result($result);
    if($line['notify']=="1"){
      $sender = $line['address'];
      $from = "-f" . $sender;
      
      $query = "SELECT email FROM users WHERE number = '$user'";
      $result = dbms_query($query);
      $line = dbms_fetch_array($result, "ASSOC");
      dbms_free_result($result);
      $user_email = $line['email'];
      
      $type_name = type_name($type);
      
      $sub = "Tiquit Incident # $num";
      
      $message = "<html>";
      $message .= "<h2><b>New Incident # $num for:</b> $fname $lname</h2>";
      $message .= "<h3><b>Type:</b> $type_name</h3>";
      $message .= "<h3><b>Severity:</b> $severity</h3>";
      $message .= "<h3><b>Assigned by:</b> $fname $lname</h3>";
      $message .= "<h4><b>Description:</b> $description</h4>";
      $addy = $siteaddress . "/index.php?name=" . $user;
      $message .= "<p>Click <a href=$addy>here</a> to view your incidents";
      $headers = "From: $sender\r\n";
      $headers .= "Reply-to: $sender\r\n";
      $headers .= "Cc: $user_email\r\n";
      $headers .= "MIME-Version: 1.0\r\n";
      $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";
      
      mail($sender, $sub, $message, $headers, $from);
    };
  };
 };

echo "<head>";
echo "<style type=\"text/css\">";
echo "img";
echo "{";
echo "vertical-align: top";
echo "}";
echo "</style>";
echo "</head>";

echo "<link rel=stylesheet href=style.css>";
echo "<title>$sitetitle</title>";

echo "<a href=\"http://tiquit.sourceforge.net\" target=\"_blank\">";
echo "<img src=\"tiquit_logo_grey.png\" border=0></a><br />";

echo "<h1>$sitetitle</h1>";

echo "<form action=main.php method=post>";
echo "<input type=submit value=\"Agent Login\" />";
echo "</form>";

$query = "SELECT user_sub,user_search,user_reg FROM universal;";
$result = dbms_query($query);
$line = dbms_fetch_array($result, "ASSOC");
$user_sub = $line['user_sub'];
$user_search = $line['user_search'];
$user_reg = $line['user_reg'];
dbms_free_result($result);

//enable user submission

if($user_sub==1){
  echo "<form action=incident_user_submit.php method=post>";
  echo "<input type=submit value=\"Submit an Incident\" />";
  echo "</form>";
 };

$name = $_GET['name'];
$name=dbms_escape_string($name);

//enable user search

if($user_search==1){
  echo "<form action=index.php method=get>";
  
  echo "Name:<select name=name />";
  echo "<option value=\"\">Select user name:";
  $query = "SELECT lname,fname,number FROM users WHERE enabled = '1' ORDER BY lname ASC, fname ASC;";
  $result = dbms_query($query, $link);
  while ($line = dbms_fetch_array($result, "NUM")) {
    if($line[1]==$name){$flag="selected";} else {$flag="";};
    echo "<option value={$line['2']} $flag>{$line['0']}, {$line['1']}";
  };
  dbms_free_result($result);
  
  echo "</select>";

  echo "<input type=submit value=Search>";
  echo "</form>";
 };  

//enable user registration
if($user_reg==1){
  echo "<form action=setup_request.php method=post>";
  echo "Not a registered user?  ";
  echo "<input type=submit value=Register />";
  echo "</form>";
 };

if($name){
  echo "<table border=1 align=center>";
  echo "<tr><th>#</th><th>User</th><th>Severity</th><th>Agent</th><th>Type</th><th>Description</th><th>Date</th><th>Status</th></tr>";
  $query = "SELECT number,usr,agent,type,description,date,status,severity FROM incident WHERE usr='$name' ORDER BY status DESC, severity ASC, number DESC";
  $result = dbms_query($query);
  while($line = dbms_fetch_array($result, "ASSOC")){
    echo "<tr>";
    
    if($line['status']=="Open"){$stat_color = "#00FF00";};
    if($line['status']=="Hold"){$stat_color = "#FFFF00";};
    if($line['status']=="Closed"){$stat_color = "#C0C0C0";};
    
    echo "<td bgcolor=$stat_color>{$line['number']}</td>";
    
    $query1 = "SELECT lname,fname FROM users WHERE number ='{$line['usr']}'";
    $result1 = dbms_query($query1);
    $line1 = dbms_fetch_array($result1, "ASSOC");
    dbms_free_result($result1);
    $print_name = $line1['lname'] . ", " . $line1['fname'];
    echo "<td bgcolor=$stat_color>$print_name</td>";
    
    if($line['severity']=="1"){$sev_color = "#FF0000";};
    if($line['severity']=="2"){$sev_color = "#FF9900";};
    if($line['severity']=="3"){$sev_color = "#FFFF00";};
    if($line['severity']=="4"){$sev_color = "#00FF00";};
    if($line['severity']=="5"){$sev_color = "#0000FF";};
  
    echo "<td bgcolor=$sev_color>{$line['severity']}</td>";
    
    $print_type = agent_name($line['agent']);
    echo "<td bgcolor=$stat_color>$print_type</td>";
    
    $print_type = type_name($line['type']);
    echo "<td bgcolor=$stat_color>$print_type</td>";
    
    echo "<td bgcolor=$stat_color>{$line['description']}</td>";
    
    echo "<td bgcolor=$stat_color>{$line['date']}</td>";
    
    echo "<td bgcolor=$stat_color>";
    echo "{$line['status']}";
    echo "</td>";
  
    echo "</tr>";
  };
  echo "</table>";
  dbms_free_result($result);
};

$query = "SELECT version,year FROM universal;";
$result = dbms_query($query);
$line = dbms_fetch_array($result, "ASSOC");
dbms_free_result($result);

echo "Tiquit version {$line['version']} Copyright {$line['year']} Jonathan Ciesla";
echo "<br />";
if($dbtype=="my"){
  echo "Running on MySQL";
  echo "<br />";
 };
if($dbtype=="pg"){
  echo "Running on PostgreSQL ";
  echo "<br />";
 };
$time_a = array(date("H"), date("i"), date("s"));
$time = implode(":", $time_a);
$date = $date . " " . $time;
echo "$date<br />";

?>
