<?php
 /*
   Tiquit Is Quality User Incident Tracking
   Copyright (C) 2006 Jonathan Ciesla
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
  */
require_once("config.php");
require_once("functionlib.php");
authentication(0, 0);
favicon();
 
$link = dbms_connect($dbhost, $dbuser, $dbpass, $dbname);

$incidenttext = $_POST['incidenttext'];
if($incidenttext){
  $incident=dbms_escape_string($incidenttext);
 } else { 
  $incident = $_POST['incident'];
 };

echo "<link rel=stylesheet href=reporting.css>";
echo "<title>Incident $incident</title>";
echo "<h1>Incident $incident</h1>";

$query = "SELECT type,usr,agent,description,status,resolution,date,closed,severity,parent FROM incident WHERE number = '$incident';";
$result = dbms_query($query);
$line = dbms_fetch_array($result, "NUM");
dbms_free_result($result);

$query = "SELECT lname,fname FROM users WHERE number = '{$line[1]}';";
$result = dbms_query($query);
$names = dbms_fetch_array($result, "NUM");
$full_name = $names[0] . ", " . $names[1];
dbms_free_result($result);

$agent_name = agent_name($line[2]);

$type_name = type_name($line[0]);

$query = "SELECT number FROM diary WHERE incident = '$incident' ORDER BY number ASC LIMIT 1;";
$result = dbms_query($query);
$nums = dbms_fetch_array($result, "NUM");
dbms_free_result($result);

$wrapped = wordwrap($line[3], 90, "<br />\n", 1);

if($line[9]>0){ echo "<h2>Child of Incident {$line['9']}</h2>"; };

echo "<table border=1 align=center width=600>";
echo "<tr><th>Date</th><th>User</th><th>Agent</th><th>Status</th><th>Severity</th></tr>";
echo "<tr><td>{$line[6]}</td><td>$full_name</td><td>$agent_name</td><td>{$line[4]}</td><td>{$line[8]}</td></tr>";
echo "<tr><th>Type</th><th colspan=4>Description</th></tr>";
echo "<tr><td>$type_name</td><td colspan=4>$wrapped</td></tr>";
echo "</table>";
echo "<br>";
echo "<table border=1 align=center width=600>";
echo "<tr><th colspan=3>Diary Entries</th></tr>";
echo "<tr><th>Date</th><th>Description</th><th>Agent</th></tr>";
foreach($nums as $num){
  $query = "SELECT date,text,agent FROM diary WHERE incident = '$num' ORDER BY number ASC;";
  $result = dbms_query($query);
  while($diaries = dbms_fetch_array($result, "NUM")){
    $moniker = agent_name($diaries[2]);
    echo "<tr><td>{$diaries[0]}</td><td>{$diaries[1]}</td><td>$moniker</td></tr>";
  };
  dbms_free_result($result);
};
echo "</table>";
echo "<br>";
echo "<table border=1 align=center width=600>";
echo "<tr><th>Resolution</th></tr>";
echo "<tr><td>{$line[5]}</td></tr>";
echo "</table>";
echo "<br>";

$query = "SELECT COUNT(number) FROM incident WHERE parent = '$incident';";
$result = dbms_query($query);
$line = dbms_fetch_array($result);
dbms_free_result($result);

if($line[0]>0){
  echo "<table border=1 align=center>";
  echo "<CAPTION><b>Children of Incident # $incident</b></CAPTION>";
  
  $query = "SELECT number,usr,agent,type,description,date,status,severity FROM incident WHERE parent = '$incident';";
  $result = dbms_query($query);
  while($line = dbms_fetch_array($result, "ASSOC")){
    echo "<tr>";
    
    if($line['status']=="Open"){$stat_color = "#00FF00";};
    if($line['status']=="Hold"){$stat_color = "#FFFF00";};
    if($line['status']=="Closed"){$stat_color = "#C0C0C0";};
    
    echo "<td bgcolor=$stat_color>{$line['number']}</td>";
    
    $query1 = "SELECT lname,fname FROM users WHERE number ='{$line['usr']}'";
    $result1 = dbms_query($query1);
    $line1 = dbms_fetch_array($result1, "ASSOC");
    dbms_free_result($result1);
    $print_name = $line1['lname'] . ", " . $line1['fname'];
    echo "<td bgcolor=$stat_color>$print_name</td>";
  
    if($line['severity']=="1"){$sev_color = "#FF0000";};
    if($line['severity']=="2"){$sev_color = "#FF9900";};
    if($line['severity']=="3"){$sev_color = "#FFFF00";};
    if($line['severity']=="4"){$sev_color = "#00FF00";};
    if($line['severity']=="5"){$sev_color = "#0000FF";};
    
    echo "<td bgcolor=$sev_color>{$line['severity']}</td>";
    
    $print_type = agent_name($line['agent']);
    echo "<td bgcolor=$stat_color>$print_type</td>";
    
    $print_type = type_name($line['type']);
    echo "<td bgcolor=$stat_color>$print_type</td>";
    
    echo "<td bgcolor=$stat_color>{$line['description']}</td>";
    
    echo "<td bgcolor=$stat_color>{$line['date']}</td>";
    
    echo "<td bgcolor=$stat_color>";
    echo "{$line['status']}";
    echo "</td>";
    
    echo "</tr>";
  };
  echo "</table>";
  dbms_free_result($result);
 };
  
echo "<br />";

$query = "SELECT date,action,agent,oldval,newval FROM audit WHERE incident=$incident ORDER BY number ASC;";
$result = dbms_query($query);

echo "<table border=1 align=center width=600>";
echo "<tr><th>Date</th><th>Change</th><th>Agent</th><th>Old Value</th><th>New Value</th></tr>";

while($line = dbms_fetch_array($result, "ASSOC")){
  echo "<tr>";
  echo "<td>{$line['date']}</td>";
  echo "<td>{$line['action']}</td>";
  echo "<td>{$line['agent']}</td>";
  echo "<td>{$line['oldval']}</td>";
  echo "<td>{$line['newval']}</td>";
  echo "</tr>";
};
echo "</table>";

dbms_free_result($result);

?>