<?php
 /*
   Tiquit Is Quality User Incident Tracking
   Copyright (C) 2006 Jonathan Ciesla
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
  */
require_once("config.php");
require_once("functionlib.php");
session_start();
favicon();

$link = dbms_connect($dbhost, $dbuser, $dbpass, $dbname);

echo "<link rel=stylesheet href=css.php>";

$user_id = dbms_escape_string($_SESSION['tiquitid']);

$query3 = "SELECT admin FROM agent where id = '$user_id';";
$result3 = dbms_query($query3);
$line3 = dbms_fetch_array($result3, "NUM");
$flag_me = $line3[0];
dbms_free_result($result3);

authentication($flag_me, 2);

$version = "2.5.1";

$query = "SELECT version FROM universal;";
$result = dbms_query($query);
$line = dbms_fetch_array($result, "NUM");
dbms_free_result($result);
$oldversion = $line[0];

//display db ver, code ver
echo "<table border=1 align=center>";
echo "<tr><th>Tiquit version</th><th>DB version</th></tr>";
echo "<tr><td align=center>$version</td><td align=center>$oldversion</td></tr>";
echo "</table>";

//if different, upgrade, metarefresh

if($version>$oldversion){
  
  if($dbtype=="my"){
    $query = "UPDATE `universal` SET `version` = '$version' WHERE 1;";
    dbms_query($query);
  
    if($oldversion<="1.1"){
      $query = "CREATE TABLE `locks` (`incident` VARCHAR(255) NOT NULL, `time` TIME NOT NULL, `id` VARCHAR(20) NOT NULL, PRIMARY KEY (`incident`) );";
      dbms_query($query);
    };
    if($oldversion<="1.4"){
      $query = "CREATE TABLE `audit` (`number` SMALLINT(8) NOT NULL, `incident` SMALLINT(8) NOT NULL, `action` VARCHAR(20) NOT NULL, `date` DATETIME NOT NULL, `by` VARCHAR(10) NOT NULL, `oldval` VARCHAR(20) NOT NULL, `newval` VARCHAR(20) NOT NULL, PRIMARY KEY (`number`) );";
      dbms_query($query);
    };
    
    if($oldversion<="1.7"){
      $query = "ALTER TABLE `incident` CHANGE `type` `type` SMALLINT(4) NOT NULL;";
      dbms_query($query);
    };
    
    if($oldversion<="1.8"){
      $query = "CREATE TABLE `files` (`number` SMALLINT(8) NOT NULL, `name` VARCHAR(50) NOT NULL, `content` LONGBLOB NOT NULL, `size` MEDIUMINT(8) NOT NULL, `incident` SMALLINT(8) NOT NULL, PRIMARY KEY (`number`) );";
      dbms_query($query);
    };
   
    if($oldversion<="1.9"){
      $query = "ALTER TABLE `incident` ADD `parent` SMALLINT(8) NULL;";
      dbms_query($query);
      
      $query = "ALTER TABLE `files` CHANGE `size` `size` MEDIUMINT(8) NOT NULL DEFAULT '0';";
      dbms_query($query);
    };
    
    if($oldversion<="1.9"){
      $query = "CREATE TABLE `knowledgebase` (`number` SMALLINT(8) NOT NULL, `topic` VARCHAR(50) NOT NULL, `text` TEXT NOT NULL, `lastagent` VARCHAR(10) NOT NULL, `date` DATETIME NOT NULL, PRIMARY KEY (`number`) );";
      dbms_query($query);
    };
    
    if($oldversion<="2.0"){
      $query = "ALTER TABLE `incident` CHANGE `number` `number` INT(11) NOT NULL DEFAULT '0';";
      dbms_query($query);
      
      $query = "ALTER TABLE `user` ADD `system` VARCHAR(8) NOT NULL;";
      dbms_query($query);
      
      $query = "ALTER TABLE `audit` CHANGE `incident` `incident` INT(11) NOT NULL DEFAULT '0', CHANGE `number` `number` INT(11) NOT NULL DEFAULT '0';";
      dbms_query($query);
      
      $query = "ALTER TABLE `diary` CHANGE `number` `number` INT(11) NOT NULL DEFAULT '0', CHANGE `agent` `agent` INT(4) NOT NULL DEFAULT '0', CHANGE `incident` `incident` INT(11) NOT NULL DEFAULT '0';";
      dbms_query($query);
      
      $query = "ALTER TABLE `files` CHANGE `incident` `incident` INT(11) NOT NULL DEFAULT '0', CHANGE `number` `number` INT(11) NOT NULL DEFAULT '0', CHANGE `name` `name` VARCHAR(260) NOT NULL DEFAULT '0';";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` CHANGE `severity` `severity` VARCHAR(1) NOT NULL DEFAULT '5';";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` CHANGE `parent` `parent` INT(8) NULL DEFAULT '0';";
      dbms_query($query);
      
      $query = "ALTER TABLE `location` CHANGE `enabled` `enabled` VARCHAR(1) NOT NULL DEFAULT '1';";
      dbms_query($query);
      
      $query = "ALTER TABLE `type` CHANGE `enabled` `enabled` VARCHAR(1) NOT NULL DEFAULT '1', CHANGE `name` `name` VARCHAR(50) NOT NULL DEFAULT '0';";
      dbms_query($query);
      
      $query = "ALTER TABLE `universal` CHANGE `notify` `notify` VARCHAR(1) NOT NULL DEFAULT '0';";
      dbms_query($query);
      
      $query = "ALTER TABLE `user` CHANGE `enabled` `enabled` VARCHAR(1) NOT NULL DEFAULT '1';";
      dbms_query($query);
      
      $query = "ALTER TABLE `agent` CHANGE `group` `grp` VARCHAR(20) NOT NULL, CHANGE `number` `number` INT(4) NOT NULL DEFAULT '0';";
      dbms_query($query);
      
      $query = "ALTER TABLE `audit` CHANGE `by` `agent` VARCHAR(10) NOT NULL;";
      dbms_query($query);
      
      $query = "ALTER TABLE `user` RENAME `users`;";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` CHANGE `user` `usr` SMALLINT(6) NOT NULL DEFAULT '0';";
      dbms_query($query);
    
      $query = "ALTER TABLE `universal` ADD `textsize` VARCHAR(8) NOT NULL DEFAULT 'small',ADD `tabletextsize` VARCHAR(8) NOT NULL DEFAULT 'x-small';";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` CHANGE `agent` `agent` SMALLINT(4) NULL DEFAULT '';";
      dbms_query($query);
      
      $query = "ALTER TABLE `users` ADD `authcode` VARCHAR (15) NULL;";
      dbms_query($query);
    };
    
    if($oldversion<="2.1"){
      $query = "ALTER TABLE `users` ADD UNIQUE `users.authcode.unique` (`authcode`);";
      dbms_query($query);
    };
    
    if($oldversion<="2.2"){
      $query = "ALTER TABLE `files` ADD `mime` VARCHAR (50) NULL;";
      dbms_query($query);
      
      $query = "DROP TABLE `file_purge`;";
      dbms_query($query);
      
      $query = "ALTER TABLE `knowledgebase` CHANGE `number` `number` INT(11) NULL DEFAULT '';";
      dbms_query($query);
      
      $query = "ALTER TABLE `universal` ADD `theme` INT (11) DEFAULT '0';";
      dbms_query($query);
      
      $query = "CREATE TABLE `theme` (  `number` int(11) NOT NULL,  `name` varchar(20) NOT NULL,  `background` varchar(6) NOT NULL,  `table_background` varchar(6) NOT NULL,  `table_border` varchar(6) NOT NULL,  PRIMARY KEY  (`number`));";
      dbms_query($query);
      
      $query = "INSERT INTO `theme` ( `number` , `name` , `background` , `table_background` , `table_border` ) VALUES ('0', 'Default', 'CCCCCC', '3399FF', '333366');";
      dbms_query($query);
      
      $query = "ALTER TABLE `universal` ADD `user_sub` VARCHAR(1) NOT NULL DEFAULT '0', ADD `user_search` VARCHAR(1) NOT NULL DEFAULT '0', ADD `user_reg` VARCHAR(1) NOT NULL DEFAULT '0';";
      dbms_query($query);
    };

    if($oldversion<="2.3"){
      $query = "ALTER TABLE `incident` ADD FULLTEXT `fulltext.inc.dec` ( `description` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` ADD FULLTEXT `fulltext.inc.res` ( `resolution` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `diary` ADD FULLTEXT `fulltext.dia.tex` ( `text` );";
      dbms_query($query);

      $query = "ALTER TABLE `incident` ADD INDEX `index.inc.usr` ( `usr` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` ADD INDEX `index.inc.typ` ( `type` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `users` ADD INDEX `index.usr.loc` ( `location` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `users` ADD INDEX `index.usr.dep` ( `dept` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` ADD INDEX `index.inc.age` ( `agent` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `knowledgebase` ADD FULLTEXT `fulltext.kno.tex` ( `text` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `audit` ADD FULLTEXT `fulltext.aud.act` ( `action` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `audit` ADD INDEX `index.aud.inc` ( `incident` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` ADD `logged` SMALLINT( 4 ) NOT NULL DEFAULT '0';";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` ADD INDEX `index.inc.log` ( `logged` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` ADD `closer` SMALLINT( 4 ) NOT NULL DEFAULT '0';";
      dbms_query($query);
      
      $query = "ALTER TABLE `incident` ADD INDEX `index.inc.clo` ( `closer` );";
      dbms_query($query);
      
      $query = "ALTER TABLE `universal` ADD `res_text` TEXT NOT NULL;";
      dbms_query($query);
      
      $query = "ALTER TABLE `universal` ADD `use_res_text` VARCHAR(1) NOT NULL DEFAULT '0';";
      dbms_query($query);

    };

    if($oldversion<="2.4"){
      $query = "CREATE TABLE `reports` ( `number` int(11) NOT NULL, `title` varchar(50) NOT NULL, `owner` smallint(4) NOT NULL, `ag` varchar(1) default NULL, `agent` text, `gr` varchar(1) default NULL, `grp` text, `us` varchar(1) default NULL, `usr` text, `lo` varchar(1) default NULL, `location` text, `status` varchar(1) default NULL, `status1` text, `severity` varchar(1) default NULL, `severity1` text, `type` varchar(1) default NULL, `type1` text, `logged` varchar(1) default NULL, `logged1` text, `closer` varchar(1) default NULL, `closer1` text, PRIMARY KEY  (`number`)) ENGINE=MyISAM DEFAULT CHARSET=latin1;";
      dbms_query($query);

      $query = "ALTER TABLE `universal` ADD `name` VARCHAR(50) NOT NULL DEFAULT '0';";
      dbms_query($query);

    };

  };
  if($dbtype=="pg"){
    
    $query = "UPDATE universal SET version = '$version';";
    dbms_query($query);
    
    if($oldversion<="2.2"){
      $query = "ALTER TABLE files ADD mime VARCHAR(50) NULL;";
      dbms_query($query);
      
      $query = "DROP TABLE file_purge;";
      dbms_query($query);

      $query = "ALTER TABLE diary ALTER COLUMN number TYPE integer DEFAULT 0 NOT NULL;";
      dbms_query($query);
      
      $query = "ALTER TABLE files ALTER COLUMN number TYPE integer DEFAULT 0 NOT NULL;";
      dbms_query($query);
      
      $query = "ALTER TABLE files ALTER COLUMN name TYPE character varying(260);";
      dbms_query($query);
      
      $query = "ALTER TABLE knowledgebase ALTER COLUMN number TYPE integer DEFAULT 0 NOT NULL;";
      dbms_query($query);
      
      $query = "ALTER TABLE type ALTER COLUMN name TYPE character varying(50);";
      dbms_query($query);
      
      $query = "ALTER TABLE universal ADD theme integer DEFAULT 1 NOT NULL;";
      dbms_query($query);
      
      $query = "CREATE TABLE theme (number integer DEFAULT 0 NOT NULL, name character varying(20) NOT NULL, background character varying(6) NOT NULL, table_background character varying(6) NOT NULL, table_border character varying(6) NOT NULL);";
      dbms_query($query);
      
      $query = "INSERT INTO theme ( number , name , background , table_background , table_border ) VALUES ('0', 'Default', 'CCCCCC', '3399FF', '333366');";
      dbms_query($query);
      
      $query = "ALTER TABLE universal ADD user_sub character varying(1) DEFAULT 0 NOT NULL, ADD user_search character varying(1) DEFAULT 0 NOT NULL, ADD user_reg character varying(1) DEFAULT 0 NOT NULL;";
      dbms_query($query);
    };

    if($oldversion<="2.3"){
      $query = "ALTER TABLE incident ADD logged smallint DEFAULT 0 NOT NULL;";
      dbms_query($query);
      
      $query = "ALTER TABLE incident ADD closer smallint DEFAULT 0 NOT NULL;";
      dbms_query($query);
      
      $query = "ALTER TABLE universal ADD res_text text NOT NULL;";
      dbms_query($query);
      
      $query = "ALTER TABLE universal ADD use_res_text character varying(1) DEFAULT 0 NOT NULL;";
      dbms_query($query);

    };
    
    if($oldversion<="2.4"){
      $query = "CREATE TABLE reports (number integer DEFAULT 0 NOT NULL, title character varying(50) NOT NULL, owner smallint NOT NULL, ag character varying(1), agent text, gr character varying(1), grp text, us character varying(1), usr text, lo character varying(1), location text, status character varying(1), status1 text, severity character varying(1), severity1 text, type character varying(1), type1 text, logged character varying(1), logged1 text, closer character varying(1), closer1 text);";
      dbms_query($query);
      
      $query = "ALTER TABLE universal ADD name character varying(50) DEFAULT 0 NOT NULL;";
      dbms_query($query);
      
    };  
    
  };
  
  if($oldversion<="2.2"){
    $query = "SELECT number,name,content FROM files WHERE mime = '';";
    $result = dbms_query($query);
    while($line=dbms_fetch_array($result, "ASSOC")){
      file_put_contents($line['name'], $line['content']);
      $mime = mime_content_type($line['name']);
      unlink($line['name']);
      $query1 = "UPDATE files SET mime = '$mime' WHERE number = '{$line['number']}';";
      $result1 = dbms_query($query1);
    };
    dbms_free_result($result);
  };
  
  if($oldversion<="2.4"&&$oldversion>="2.3"){
    //closer, logged guess
    $query = "SELECT number,agent,status,logged,closer FROM incident ORDER BY number;";
    $result = dbms_query($query);
    while($line = dbms_fetch_array($result, "ASSOC")){
      //logged
      if($line['logged']=="0"){
	$query1 = "SELECT agent,COUNT(number) FROM audit WHERE action = 'Agent' ORDER BY date ASC LIMIT 1;";
	$result1 = dbms_query($query1);
	$line1 = dbms_fetch_array($result1, "NUM");
	dbms_free_result($result1);
	
	if($line1['1']>0){
	  //convert id to number
	  $query3 = "SELECT number FROM agent WHERE id = '{$line1['0']}';";
	  $result3 = dbms_query($query3);
	  $line3 = dbms_fetch_array($result3, "NUM");
	  dbms_free_result($result3);
	  $agent_number = $line3['0'];
	} else {
	  $agent_number = $line['agent'];
	};
	
	$query2 = "UPDATE incident SET logged = '$agent_number' WHERE number = '{$line['number']}';";
	$result2 = dbms_query($query2);
	
      };
      
      //closer
      if($line['status']=="Closed"&&$line['closer']=="0"){
	$query1 = "SELECT agent,COUNT(number) FROM audit WHERE action = 'Status' ORDER BY date DESC LIMIT 1;";
	$result1 = dbms_query($query1);
	$line1 = dbms_fetch_array($result1, "NUM");
	dbms_free_result($result1);

	if($line1['1']>0){
	  //convert id to number
	  $query3 = "SELECT number FROM agent WHERE id = '{$line1['0']}';";
	  $result3 = dbms_query($query3);
	  $line3 = dbms_fetch_array($result3, "NUM");
	  dbms_free_result($result3);
	  $agent_number = $line3['0'];
	} else {
	  $agent_number = $line['agent'];
	};
	
	$query2 = "UPDATE incident SET closer = '$agent_number' WHERE number = '{$line['number']}';";
	$result2 = dbms_query($query2);
      };
    };
    dbms_free_result($result);
  };
  
  //meta-refresh
  echo "<meta http-equiv=refresh content=5;url=$siteaddress/upgrade.php />";
  
 } else {  //end update
  echo "<br />Tiquit DB is up to date.<br />";
 };
//back button
echo "<form action=univ.php method=post>";
echo "<input type=submit value=Back />";
echo "</form>";

?>