#include <tcqdb.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>

int main(int argc, char **argv){
  TCQDB *qdb;
  int ecode, rnum, i;
  uint64_t *result;

  /* create the object */
  qdb = tcqdbnew();

  /* open the database */
  if(!tcqdbopen(qdb, "casket", QDBOWRITER | QDBOCREAT)){
    ecode = tcqdbecode(qdb);
    fprintf(stderr, "open error: %s\n", tcqdberrmsg(ecode));
  }

  /* store records */
  if(!tcqdbput(qdb, 1, "George Washington") ||
     !tcqdbput(qdb, 2, "John Adams") ||
     !tcqdbput(qdb, 3, "Thomas Jefferson")){
    ecode = tcqdbecode(qdb);
    fprintf(stderr, "put error: %s\n", tcqdberrmsg(ecode));
  }

  /* search records */
  result = tcqdbsearch(qdb, "John", QDBSSUBSTR, &rnum);
  if(result){
    for(i = 0; i < rnum; i++){
      printf("%d\n", (int)result[i]);
    }
    free(result);
  } else {
    ecode = tcqdbecode(qdb);
    fprintf(stderr, "search error: %s\n", tcqdberrmsg(ecode));
  }

  /* close the database */
  if(!tcqdbclose(qdb)){
    ecode = tcqdbecode(qdb);
    fprintf(stderr, "close error: %s\n", tcqdberrmsg(ecode));
  }

  /* delete the object */
  tcqdbdel(qdb);

  return 0;
}
