/***************************************************************************
practice.c 
-  description: practice module
-------------------
begin                : Friday Jan 25, 2003
copyright            : (C) 2003 by Jesse Andrews
email                : jdandr2@uky.edu
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "globals.h"
#include "funcs.h"

SDL_Surface *hands;
SDL_Surface *hand[11];
SDL_Rect hand_loc, letter_loc;
TTF_Font *font;

Mix_Chunk *wrong;

void practice_load_media(void) {
	int i;	
	unsigned char fn[FNLEN];
	unsigned char let[5];

	LOG("Loading practice media\n");
	for (i=0; i<10; i++) {
		sprintf(fn, "hands/%d.png", i);
		hand[i] = LoadImage(fn, IMG_ALPHA);
	}
	hands = LoadImage("hands/hands.png", IMG_ALPHA);

	hand_loc.x = (screen->w/2) - (hand[0]->w/2);
	hand_loc.y = screen->h - (hand[0]->h);
	hand_loc.w = (hand[0]->w);
	hand_loc.h = (hand[0]->h);

	bkg = LoadImage("main_bkg.png", IMG_ALPHA);

	font = LoadFont( ttf_font, 72 );

	wrong = LoadSound("tock.wav");

	let[1]=0;
	for (i=1; i<255; i++)
		if (ALPHABET[i]) {
			let[0]=i;
			letters[i] = black_outline(let, font, &white); 
		}

	LOG("DONE - Loading practice media\n");
}

void practice_unload_media(void) {
	int i;
	SDL_FreeSurface(bkg);
	SDL_FreeSurface(hands);
	TTF_CloseFont(font);

	for (i=0; i<10; i++) 
		SDL_FreeSurface(hand[i]);

	for (i=1; i<255; i++) 
		if (ALPHABET[i]) 
			SDL_FreeSurface(letters[i]);

	Mix_FreeChunk(wrong);
}

void show(unsigned char t) {
	SDL_Rect dst;
	dst.x = 320 - (letters[(int)t]->w/2);
	dst.y = 100;
	dst.w = letters[(int)t]->w;
	dst.h = letters[(int)t]->h;
	SDL_BlitSurface(letters[(int)t], NULL, screen, &dst);
}

int Practice(void) {
	unsigned char cur_letter=0;
	int quit=0, i;
	Uint32 start=0;
	int state=0;
	practice_load_media();
	do {
		switch (state) {
			case 0:
				start = SDL_GetTicks();
				SDL_BlitSurface(bkg, NULL, screen, NULL);
				SDL_BlitSurface(hands, NULL, screen, &hand_loc);
				cur_letter = get_letter();
				show(cur_letter);
				SDL_Flip(screen);
				state = 1;
				break;
			case 1:
				if (SDL_GetTicks() - start > 500) {
					for (i=0; i<10; i++)
						if (FINGER[(int)cur_letter][i])
							SDL_BlitSurface(hand[i], NULL, screen, &hand_loc);
					SDL_Flip(screen);
					state = 2;
				}
				break;
			case 2:
				if (state == 2 && SDL_GetTicks() - start > 1500) {
					state = 3;
				}
				break;
			case 3:
				SDL_BlitSurface(hands, NULL, screen, &hand_loc);
				SDL_Flip(screen);
				state = 12;
				break;
			case 4:
				for (i=0; i<10; i++)
					if (FINGER[(int)cur_letter][i])
						SDL_BlitSurface(hand[i], NULL, screen, &hand_loc);
				SDL_Flip(screen);
				state = 11;
				break;
			default:
				state -= 2; // this is to make the flashing slower
		}

		while (SDL_PollEvent(&event)) {
			if (event.type == SDL_QUIT)
				quit = 1;
			if (event.type == SDL_KEYDOWN) {
				if (event.key.keysym.sym == SDLK_ESCAPE)
					quit = 1;
				if (KEYMAP[event.key.keysym.unicode & 0xff] == cur_letter)
					state = 0;
				else
					playsound(wrong);
			}

		}
		SDL_Delay(33);
	} while (!quit);
	practice_unload_media();
	return 1;
}

