/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkXGPUInfoList.h,v $

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkXGPUInfoList - Get GPUs VRAM information using X server
// extensions.
// .SECTION Description
// vtkXGPUInfoList implements Probe() method of vtkGPUInfoList
// through some X server extensions API. NV-CONTROL for Nvidia.
// ATIFGLEXTENSION for ATI is not supported yet.
// There is no support for other vendors.
// .SECTION See Also
// vtkGPUInfo vtkGPUInfoList

#ifndef __vtkXGPUInfoList_h
#define __vtkXGPUInfoList_h

#include "vtkGPUInfoList.h"

class VTK_RENDERING_EXPORT vtkXGPUInfoList : public vtkGPUInfoList
{
public:
  static vtkXGPUInfoList* New();
  vtkTypeRevisionMacro(vtkXGPUInfoList, vtkGPUInfoList);
  void PrintSelf(ostream& os, vtkIndent indent);
  
  // Description:
  // Build the list of vtkInfoGPU if not done yet.
  // \post probed: IsProbed()
  virtual void Probe();
  
protected:
  // Description:
  // Default constructor.
  vtkXGPUInfoList();
  virtual ~vtkXGPUInfoList();
 
private:
  vtkXGPUInfoList(const vtkXGPUInfoList&); // Not implemented.
  void operator=(const vtkXGPUInfoList&); // Not implemented.
};

#endif
