class Settings < Qt::Settings

  private_class_method :new

  @@instance = nil
  
  def initialize(parent)
    super($webkam_app.name, $webkam_app.name, parent)
  end

  def set_accelerate_video_render(accel_vid)
    set_value('Accelerated Video', Qt::Variant.new(accel_vid))
  end

  def set_flash(flash)
    set_value('Flash', Qt::Variant.new(flash))
  end

  def set_webcam(webcam)
    set_value('Webcam Device', Qt::Variant.new(webcam['device']))
    set_value('Webcam Resolution', Qt::Variant.new(Qt::Size.new(webcam['resolution'][0], webcam['resolution'][1])))
  end

  def set_video_path(path)
    set_value('Video Path', Qt::Variant.new(path))
  end

  def set_photo_path(path)
    set_value('Photo Path', Qt::Variant.new(path))
  end
  
  def accelerate_video_render
    value('Accelerated Video', Qt::Variant.new(true)).to_bool
  end

  def webcam
    unless webcams = $dev_pool.webcams
      @webcam = nil
      return nil
    end

    @webcam = {}

    device = value('Webcam Device', Qt::Variant.new('')).to_string

    return @webcam if @webcam['device'] == device

    unless device.empty?
      webcams.each do |dev, name|
        if dev == device
          stream = WebcamVideoStream.instance(dev)

          res_size = value('Webcam Resolution', Qt::Variant.new(Qt::Size.new(0, 0))).to_size
          res = [res_size.width, res_size.height]

          if stream.resolutions.include?(res)
            @webcam['device'] = dev
            @webcam['name'] = name
            @webcam['resolution'] = res
            stream.set_resolution(res)
          else
            break
    end end end end

    if @webcam.empty?
      default_wc = webcams.to_a.sort[0]

      @webcam['device'] = default_wc[0]
      @webcam['name'] = default_wc[1]
      @webcam['resolution'] = WebcamVideoStream.instance(default_wc[0]).resolutions.max
    end

    @webcam
  end

  def flash
    value("Flash", Qt::Variant.new(true)).to_bool
  end

  def video_path
    default = Qt::DesktopServices::storageLocation(Qt::DesktopServices::MoviesLocation) + '/Webcam/'
    value('Video Path', Qt::Variant.new(default)).to_string
  end

  def photo_path
    default = Qt::DesktopServices::storageLocation(Qt::DesktopServices::PicturesLocation) + '/Webcam/'
    value('Photo Path', Qt::Variant.new(default)).to_string
  end

  def self.instance(parent = nil)
    return @@instance ? @@instance : new(parent)
  end

end
