/* WhySynth DSSI software synthesizer GUI
 *
 * Copyright (C) 2004-2007 Sean Bolton
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#ifndef _GUI_POPMENU_H
#define _GUI_POPMENU_H

#include <gtk/gtk.h>

typedef struct _popmenu       popmenu;
typedef struct _popmenuitem   popmenuitem;
typedef struct _popmenubutton popmenubutton;

typedef void (*popmenu_activation_callback)(popmenu *pm,
                                            popmenuitem *pmi);
typedef void (*popmenubutton_activation_callback)(popmenubutton *pmb,
                                                  popmenuitem *pmi);

struct _popmenuitem {
    popmenuitem *next;
    const char  *label;
    int          sort;
    int          id;
    int          isbranch;
    /* for branches: */
    popmenuitem *nodelist;
    /* for leaves: */
    GtkWidget   *menuitem;
};

struct _popmenu {
    GtkWidget   *menu;
    GSList      *radiogroup;
    popmenuitem *nodelist;
    gint         width;
    popmenu_activation_callback
                 activation_callback;
    void        *user_data;
};

struct _popmenubutton {
    GtkWidget *button;
    GtkWidget *label;
    popmenu   *menu;
    int        id;
    popmenubutton_activation_callback
               activation_callback;
    void      *user_data;
};

popmenu    *popmenu_new(void);
void        popmenu_add(popmenu *p, const char *path, int sort, int id);
void        popmenu_build(popmenu *p, popmenu_activation_callback func);
int         popmenu_set_active(popmenu *p, int id);
void        popmenu_popup(popmenu *p, GdkEventButton *event);
const char *popmenu_get_label_from_id(popmenu *p, int id);

popmenubutton *popmenubutton_new(popmenu *pm, int initial_id,
                                 popmenubutton_activation_callback func);
int            popmenubutton_set_popmenu_and_id(popmenubutton *pmb,
                                                popmenu *pm, int id);
void           popmenubutton_on_menuitem_activate(popmenu *pm,
                                                  popmenuitem *pmi);

#endif /* _GUI_POPMENU_H */

