/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <libxfce4util/libxfce4util.h>

#include "about_dialog.h"
#include "debug.h"
#include "xfbib.h"

void show_about_dialog(void)
{
	_DEBUG(("show_about_dialog"));
	const gchar *authors[] = {
		_("Developers:"),
		N_("David Gustafsson <david.s.gustafsson@gmail.com>"),
		N_("Jesper Karlsson <zarper@gmail.com>"),
		NULL};

	GtkWidget *dialog = gtk_about_dialog_new();

	gtk_about_dialog_set_name((GtkAboutDialog *)dialog, PACKAGE_NAME);
	gtk_about_dialog_set_version((GtkAboutDialog *)dialog, PACKAGE_VERSION);

	gtk_about_dialog_set_comments((GtkAboutDialog *)dialog, _("BibTeX editor for Xfce"));
	gtk_about_dialog_set_website((GtkAboutDialog *)dialog,  N_("http://goodies.xfce.org/projects/applications/xfbib"));
	gtk_about_dialog_set_logo_icon_name((GtkAboutDialog *)dialog, "xfbib");
	gtk_about_dialog_set_authors((GtkAboutDialog *)dialog, authors);
	gtk_about_dialog_set_license((GtkAboutDialog *)dialog, xfce_get_license_text(XFCE_LICENSE_TEXT_GPL));

	gtk_about_dialog_set_copyright((GtkAboutDialog *)dialog, N_("Copyright \302\251 2008 Jesper Karlsson & David Gustafsson"));

	gtk_dialog_run(GTK_DIALOG(dialog));
	// Wait for user to click the OK button.
	gtk_widget_destroy(dialog);
}
