/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __NODE_H
#define __NODE_H
enum {
	ENTRY_NODE = 0,
	PREAMBLE_NODE,
	STRING_NODE,
	COMMENT_NODE,
};

struct node {
	int node_type;
	struct node *next;
	void *node;
};

struct entry *add_entry(struct node**, char*, char*);
void add_preamble(struct node**, char*);
void add_comment(struct node**, char*);
void add_string(struct node**, char*, char*);
void add_tag(struct entry*, char*, char*, int);
void remove_tags(struct entry*);
void print_list(struct node*);
void write_list(struct node*, FILE*);
void free_list(struct node*);
void remove_node(struct node**, struct node*);
char *get_tag_value(struct entry*, char*);

#endif //__NODE_H
