/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>

#include "parser_interface.h"
#include "debug.h"
#include "entry.h"
#include "tag.h"

extern int yyparse(void);
extern FILE *yyin;
extern int yylineno;
extern void yysetnodelist(struct node**);

void parse_file(struct xfbib *xfbib)
{
	_DEBUG(("parse_file"));

	yysetnodelist(&(xfbib->list));
	
	yylineno = 0;
	yyin = fopen(xfbib->filename, "r");

	if (yyparse() == 0) {
		_DEBUG(("Parsed successfully"));
	} else {
		_DEBUG(("Error parsing file %s", xfbib->filename));
	}
	fclose(yyin);
}
