/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libintl.h>
#include <libxfcegui4/libxfcegui4.h>
#include <config.h>

#include "xfbib.h"
#include "save_dialog.h"
#include "node.h"
#include "window.h"
#include "debug.h"
#include "save.h"

void show_save_dialog(struct xfbib *xfbib)
{
	_DEBUG(("show_save_dialog"));
	GtkWidget *dialog;

	dialog = gtk_file_chooser_dialog_new(_("Save As"), NULL, GTK_FILE_CHOOSER_ACTION_SAVE,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE,
			GTK_RESPONSE_ACCEPT, NULL);

	GtkFileFilter *filter;
	filter = gtk_file_filter_new();
		gtk_file_filter_set_name(filter, _("BibTeX files"));
		gtk_file_filter_add_pattern(filter, N_("*.bib"));
		gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(dialog), filter);
	filter = gtk_file_filter_new();
		gtk_file_filter_set_name(filter, _("All files"));
		gtk_file_filter_add_pattern(filter, N_("*"));
		gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(dialog), filter);

	if(gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT) {
		xfbib->filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(dialog));
		save(xfbib);
		_DEBUG(("Saving as: %s", xfbib->filename));
		gtk_window_set_title(GTK_WINDOW(xfbib->window.window), create_title(xfbib));
	}

	gtk_widget_destroy(dialog);
}
