/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <libxfcegui4/libxfcegui4.h>

#include "debug.h"
#include "strings.h"
#include "node.h"
#include "xfbib.h"
#include "treeview.h"

#define VARIABLE 0
#define VALUE 1

static void set_entry_text(GtkEntry *entry, char *text)
{
	_DEBUG(("set_entry_text"));
	if (text != NULL && entry != NULL)
		gtk_entry_set_text(entry, text);
}

void show_string_edit_dialog(struct xfbib *xfbib, struct string *selected)
{
	_DEBUG(("show_string_edit_dialog"));

	GtkWidget *dialog, *hbox[2], *label[2], *entry[2];
	int i;
	const char *label_strings[] = {_("Variable name: "), _("Value: ")};

	xfce_textdomain (PACKAGE, LOCALEDIR, "ISO-8859-1");
	dialog = xfce_titled_dialog_new_with_buttons ((selected == NULL) ? _("Add variable") : _("Edit variable"), NULL,
						GTK_DIALOG_MODAL,
						GTK_STOCK_OK, GTK_RESPONSE_OK,
						GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
						NULL);
	gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
	
	gtk_window_set_icon_name(GTK_WINDOW(dialog), "xfbib");
	
	for (i = 0; i < 2; i++) {
		hbox[i] = gtk_hbox_new(FALSE, 10);
		label[i] = gtk_label_new(label_strings[i]);
		entry[i] = gtk_entry_new();
		gtk_box_pack_start (GTK_BOX (hbox[i]), label[i], FALSE, FALSE, 10);
		gtk_box_pack_end (GTK_BOX (hbox[i]), entry[i], FALSE, FALSE, 10);
		gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox[i], FALSE, FALSE, 10);
	}

	if (selected != NULL) {
		set_entry_text(GTK_ENTRY(entry[VARIABLE]), selected->variable);
		set_entry_text(GTK_ENTRY(entry[VALUE]), selected->value);
	}
	
	gtk_widget_show_all(dialog);

	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK) {
		_DEBUG(("Response OK"));
		if (selected != NULL) {
			change_variable(selected, (char *) gtk_entry_get_text(GTK_ENTRY(entry[VARIABLE])));
			change_value(selected, (char *) gtk_entry_get_text(GTK_ENTRY(entry[VALUE])));
		} else {
			add_string(&xfbib->list, (char *) gtk_entry_get_text(GTK_ENTRY(entry[VARIABLE])), (char *) gtk_entry_get_text(GTK_ENTRY(entry[VALUE])));
		}
		update_treeview(xfbib);
	} else {
		_DEBUG(("Response Cancel"));
	}
	gtk_widget_destroy (dialog);
}
