/*
Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
*/

#ifndef BURNAUDIOIMAGETHREAD_H
#define BURNAUDIOIMAGETHREAD_H

#include <QProcess>
#include <QThread>
#include <QTimer>

class BurnAudioImageThread : public QThread
{
    Q_OBJECT

    public:
        BurnAudioImageThread(QObject* parent, const QString& device, const QStringList &filenames);
        void run();

    private slots:
        void processFinished(int);
        void processError(QProcess::ProcessError);
        void updateProgress();
        void cancelProcess();

    signals:
        void trackSize(int);
        void trackProgress(int);
        void trackNumber(QString);

    private:
        QString m_device;
        QStringList m_filenames;

        QProcess m_process;
        QProcess m_convertProcess;

        QTimer m_timer;

        int m_numberOfTracks;
        int m_currentTrackNumber;
        int m_currentTrackSize;

        bool m_hadError;
        bool m_wasCanceled;
};

#endif // BURNAUDIOIMAGETHREAD_H
