/*

Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

*/

#include <QDebug>
#include <QFile>
#include <QFileInfo>
#include <QMimeData>
#include <QUrl>

#include <KIcon>

#include "projectmodel.h"
#include "audiofile.h"

bool ProjectModel::dropMimeData(const QMimeData* data, Qt::DropAction action, int row, int column, const QModelIndex& parent)
{
    QStandardItem *tItem = new QStandardItem;
    tItem->setText(m_currentItemText);
    tItem->setData(m_currentItemData, 32);

    if (item(0)->data(0) == "Audio Disc" || item(0)->data(0) == "MP3 Disc") {
        tItem->setIcon(KIcon("audio-x-wav"));
        tItem->setDropEnabled(false);

        QStandardItem *songArtist = new QStandardItem;
        QStandardItem *songTitle = new QStandardItem;
        QStandardItem *songLength = new QStandardItem;
        QStandardItem *songSize = new QStandardItem;

        AudioFile *songFile = new AudioFile(m_currentItemData);

        songArtist->setText(songFile->trackArtist());
        songArtist->setIcon(KIcon("view-media-artist"));
        songArtist->setDragEnabled(false);
        songArtist->setDropEnabled(false);
        songArtist->setSelectable(false);
        songTitle->setText(songFile->trackTitle());
        songTitle->setIcon(KIcon("mixer-microphone"));
        songTitle->setDragEnabled(false);
        songTitle->setDropEnabled(false);
        songTitle->setSelectable(false);
        songLength->setText(songFile->trackLength());
        songLength->setIcon(KIcon("mixer-pcm-default"));
        songLength->setEditable(false);
        songLength->setDragEnabled(false);
        songLength->setDropEnabled(false);
        songLength->setSelectable(false);
        songSize->setText(songFile->trackSize());
        songSize->setIcon(KIcon("server-database"));
        songSize->setEditable(false);
        songSize->setDragEnabled(false);
        songSize->setDropEnabled(false);
        songSize->setSelectable(false);

        tItem->appendRows(QList<QStandardItem*>() << songArtist << songTitle << songLength << songSize);
    } else if (item(0)->data(32).toString().left(4) == "Data") {
        tItem->setIcon(KIcon("application-octet-stream"));
        tItem->setDropEnabled(false);
        if (QFileInfo(tItem->data(32).toString()).isDir()) {
            tItem->setIcon(KIcon("directory"));
            tItem->setDropEnabled(true);
        }
    }

    qDebug() << "dropMimeData(), row: " << row;

    if(row == -1) { row = 0; }

    itemFromIndex(parent)->insertRow(row, tItem);

    return true;
}

void ProjectModel::setCurrentItem(const QModelIndex& index)
{
    m_currentItem = index;
    if (itemFromIndex(index)->data(32).toString().isEmpty()) {
        return;
    }
    m_currentItemText = itemFromIndex(index)->text();
    m_currentItemData = itemFromIndex(index)->data(32).toString();
}
