/*
Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
*/

#ifndef RIPTHREAD_H
#define RIPTHREAD_H

#include <QProcess>
#include <QString>
#include <QThread>
#include <QTimer>

#include <solid/opticaldisc.h>

class RipThread : public QThread
{
    Q_OBJECT

    public:
        RipThread(QObject* parent, const QString &device, const QString &filetype, Solid::OpticalDisc::ContentTypes disctype);
        void run();

    private slots:
        void processFinished(int);
        void processError(QProcess::ProcessError);
        void updateProgress();
        void cancelProcess();

    signals:
        void discCapacity(int);
        void progressMonitor(int);
        void trackNumber(QString);

    private:
        QString m_device;
        QString m_fileType;

        QProcess m_process;

        QTimer m_timer;

        Solid::OpticalDisc::ContentTypes m_discType;

        bool m_hadError;
        bool m_wasCanceled;

        int m_pid;
        int m_progress;
        int m_trackProgress;
        int m_trackCount;
        int m_currentTrack;
};

#endif // RIPTHREAD_H
