/*
 * Decompiled with CFR 0.152.
 */
package de.abelssoft.wordtools.jWordSplitter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWordSplitter {
    private Set<String> words = null;
    private boolean hideConnectingCharacters = true;
    private boolean strictMode = false;
    protected String plainTextDictFile = null;

    protected abstract Set<String> getWordList() throws IOException;

    protected abstract int getMinimumWordLength();

    protected abstract Collection<String> getConnectingCharacters();

    public AbstractWordSplitter(boolean bl) throws IOException {
        this(bl, null);
    }

    public AbstractWordSplitter(boolean bl, String string) throws IOException {
        this.hideConnectingCharacters = bl;
        this.plainTextDictFile = string;
        this.words = this.getWordList();
    }

    public AbstractWordSplitter() throws IOException {
        this(true);
    }

    public void setStrictMode(boolean bl) {
        this.strictMode = bl;
    }

    private boolean isWord(String string) {
        if (string == null) {
            return false;
        }
        if (string.trim().length() < this.getMinimumWordLength()) {
            return false;
        }
        return this.words.contains(string.toLowerCase().trim());
    }

    public Collection<String> splitWord(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        String string2 = string.trim();
        if (string2.length() < 2) {
            arrayList.add(string2);
            return arrayList;
        }
        Collection<String> collection = this.findTupel(string2);
        if (collection == null && !this.strictMode) {
            collection = this.truncateSplit(string2);
        }
        if (collection == null && !this.strictMode) {
            collection = this.truncateSplitReverse(string2);
        }
        if (collection == null) {
            arrayList.add(string);
        } else {
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    private Collection<String> truncateSplit(String string) {
        for (int i = 0; i < string.length() - 2; ++i) {
            Collection<String> collection = this.findTupel(string.substring(i));
            if (collection == null) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.strictMode && !this.isWord(string.substring(0, i))) continue;
            arrayList.add(string.substring(0, i));
            arrayList.addAll(collection);
            return arrayList;
        }
        return null;
    }

    private Collection<String> truncateSplitReverse(String string) {
        for (int i = string.length() - 1; i > 1; --i) {
            Collection<String> collection = this.findTupel(string.substring(0, i));
            if (collection == null || this.strictMode && !this.isWord(string.substring(i))) continue;
            collection.add(string.substring(i));
            return collection;
        }
        return null;
    }

    private String removeTailingCharacters(String string) {
        Collection<String> collection = this.getConnectingCharacters();
        for (String string2 : collection) {
            if (!string.toUpperCase().endsWith(string2.toUpperCase())) continue;
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    private Collection<String> findTupel(String string) {
        String string2 = string;
        String string3 = "";
        if (string.length() < 2) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            string3 = string3 + string.charAt(i);
            string2 = string.substring(string3.length());
            if (!this.isWord(this.removeTailingCharacters(string3))) continue;
            if (this.hideConnectingCharacters) {
                arrayList.add(this.removeTailingCharacters(string3));
            } else {
                arrayList.add(string3);
            }
            Collection<String> collection = this.findTupel(string2);
            if (collection == null) {
                arrayList = new ArrayList();
                continue;
            }
            arrayList.addAll(collection);
            return arrayList;
        }
        if (!this.isWord(this.removeTailingCharacters(string))) {
            return null;
        }
        if (this.hideConnectingCharacters) {
            arrayList.add(this.removeTailingCharacters(string));
        } else {
            arrayList.add(string);
        }
        return arrayList;
    }
}

