/*
 * Decompiled with CFR 0.152.
 */
package de.abelssoft.wordtools.jWordSplitter.impl;

import de.abelssoft.tools.FileTools;
import de.abelssoft.tools.persistence.FastObjectSaver;
import de.abelssoft.wordtools.jWordSplitter.AbstractWordSplitter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GermanWordSplitter
extends AbstractWordSplitter {
    private static final String SERIALIZED_DICT = "/wordsGerman.ser";
    private Set<String> words = null;
    private int minimumWordLength = 4;

    public GermanWordSplitter() throws IOException {
        this(true);
    }

    public GermanWordSplitter(boolean bl, String string) throws IOException {
        super(bl, string);
    }

    public GermanWordSplitter(boolean bl) throws IOException {
        super(bl);
    }

    @Override
    protected Set<String> getWordList() throws IOException {
        if (this.words == null) {
            this.words = this.loadWords();
        }
        return this.words;
    }

    private Set<String> loadWords() throws IOException {
        if (this.plainTextDictFile != null) {
            return FileTools.loadFile(this.plainTextDictFile);
        }
        return (HashSet)FastObjectSaver.load(SERIALIZED_DICT);
    }

    @Override
    protected int getMinimumWordLength() {
        return this.minimumWordLength;
    }

    public void setMinimumWordLength(int n) {
        this.minimumWordLength = n;
    }

    @Override
    protected Collection<String> getConnectingCharacters() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("s-");
        arrayList.add("s");
        arrayList.add("-");
        return arrayList;
    }
}

