/*
 * Decompiled with CFR 0.152.
 */
package de.abelssoft.wordtools.jWordSplitter.impl;

import de.abelssoft.wordtools.jWordSplitter.impl.GermanWordSplitter;
import java.io.IOException;
import java.util.Collection;
import junit.framework.TestCase;

public class GermanWordSplitterTest
extends TestCase {
    private static final String TESTFILE = "test/test-de.txt";
    private GermanWordSplitter splitter;

    public void test() throws IOException {
        this.splitter = new GermanWordSplitter(true, TESTFILE);
        this.splitter.setStrictMode(true);
        this.expect("[xyz]", "xyz");
        this.expect("[Verhalten]", "Verhalten");
        this.expect("[Verhalten, st\u00f6rung]", "Verhaltenst\u00f6rung");
        this.expect("[Verhalten, st\u00f6rung]", "Verhaltensst\u00f6rung");
        this.expect("[Verhaltenxst\u00f6rung]", "Verhaltenxst\u00f6rung");
    }

    public void testWithHyphen() throws IOException {
        this.splitter = new GermanWordSplitter(true, TESTFILE);
        this.splitter.setStrictMode(true);
        this.expect("[Verhalten, St\u00f6rung]", "Verhaltens-St\u00f6rung");
        this.expect("[Sauerstoff, Flasche]", "Sauerstoff-Flasche");
        this.expect("[Sauerstoff-Foobar]", "Sauerstoff-Foobar");
        this.splitter.setStrictMode(false);
        this.expect("[Sauerstoff, Foobar]", "Sauerstoff-Foobar");
        this.expect("[Blahbar-Foobar]", "Blahbar-Foobar");
    }

    public void testWrongCase() throws IOException {
        this.splitter = new GermanWordSplitter(true, TESTFILE);
        this.splitter.setStrictMode(true);
        this.expect("[VERHALTEN, ST\u00d6RUNG]", "VERHALTENSST\u00d6RUNG");
        this.expect("[verhalten, st\u00f6rung]", "verhaltensst\u00f6rung");
    }

    public void testWithConnectionCharacter() throws IOException {
        this.splitter = new GermanWordSplitter(false, TESTFILE);
        this.splitter.setStrictMode(true);
        this.expect("[xyz]", "xyz");
        this.expect("[Verhalten]", "Verhalten");
        this.expect("[Verhalten, st\u00f6rung]", "Verhaltenst\u00f6rung");
        this.expect("[Verhaltens, st\u00f6rung]", "Verhaltensst\u00f6rung");
        this.expect("[Verhaltenxst\u00f6rung]", "Verhaltenxst\u00f6rung");
        this.expect("[Verhaltenfoobar]", "Verhaltenfoobar");
    }

    public void testTooShortWords() throws IOException {
        this.splitter = new GermanWordSplitter(false, TESTFILE);
        this.splitter.setStrictMode(true);
        this.expect("[Verhaltenei]", "Verhaltenei");
        this.expect("[Eiverhalten]", "Eiverhalten");
    }

    public void testNonStrictMode() throws IOException {
        this.splitter = new GermanWordSplitter(false, TESTFILE);
        this.splitter.setStrictMode(false);
        this.expect("[xyz]", "xyz");
        this.expect("[Verhalten]", "Verhalten");
        this.expect("[Verhalten, st\u00f6rung]", "Verhaltenst\u00f6rung");
        this.expect("[Verhaltens, st\u00f6rung]", "Verhaltensst\u00f6rung");
        this.expect("[Verhaltenx, st\u00f6rung]", "Verhaltenxst\u00f6rung");
        this.expect("[xyz, st\u00f6rung]", "xyzst\u00f6rung");
        this.expect("[Verhalten, xyz]", "Verhaltenxyz");
        this.expect("[Verhaltens, xyz]", "Verhaltensxyz");
        this.expect("[Verhaltens, xyz]", "Verhaltensxyz");
    }

    public void testLongerWords() throws IOException {
        this.splitter = new GermanWordSplitter(false, TESTFILE);
        this.splitter.setStrictMode(true);
        this.expect("[Sauerstoff, flaschen, st\u00f6rungs, verhalten]", "Sauerstoffflaschenst\u00f6rungsverhalten");
        this.expect("[Sauerstoff, sauerstoff]", "Sauerstoffsauerstoff");
        this.expect("[Sauerstoff, sauerstoff, sauerstoff]", "Sauerstoffsauerstoffsauerstoff");
        this.expect("[St\u00f6rungs, st\u00f6rung]", "St\u00f6rungsst\u00f6rung");
        this.expect("[St\u00f6rungs, st\u00f6rungs, st\u00f6rung]", "St\u00f6rungsst\u00f6rungsst\u00f6rung");
    }

    public void testNoCompounds() throws IOException {
        this.splitter = new GermanWordSplitter(false, TESTFILE);
        this.splitter.setStrictMode(true);
        this.expect("[Kotfl\u00fcgel]", "Kotfl\u00fcgel");
    }

    public void testSpecialCases() throws IOException {
        this.splitter = new GermanWordSplitter(false, TESTFILE);
        this.expect("[]", null);
        this.expect("[]", "");
        this.expect("[]", "\t");
        this.expect("[]", "   ");
    }

    private void expect(String string, String string2) {
        Collection<String> collection = this.splitter.splitWord(string2);
        GermanWordSplitterTest.assertEquals((String)string, (String)collection.toString());
    }
}

