/*
 * Decompiled with CFR 0.152.
 */
package com.prolixtech.jaminid;

import com.prolixtech.jaminid.ContentOracle;
import com.prolixtech.jaminid.Daemon;
import com.prolixtech.jaminid.ExpireTask;
import com.prolixtech.jaminid.ProtocolResponseHeader;
import com.prolixtech.jaminid.Request;
import com.prolixtech.jaminid.Response;
import com.prolixtech.jaminid.StreamingOracle;
import com.prolixtech.utils.SingletonLogger;
import com.prolixtech.utils.Suspender;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

public class Connection
extends Thread {
    private Socket activeSocket;
    private Daemon masterDaemon;
    private InputStream socketInput;
    private OutputStream socketOutput;
    private static SimpleDateFormat GMTDateFormatter = new SimpleDateFormat("d MMM yyyy hh:mm:ss z", Locale.US);
    private boolean isalive = true;
    private static final long lineTimeout = 5000L;
    private static final long lineCheckInterval = 100L;

    public Connection(Socket socket, Daemon daemon) throws IOException {
        this.activeSocket = socket;
        this.masterDaemon = daemon;
        InetAddress inetAddress = socket.getInetAddress();
        this.setName("CN " + inetAddress);
        SingletonLogger.Instance().fine("Connection from " + inetAddress);
        this.socketInput = socket.getInputStream();
        this.socketOutput = socket.getOutputStream();
        this.start();
    }

    public String getIPAddressString() {
        return this.activeSocket.getInetAddress().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object;
            Request request;
            this.printlog("Processing Connection.");
            do {
                String string;
                ContentOracle contentOracle;
                block33: {
                    Object object2;
                    ArrayList<Byte> arrayList = new ArrayList<Byte>();
                    int n = -1;
                    int n2 = 0;
                    boolean bl = false;
                    request = new Request(this.masterDaemon, this);
                    int n3 = 0;
                    int n4 = 0;
                    do {
                        if (this.socketInput.available() == 0) {
                            object2 = new Timer();
                            object = new ExpireTask();
                            ((Timer)object2).schedule((TimerTask)object, 5000L);
                            while (((ExpireTask)object).running) {
                                if (this.socketInput.available() > 0) {
                                    ((ExpireTask)object).running = false;
                                }
                                Suspender.suspendMillis(100L);
                            }
                            if (this.socketInput.available() == 0) break;
                        }
                        if ((n = this.socketInput.read()) <= 0) continue;
                        arrayList.add((byte)n);
                        if (bl) {
                            ++n4;
                        }
                        char c = (char)n;
                        switch (n2) {
                            case 0: {
                                if ("\r".charAt(0) != c) break;
                                ++n2;
                                break;
                            }
                            case 1: {
                                if ("\n".charAt(0) == c) {
                                    ++n2;
                                    break;
                                }
                                n2 = 0;
                                break;
                            }
                            case 2: {
                                if ("\r".charAt(0) == c) {
                                    ++n2;
                                    break;
                                }
                                n2 = 0;
                                break;
                            }
                            case 3: {
                                if ("\n".charAt(0) == c) {
                                    ++n2;
                                    bl = true;
                                    object = this.bytesToString(arrayList);
                                    request.addRequestLines((String)object);
                                    arrayList = new ArrayList();
                                    n3 = request.switchToBody();
                                    break;
                                }
                                n2 = 0;
                            }
                        }
                    } while (!bl || bl && n4 < n3 || bl && n != -1 && this.socketInput.available() > 0);
                    object2 = this.bytesToString(arrayList);
                    this.printlog("Request: " + (String)object2);
                    request.addRequestLines((String)object2);
                    request.switchToCompleted();
                    object = new Response(200, this.masterDaemon.getProtocol(), this.socketOutput, request);
                    ((Response)object).setHeaderLine(ProtocolResponseHeader.Content_Type, "text/html");
                    ((Response)object).setHeaderLine(ProtocolResponseHeader.Date, Connection.getGMTString(new Date()));
                    contentOracle = this.masterDaemon.getOracle();
                    string = null;
                    contentOracle = contentOracle.getDelegatedOracle(request);
                    try {
                        string = contentOracle.demultiplex(request, (Response)object);
                    }
                    catch (Exception exception) {
                        SingletonLogger.Instance().severe("User Oracle FAILED");
                        exception.printStackTrace();
                        if (contentOracle == ContentOracle.Instance()) break block33;
                        try {
                            string = ContentOracle.Instance().demultiplex(request, (Response)object);
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                            SingletonLogger.Instance().severe("Fallback Oracle FAILED");
                        }
                    }
                }
                ((Response)object).publishHeader();
                if (contentOracle instanceof StreamingOracle) {
                    StreamingOracle streamingOracle = (StreamingOracle)contentOracle;
                    while (this.isalive) {
                        Suspender.suspendMillis(streamingOracle.getStreamInterval());
                        this.sendString(streamingOracle.getNextBatch(request, (Response)object));
                    }
                } else {
                    this.sendString(string);
                }
                this.socketOutput.flush();
            } while (!((String)request.getHeader().get((Object)ProtocolResponseHeader.Connection)).equalsIgnoreCase("Close"));
            ((Response)object).setHeaderLine(ProtocolResponseHeader.Connection, "close");
            this.socketOutput.close();
            this.printlog("Connection Done.");
        }
        catch (Exception exception) {
            this.printlog("Exception: " + exception);
        }
        finally {
            try {
                this.activeSocket.close();
            }
            catch (Exception exception) {
                System.err.println("Socket not closed");
            }
        }
    }

    private String bytesToString(List<Byte> list) {
        Byte[] byteArray = list.toArray(new Byte[0]);
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        try {
            return new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString(), unsupportedEncodingException);
        }
    }

    private void printlog(String string) {
        this.masterDaemon.printlog("[" + this.activeSocket.getInetAddress() + "] " + string);
    }

    protected void sendString(Object object) throws IOException {
        if (object == null) {
            return;
        }
        this.socketOutput.write(object.toString().getBytes("UTF-8"));
    }

    protected void sendString(byte[] byArray) {
        try {
            this.socketOutput.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.isalive = false;
        }
    }

    public static String getGMTString(Date date) {
        return GMTDateFormatter.format(date);
    }
}

