/*
 * Decompiled with CFR 0.152.
 */
package com.prolixtech.jaminid;

import com.prolixtech.jaminid.Connection;
import com.prolixtech.jaminid.ContentOracle;
import com.prolixtech.jaminid.Protocol;
import com.prolixtech.jaminid.StreamingOracle;
import com.prolixtech.utils.SingletonLogger;
import com.prolixtech.utils.Suspender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class Daemon
extends Thread {
    private int serverPort;
    private ServerSocket serverSocket;
    private Protocol activeProtocol = Protocol.Instance();
    private ContentOracle contentOracle;
    public static final String VERSION = "0.99.1";
    private boolean RUNNING = false;
    private int backLog;
    private InetAddress adr;

    public int getServerPort() {
        return this.serverPort;
    }

    public Protocol getProtocol() {
        return this.activeProtocol;
    }

    public ContentOracle getOracle() {
        return this.contentOracle;
    }

    public Daemon(int n, ContentOracle contentOracle) {
        this(n, 50, null, contentOracle);
    }

    public Daemon(int n, int n2, InetAddress inetAddress, ContentOracle contentOracle) {
        this.setName("HTTP Daemon on " + this.serverPort);
        if (contentOracle == null) {
            this.printlog("USING STANDARD CONTENTORACLE");
            this.contentOracle = ContentOracle.Instance();
        } else {
            this.contentOracle = contentOracle;
        }
        this.printlog("Web Server Started, Logger Connected. Using: " + contentOracle.getClass());
        this.serverPort = n;
        this.backLog = n2;
        this.adr = inetAddress;
        try {
            this.serverSocket = new ServerSocket(n, n2, inetAddress);
            this.RUNNING = true;
        }
        catch (Exception exception) {
            SingletonLogger.Instance().severe("A major error has occured: " + exception);
            SingletonLogger.Instance().severe("Perhaps I could not bind port " + n + ". Exiting.");
            this.serverSocket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        super.run();
        block6: while (true) {
            block8: {
                try {
                    try {}
                    catch (Throwable throwable) {
                        this.serverSocket.close();
                        throw throwable;
                    }
                    break block8;
                }
                catch (Exception exception) {
                    this.printlog("A major error has occured\n" + exception);
                    System.exit(-1);
                }
                return;
            }
            while (this.RUNNING) {
                Socket socket = this.serverSocket.accept();
                try {
                    this.printlog("Accepted Socket: " + socket);
                    new Connection(socket, this);
                }
                catch (IOException iOException) {
                    socket.close();
                    continue;
                }
                continue block6;
            }
            break;
        }
        this.serverSocket.close();
    }

    @Override
    public String toString() {
        return "mserve HTTPD daemon (" + this.getClass() + ") version " + VERSION + " running on port " + this.serverPort + ".";
    }

    public static void main(String[] stringArray) {
        Daemon daemon = new Daemon(80, StreamingOracle.Instance());
    }

    public void printlog(String string) {
        SingletonLogger.Instance().fine(string);
    }

    public boolean isRunning() {
        return this.RUNNING;
    }

    public void tearDown() {
        this.RUNNING = false;
    }

    public void tearDownAndWait() {
        this.tearDown();
        while (this.RUNNING) {
            Suspender.suspendSeconds(1);
        }
    }
}

