/*
 * Decompiled with CFR 0.152.
 */
package com.prolixtech.jaminid;

import com.prolixtech.jaminid.Connection;
import com.prolixtech.jaminid.Daemon;
import com.prolixtech.jaminid.Protocol;
import com.prolixtech.utils.SingletonLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Request {
    private StringBuffer requestMessageBuffer = new StringBuffer();
    private StringBuffer requestBody = new StringBuffer();
    private String paramString;
    private String HTTPMethod;
    private String requestURI;
    private Connection conn;
    private Daemon masterDaemon;
    private Protocol protocol;
    private String requestLocation;
    private boolean isbad = false;
    private static int STATUS_WAITING_FOR_METHOD = 0;
    private static int STATUS_WAITING_FOR_PARAMS = 1;
    private static int STATUS_WAITING_FOR_BODY = 2;
    private static int STATUS_COMPLETE = 3;
    private static int STATUS_MALFORMED = -1;
    private int currentStatus = 0;
    private Map<String, String> activeHeader = new HashMap<String, String>();
    private Map<String, String> paramMap = new HashMap<String, String>();

    public boolean isRequestBad() {
        return this.isbad;
    }

    private int getStatus() {
        return this.currentStatus;
    }

    public String getURI() {
        return this.requestURI;
    }

    public String getMessage() {
        return this.requestMessageBuffer.toString();
    }

    public String getBody() {
        return this.requestBody.toString();
    }

    public Daemon getDaemon() {
        return this.masterDaemon;
    }

    public Map getHeader() {
        return this.activeHeader;
    }

    public Map<String, String> getParamMap() {
        return this.paramMap;
    }

    public String getLocation() {
        return this.requestLocation;
    }

    public void setMethodLine(String string) {
        try {
            String string2 = string.trim();
            this.HTTPMethod = string2.substring(0, string2.indexOf(" "));
            this.requestURI = string2.substring(string2.indexOf(" "), string2.lastIndexOf("HTTP/")).trim();
            int n = this.requestURI.indexOf("?");
            if (n > 0) {
                this.paramString = this.requestURI.substring(n + 1);
                this.requestLocation = this.requestURI.substring(0, n);
                this.processParamString(this.paramString);
            } else {
                this.requestLocation = this.requestURI;
            }
        }
        catch (Exception exception) {
            this.isbad = true;
            this.currentStatus = STATUS_MALFORMED;
            return;
        }
    }

    public void appendToBody(String string) {
        this.requestBody.append(string);
    }

    public void addRequestLines(String string) {
        if (this.currentStatus == STATUS_COMPLETE) {
            return;
        }
        if (this.currentStatus == STATUS_MALFORMED) {
            return;
        }
        this.requestMessageBuffer.append(string);
        int n = string.indexOf("\r\n\r\n");
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        if (this.currentStatus == STATUS_WAITING_FOR_METHOD) {
            this.currentStatus = STATUS_WAITING_FOR_PARAMS;
            this.setMethodLine(stringTokenizer.nextToken());
        }
        if (this.currentStatus == STATUS_WAITING_FOR_PARAMS) {
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n2 = string3.indexOf(":");
                if (n2 <= 0) continue;
                String string4 = string3.substring(0, n2).trim();
                String string5 = string3.substring(n2 + 1).trim();
                this.masterDaemon.printlog("KEY [" + string4 + "] VAL [" + string5 + "]");
                this.activeHeader.put(string4, string5);
            }
        }
        if (this.currentStatus == STATUS_WAITING_FOR_BODY) {
            string2 = string;
        }
        if (n > 0) {
            this.currentStatus = STATUS_WAITING_FOR_BODY;
        }
        if (this.currentStatus == STATUS_WAITING_FOR_BODY) {
            this.appendToBody(string2);
        }
        this.masterDaemon.printlog("[**] METHOD: " + this.HTTPMethod);
        this.masterDaemon.printlog("[**] URI: " + this.requestURI);
        int n3 = this.requestURI.lastIndexOf(".");
        if (n3 != -1) {
            this.masterDaemon.printlog("[**] TYPE: " + Protocol.getMIME(this.requestURI.substring(n3)));
        }
        this.masterDaemon.printlog("[**] BODY: " + this.requestBody);
    }

    public String getIPAddressString() {
        return this.conn.getIPAddressString();
    }

    public Request(Daemon daemon, Connection connection) {
        this.conn = connection;
        this.masterDaemon = daemon;
        this.protocol = this.masterDaemon.getProtocol();
    }

    private void processParamString(String string) {
        int n;
        String[] stringArray;
        try {
            stringArray = (String[])this.getHeader().get("Cookie");
            if (stringArray != null) {
                String[] stringArray2 = stringArray.split(";");
                for (n = 0; n < stringArray2.length; ++n) {
                    String[] stringArray3;
                    stringArray2[n] = stringArray2[n].trim();
                    if (stringArray2[n].indexOf("=") <= 0 || (stringArray3 = stringArray2[n].split("=")).length != 2) continue;
                    this.paramMap.put(stringArray3[0].trim(), stringArray3[1].trim());
                }
            }
        }
        catch (Exception exception) {
            SingletonLogger.Instance().http(this, "Error processing cookie" + exception);
            exception.printStackTrace();
        }
        stringArray = string.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            n = stringArray[i].indexOf("=");
            if (n > 0) {
                this.paramMap.put(stringArray[i].substring(0, n), this.unEscape(stringArray[i].substring(n + 1)));
                continue;
            }
            this.paramMap.put(stringArray[i], "");
        }
    }

    private String unEscape(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n = -1;
        do {
            if ((n = string.indexOf(37, n + 1)) < 0) continue;
            try {
                String string2 = string.substring(n + 1, n + 3);
                char c = (char)Request.hex2int(string2);
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 3);
                string = string3 + c + string4;
            }
            catch (Exception exception) {
                SingletonLogger.Instance().exception("Escaping Error", exception);
            }
        } while (n >= 0);
        string = string.replaceAll("\\+", " ");
        return string;
    }

    private static int hex2int(String string) {
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        return Request.hex2int(c2) + Request.hex2int(c) * 16;
    }

    private static int hex2int(char c) {
        if (Character.isDigit(c)) {
            return Integer.parseInt(String.valueOf(c));
        }
        if ((c = Character.toUpperCase(c)) >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid Hex");
    }

    protected int switchToBody() {
        if (this.HTTPMethod.equals("POST")) {
            try {
                int n = 0;
                this.currentStatus = STATUS_WAITING_FOR_BODY;
                return n;
            }
            catch (Exception exception) {
                System.out.println("ABORTED to body");
                exception.printStackTrace();
            }
        }
        this.currentStatus = STATUS_COMPLETE;
        return 0;
    }

    protected void switchToCompleted() {
        if (this.HTTPMethod.equals("POST")) {
            this.processParamString(this.requestBody.toString());
        }
    }

    public String getParamString() {
        return this.paramString;
    }

    public String getParam(String string) {
        String string2 = this.paramMap.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public String getParamOrNull(String string) {
        String string2 = this.paramMap.get(string);
        return string2;
    }

    public boolean checkParam(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (this.getParamMap().get(string) == null) {
            return false;
        }
        return this.getParamMap().get(string).equals(string2);
    }
}

