/*
 * Decompiled with CFR 0.152.
 */
package com.prolixtech.jaminid;

import com.prolixtech.jaminid.Connection;
import com.prolixtech.jaminid.Protocol;
import com.prolixtech.jaminid.ProtocolResponseHeader;
import com.prolixtech.jaminid.Request;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Response {
    private String statusLine;
    private Protocol protocol;
    private OutputStream out;
    private Request masterRequest;
    private boolean headerPublished;
    private Map<String, String> activeHeader = new HashMap<String, String>();

    public Response(int n, Protocol protocol, OutputStream outputStream, Request request) {
        this.masterRequest = request;
        this.out = outputStream;
        this.protocol = protocol;
        String string = Protocol.getHeaderResponseStatus(n);
        if (string == null) {
            n = 500;
        }
        this.statusLine = "HTTP/1.1 " + n + " " + Protocol.getHeaderResponseStatus(n);
    }

    public void setStatus(int n) {
        if (Protocol.getHeaderResponseStatus(n) == null) {
            throw new IllegalArgumentException("No such status code");
        }
        this.statusLine = "HTTP/1.1 " + n + " " + Protocol.getHeaderResponseStatus(n);
    }

    public void sendCookie15DG(String string, String string2) {
        Date date = new Date(System.currentTimeMillis() + 1296000000L);
        this.setCookie(string, string2, "/", date);
    }

    public void setCookie(String string, String string2, String string3, Date date) {
        String string4 = string + "=" + string2 + "; expires=" + Connection.getGMTString(date) + ";path=" + string3 + ";";
        this.setHeaderLine(ProtocolResponseHeader.Set_Cookie, string4);
    }

    public void publishHeader() throws IOException {
        if (this.headerPublished) {
            return;
        }
        this.out.write(this.statusLine.getBytes());
        for (String string : this.activeHeader.keySet()) {
            this.out.write(this.CRLF());
            this.out.write(string.getBytes());
            this.out.write(58);
            this.out.write(32);
            this.out.write(this.activeHeader.get(string).getBytes());
        }
        this.out.write(this.CRLF());
        this.out.write(this.CRLF());
        this.headerPublished = true;
    }

    public void setHeaderLine(ProtocolResponseHeader protocolResponseHeader, String string) {
        this.activeHeader.put(protocolResponseHeader.toString(), string);
    }

    public byte[] CRLF() {
        return "\r\n".getBytes();
    }

    public void sendFile(File file) throws Exception {
        String string;
        String string2 = Connection.getGMTString(new Date(file.lastModified()));
        if (string2.equals(string = (String)this.masterRequest.getHeader().get("If-Modified-Since"))) {
            this.setStatus(304);
            this.setHeaderLine(ProtocolResponseHeader.Content_Length, "0");
        } else {
            int n;
            String string3 = file.getCanonicalPath();
            String string4 = string3.substring(string3.lastIndexOf("."));
            String string5 = Protocol.getMIME(string4);
            this.setHeaderLine(ProtocolResponseHeader.Content_Type, string5);
            this.setHeaderLine(ProtocolResponseHeader.Content_Length, "" + file.length());
            this.setHeaderLine(ProtocolResponseHeader.Last_Modified, string2);
            this.publishHeader();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[4096];
            while ((n = bufferedInputStream.read(byArray)) >= 0) {
                this.out.write(byArray, 0, n);
            }
        }
    }
}

