/*
 * Decompiled with CFR 0.152.
 */
package com.prolixtech.utils;

import com.prolixtech.jaminid.Request;
import com.prolixtech.utils.MboxLogger;
import com.prolixtech.utils.SingleLineFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaLogger
implements MboxLogger {
    private Logger logger;
    private static JavaLogger theInstance;
    private Handler consoleLog = new ConsoleHandler();
    private boolean baloonsDisabled = false;

    public static MboxLogger Instance() {
        if (theInstance == null) {
            theInstance = new JavaLogger();
        }
        return theInstance;
    }

    protected JavaLogger() {
        this.logger = Logger.getLogger("ProlixLogger");
        this.logger.setLevel(Level.FINEST);
        this.logger.setUseParentHandlers(false);
        this.consoleLog.setLevel(Level.INFO);
        SingleLineFormatter singleLineFormatter = new SingleLineFormatter();
        this.consoleLog.setFormatter(singleLineFormatter);
        this.logger.addHandler(this.consoleLog);
        this.logger.log(Level.INFO, "The Logger service has started");
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void log(Level level, String string) {
        StackTraceElement stackTraceElement;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string2 = "";
        for (int i = 0; i < stackTraceElementArray.length && (string2 = (stackTraceElement = stackTraceElementArray[i]).getClassName()).endsWith(".SingletonLogger"); ++i) {
        }
        string2 = string2.substring(string2.lastIndexOf(".") + 1);
        this.logger.log(level, "[" + string2 + "] " + string);
    }

    @Override
    public void fine(String string) {
        this.log(Level.FINE, string);
    }

    @Override
    public void severe(String string) {
        this.log(Level.SEVERE, string);
    }

    @Override
    public void warning(String string) {
        this.log(Level.WARNING, string);
    }

    @Override
    public void info(String string) {
        this.log(Level.INFO, string);
    }

    @Override
    public void sql(String string) {
        this.log(Level.FINEST, "[SQL] " + string);
    }

    @Override
    public void http(Request request, String string) {
        this.log(Level.INFO, "[HTTP " + request.getIPAddressString() + "]" + string);
    }

    @Override
    public void disableBaloons() {
        this.baloonsDisabled = true;
    }

    @Override
    public void exception(Level level, String string, Exception exception) {
        this.log(level, string);
        exception.printStackTrace();
    }

    @Override
    public void exception(String string, Exception exception) {
        this.exception(Level.WARNING, string, exception);
    }

    @Override
    public void baloon(String string, String string2) {
        this.info(string2 + " : " + string);
    }
}

