/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import morfologik.fsa.FSAHelpers;
import morfologik.fsa.FSATraversalHelper;
import morfologik.fsa.FSAVer5Impl;
import morfologik.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FSA
implements Iterable<ByteBuffer> {
    public static final byte VERSION_5 = 5;
    protected byte version;
    protected byte filler;
    protected byte gotoLength;
    private byte annotationSeparator;
    private String dictionaryEncoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FSA(InputStream inputStream, String string) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The input stream must not be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Dictionary encoding must not be null.");
        }
        this.dictionaryEncoding = string;
        byte[] byArray = this.readFully(inputStream);
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.readHeader(dataInputStream, byArray.length);
        }
        catch (Throwable throwable) {
            FileUtils.close(dataInputStream);
            throw throwable;
        }
        FileUtils.close(dataInputStream);
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getFlags() {
        return FSAHelpers.getFlags(this.version);
    }

    public final char getAnnotationSeparator() {
        try {
            String string = new String(new byte[]{this.annotationSeparator}, this.dictionaryEncoding);
            if (string.length() != 1) {
                throw new RuntimeException("Unexpected annotation character length (should be 1): " + string.length());
            }
            return string.charAt(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public final char getFillerCharacter() {
        try {
            String string = new String(new byte[]{this.filler}, this.dictionaryEncoding);
            if (string.length() != 1) {
                throw new RuntimeException("Unexpected filler character length (should be 1): " + string.length());
            }
            return string.charAt(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public abstract int getNumberOfArcs();

    public abstract int getNumberOfNodes();

    public FSATraversalHelper getTraversalHelper() {
        return new FSATraversalHelper(this);
    }

    public static FSA getInstance(File file, String string) throws IOException {
        if (!file.exists()) {
            throw new IOException("File does not exist: " + file.getAbsolutePath());
        }
        return FSA.getInstance(new FileInputStream(file), string);
    }

    public static FSA getInstance(InputStream inputStream, String string) throws IOException {
        int n;
        if (inputStream == null) {
            throw new IllegalArgumentException("FSA stream cannot be null.");
        }
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 5);
        byte[] byArray = new byte[5];
        for (n = 0; n < byArray.length; n += pushbackInputStream.read(byArray, n, byArray.length - n)) {
        }
        if (byArray[0] == 92 && byArray[1] == 102 && byArray[2] == 115 && byArray[3] == 97) {
            n = byArray[4];
            pushbackInputStream.unread(byArray);
            switch (n) {
                case 5: {
                    return new FSAVer5Impl(pushbackInputStream, string);
                }
            }
            throw new IOException("Cannot read FSA: support for version " + n + " (" + FSAHelpers.flagsToString(FSAHelpers.getFlags(n)) + ") not implemented.");
        }
        throw new IOException("Cannot read FSA: file does not begin with a valid magic number.");
    }

    protected void readHeader(DataInput dataInput, long l) throws IOException {
        byte[] byArray = new byte[4];
        dataInput.readFully(byArray);
        if (byArray[0] != 92 || byArray[1] != 102 || byArray[2] != 115 || byArray[3] != 97) {
            throw new IOException("Cannot read FSA: File does not begin with a valid magic number.");
        }
        this.version = dataInput.readByte();
        this.filler = dataInput.readByte();
        this.annotationSeparator = dataInput.readByte();
        this.gotoLength = dataInput.readByte();
    }

    protected byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.getTraversalHelper().getAllSubsequences(this.getRootNode());
    }

    public abstract int getRootNode();

    public abstract int getFirstArc(int var1);

    public abstract int getArc(int var1, byte var2);

    public abstract int getNextArc(int var1, int var2);

    public abstract int getEndNode(int var1);

    public abstract byte getArcLabel(int var1);

    public abstract boolean isArcFinal(int var1);

    public abstract boolean isArcTerminal(int var1);
}

