/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import morfologik.fsa.FSAFlags;

public final class FSAHelpers {
    private FSAHelpers() {
    }

    public static String flagsToString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (FSAFlags fSAFlags : FSAFlags.values()) {
            if ((n & fSAFlags.bits) == 0) continue;
            n &= ~fSAFlags.bits;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(fSAFlags.toString());
        }
        if (n != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("(Some flags were not recognized: " + Integer.toBinaryString(n) + ")");
        }
        return stringBuilder.toString();
    }

    public static byte getVersion(int n) {
        int n2 = FSAFlags.isSet(n, FSAFlags.FLEXIBLE) ? (FSAFlags.isSet(n, FSAFlags.STOPBIT) ? (FSAFlags.isSet(n, FSAFlags.NEXTBIT) ? (FSAFlags.isSet(n, FSAFlags.TAILS) ? 7 : (FSAFlags.isSet(n, FSAFlags.WEIGHTED) ? 8 : 5)) : (FSAFlags.isSet(n, FSAFlags.TAILS) ? 6 : 4)) : (FSAFlags.isSet(n, FSAFlags.NEXTBIT) ? 2 : 1)) : (FSAFlags.isSet(n, FSAFlags.LARGE_DICTIONARIES) ? -128 : 0);
        return (byte)n2;
    }

    public static int getFlags(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case -128: {
                n2 = FSAFlags.LARGE_DICTIONARIES.bits;
                break;
            }
            case 1: {
                n2 = FSAFlags.FLEXIBLE.bits;
                break;
            }
            case 2: {
                n2 = FSAFlags.FLEXIBLE.bits | FSAFlags.NEXTBIT.bits;
                break;
            }
            case 4: {
                n2 = FSAFlags.FLEXIBLE.bits | FSAFlags.STOPBIT.bits;
                break;
            }
            case 5: {
                n2 = FSAFlags.FLEXIBLE.bits | FSAFlags.STOPBIT.bits | FSAFlags.NEXTBIT.bits;
                break;
            }
            case 6: {
                n2 = FSAFlags.FLEXIBLE.bits | FSAFlags.STOPBIT.bits | FSAFlags.TAILS.bits;
                break;
            }
            case 7: {
                n2 = FSAFlags.FLEXIBLE.bits | FSAFlags.STOPBIT.bits | FSAFlags.NEXTBIT.bits | FSAFlags.TAILS.bits;
                break;
            }
            default: {
                throw new RuntimeException("Unknown version number. FSA created with unknown options.");
            }
        }
        return n2;
    }
}

