/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAHelpers;

public final class FSAVer5Impl
extends FSA {
    private static final int BITMASK_LASTARC = 2;
    private static final int BITMASK_FINALARC = 1;
    private static final int BITMASK_NEXTBIT = 4;
    protected int arcSize;
    protected static final int gotoOffset = 1;
    protected byte[] arcs;

    public int getNumberOfArcs() {
        int n = this.getRootNode();
        int n2 = this.getFirstArc(n);
        int n3 = 0;
        while (n2 < this.arcs.length) {
            ++n3;
            if ((this.arcs[n2 + 1] & 4) != 0) {
                n2 = n2 + 1 + 1;
                continue;
            }
            n2 = n2 + 1 + this.gotoLength;
        }
        return n3;
    }

    public int getNumberOfNodes() {
        int n = 0;
        for (int i = 1; i < this.arcs.length; i += this.arcSize) {
            if ((this.arcs[i] & 2) == 0) continue;
            ++n;
        }
        return n;
    }

    public FSAVer5Impl(InputStream inputStream, String string) throws IOException {
        super(inputStream, string);
    }

    public int getRootNode() {
        return this.getEndNode(this.getFirstArc(this.arcSize));
    }

    protected void readHeader(DataInput dataInput, long l) throws IOException {
        super.readHeader(dataInput, l);
        if (this.version != 5) {
            throw new IOException("Cannot read FSA in version " + this.version + " (built with flags: " + FSAHelpers.flagsToString(FSAHelpers.getFlags(this.version)) + ")." + " Class " + this.getClass().getName() + " supports version " + 5 + " only (" + FSAHelpers.flagsToString(FSAHelpers.getFlags(5)) + ").");
        }
        this.gotoLength = (byte)(this.gotoLength & 0xF);
        this.arcSize = this.gotoLength + 1;
        int n = (int)l - 8;
        this.arcs = new byte[n];
        dataInput.readFully(this.arcs);
    }

    public final int getFirstArc(int n) {
        return n;
    }

    public final int getNextArc(int n, int n2) {
        if (this.isArcLast(n2)) {
            return 0;
        }
        return n2 + this.arcSize;
    }

    public int getArc(int n, byte by) {
        int n2 = this.getFirstArc(n);
        while (n2 != 0) {
            if (this.getArcLabel(n2) == by) {
                return n2;
            }
            n2 = this.getNextArc(n, n2);
        }
        return 0;
    }

    public int getEndNode(int n) {
        int n2 = this.getDestinationNodeOffset(n);
        if (0 == n2) {
            throw new RuntimeException("This is a terminal arc [" + n + "]");
        }
        return n2;
    }

    public byte getArcLabel(int n) {
        return this.arcs[n];
    }

    public boolean isArcFinal(int n) {
        return (this.arcs[n + 1] & 1) != 0;
    }

    public boolean isArcTerminal(int n) {
        return 0 == this.getDestinationNodeOffset(n);
    }

    private boolean isArcLast(int n) {
        return (this.arcs[n + 1] & 2) != 0;
    }

    private final int gotoFieldToOffset(int n, int n2) {
        int n3 = 0;
        for (int i = n2 - 1; i >= 0; --i) {
            n3 <<= 8;
            n3 |= this.arcs[n + i] & 0xFF;
        }
        return n3;
    }

    private final int getDestinationNodeOffset(int n) {
        if ((this.arcs[n + 1] & 4) != 0) {
            return n + 1 + 1;
        }
        return this.gotoFieldToOffset(n + 1, this.gotoLength) >>> 3;
    }
}

