/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Iterator;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.WordData;
import morfologik.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DictionaryIterator
implements Iterator<WordData> {
    private final CharsetDecoder decoder;
    private final Iterator<ByteBuffer> entriesIter;
    private final WordData entry;
    private final byte separator;
    private final DictionaryMetadata dictionaryMetadata;
    private final boolean decodeStems;
    private ByteBuffer inflectedBuffer = ByteBuffer.allocate(0);
    private CharBuffer inflectedCharBuffer = CharBuffer.allocate(0);
    private ByteBuffer temp = ByteBuffer.allocate(0);

    public DictionaryIterator(Dictionary dictionary, CharsetDecoder charsetDecoder, boolean bl) {
        this.entriesIter = dictionary.fsa.iterator();
        this.separator = dictionary.metadata.separator;
        this.dictionaryMetadata = dictionary.metadata;
        this.decoder = charsetDecoder;
        this.entry = new WordData(charsetDecoder);
        this.decodeStems = bl;
    }

    @Override
    public boolean hasNext() {
        return this.entriesIter.hasNext();
    }

    @Override
    public WordData next() {
        int n;
        ByteBuffer byteBuffer = this.entriesIter.next();
        this.entry.reset();
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.remaining();
        for (n = 0; n < n2 && byArray[n] != this.separator; ++n) {
        }
        if (n == n2) {
            throw new RuntimeException("Invalid dictionary entry format (missing separator).");
        }
        this.inflectedBuffer.clear();
        this.inflectedBuffer = BufferUtils.ensureCapacity(this.inflectedBuffer, n);
        this.inflectedBuffer.put(byArray, 0, n);
        this.inflectedBuffer.flip();
        this.inflectedCharBuffer = this.bytesToChars(this.inflectedBuffer, this.inflectedCharBuffer);
        this.entry.wordBuffer = this.inflectedBuffer;
        this.entry.wordCharSequence = this.inflectedCharBuffer;
        this.temp.clear();
        this.temp = BufferUtils.ensureCapacity(this.temp, n2 - n);
        this.temp.put(byArray, ++n, n2 - n);
        this.temp.flip();
        byArray = this.temp.array();
        n2 = this.temp.remaining();
        for (n = 0; n < n2 && byArray[n] != this.separator; ++n) {
        }
        this.entry.stemBuffer.clear();
        if (this.decodeStems) {
            this.entry.stemBuffer = DictionaryLookup.decodeStem(this.entry.stemBuffer, byArray, n, this.inflectedBuffer, this.dictionaryMetadata);
        } else {
            this.entry.stemBuffer = BufferUtils.ensureCapacity(this.entry.stemBuffer, n);
            this.entry.stemBuffer.put(byArray, 0, n);
        }
        this.entry.stemBuffer.flip();
        if (n + 1 <= n2) {
            ++n;
        }
        this.entry.tagBuffer = BufferUtils.ensureCapacity(this.entry.tagBuffer, n2 - n);
        this.entry.tagBuffer.clear();
        this.entry.tagBuffer.put(byArray, n, n2 - n);
        this.entry.tagBuffer.flip();
        return this.entry;
    }

    private CharBuffer bytesToChars(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        charBuffer.clear();
        int n = (int)((float)byteBuffer.remaining() * this.decoder.maxCharsPerByte());
        if (charBuffer.capacity() <= n) {
            charBuffer = CharBuffer.allocate(n);
        }
        byteBuffer.mark();
        this.decoder.reset();
        this.decoder.decode(byteBuffer, charBuffer, true);
        charBuffer.flip();
        byteBuffer.reset();
        return charBuffer;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

