/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DictionaryMetadata {
    public static final String ATTR_NAME_SEPARATOR = "fsa.dict.separator";
    public static final String ATTR_NAME_ENCODING = "fsa.dict.encoding";
    public static final String ATTR_NAME_USES_PREFIXES = "fsa.dict.uses-prefixes";
    public static final String ATTR_NAME_USES_INFIXES = "fsa.dict.uses-infixes";
    public final byte separator;
    public final String encoding;
    public final boolean usesPrefixes;
    public final boolean usesInfixes;
    public final Map<String, String> metadata;

    public DictionaryMetadata(char c, String string, boolean bl, boolean bl2, Map<String, String> map) {
        this.encoding = string;
        this.usesPrefixes = bl;
        this.usesInfixes = bl2;
        try {
            byte[] byArray = new String(new char[]{c}).getBytes(string);
            if (byArray.length != 1) {
                throw new RuntimeException("Separator character '" + c + "' must be a single byte after transformation with encoding: " + string);
            }
            this.separator = byArray[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Encoding not supported on this VM: " + string);
        }
        this.metadata = Collections.unmodifiableMap(new HashMap<String, String>(map));
    }

    static DictionaryMetadata fromMap(Properties properties) throws IOException {
        String string = properties.getProperty(ATTR_NAME_SEPARATOR);
        if (string == null || string.length() != 1) {
            throw new IOException("Attribute fsa.dict.separator must be a single character.");
        }
        String string2 = properties.getProperty(ATTR_NAME_ENCODING);
        if (string2 == null || string2.length() == 0) {
            throw new IOException("Attribute fsa.dict.encoding must be present and non-empty.");
        }
        boolean bl = Boolean.valueOf(properties.getProperty(ATTR_NAME_USES_PREFIXES, "false"));
        boolean bl2 = Boolean.valueOf(properties.getProperty(ATTR_NAME_USES_INFIXES, "false"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            hashMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return new DictionaryMetadata(string.charAt(0), string2, bl, bl2, hashMap);
    }
}

