/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import morfologik.util.BufferUtils;

public final class WordData
implements Cloneable {
    private static final String COLLECTIONS_ERROR_MESSAGE = "Not suitable for use in Java collections framework (volatile content). Refer to documentation.";
    private final CharsetDecoder decoder;
    CharSequence wordCharSequence;
    private CharBuffer stemCharSequence;
    private CharBuffer tagCharSequence;
    ByteBuffer wordBuffer;
    ByteBuffer stemBuffer;
    ByteBuffer tagBuffer;

    WordData(CharsetDecoder charsetDecoder) {
        this.decoder = charsetDecoder;
        this.stemBuffer = ByteBuffer.allocate(0);
        this.tagBuffer = ByteBuffer.allocate(0);
        this.stemCharSequence = CharBuffer.allocate(0);
        this.tagCharSequence = CharBuffer.allocate(0);
    }

    WordData(String string, String string2, String string3) {
        this(Charset.forName(string3).newDecoder());
        try {
            if (string != null) {
                this.stemBuffer.put(string.getBytes(string3));
            }
            if (string2 != null) {
                this.tagBuffer.put(string2.getBytes(string3));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public ByteBuffer getStemBytes(ByteBuffer byteBuffer) {
        byteBuffer = BufferUtils.ensureCapacity(byteBuffer, this.stemBuffer.remaining());
        this.stemBuffer.mark();
        byteBuffer.put(this.stemBuffer);
        this.stemBuffer.reset();
        byteBuffer.flip();
        return byteBuffer;
    }

    public ByteBuffer getTagBytes(ByteBuffer byteBuffer) {
        byteBuffer = BufferUtils.ensureCapacity(byteBuffer, this.tagBuffer.remaining());
        this.tagBuffer.mark();
        byteBuffer.put(this.tagBuffer);
        this.tagBuffer.reset();
        byteBuffer.flip();
        return byteBuffer;
    }

    public ByteBuffer getWordBytes(ByteBuffer byteBuffer) {
        byteBuffer = BufferUtils.ensureCapacity(byteBuffer, this.wordBuffer.remaining());
        this.wordBuffer.mark();
        byteBuffer.put(this.wordBuffer);
        this.wordBuffer.reset();
        byteBuffer.flip();
        return byteBuffer;
    }

    public CharSequence getTag() {
        this.tagCharSequence = this.decode(this.tagBuffer, this.tagCharSequence);
        return this.tagCharSequence.remaining() == 0 ? null : this.tagCharSequence;
    }

    public CharSequence getStem() {
        this.stemCharSequence = this.decode(this.stemBuffer, this.stemCharSequence);
        return this.stemCharSequence.remaining() == 0 ? null : this.stemCharSequence;
    }

    public CharSequence getWord() {
        return this.wordCharSequence;
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException(COLLECTIONS_ERROR_MESSAGE);
    }

    public int hashCode() {
        throw new UnsupportedOperationException(COLLECTIONS_ERROR_MESSAGE);
    }

    protected WordData clone() {
        WordData wordData = new WordData(this.decoder);
        wordData.wordCharSequence = this.cloneCharSequence(this.wordCharSequence);
        wordData.wordBuffer = this.getWordBytes(null);
        wordData.stemBuffer = this.getStemBytes(null);
        wordData.tagBuffer = this.getTagBytes(null);
        return wordData;
    }

    private CharSequence cloneCharSequence(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return charSequence;
        }
        return ((Object)charSequence).toString();
    }

    void reset() {
        this.wordCharSequence = null;
        this.wordBuffer = null;
        this.stemCharSequence.clear();
        this.tagCharSequence.clear();
        this.stemBuffer.clear();
        this.tagBuffer.clear();
    }

    private CharBuffer decode(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        charBuffer.clear();
        int n = (int)((float)byteBuffer.remaining() * this.decoder.maxCharsPerByte());
        if (charBuffer.capacity() <= n) {
            charBuffer = CharBuffer.allocate(n);
        }
        byteBuffer.mark();
        this.decoder.reset();
        this.decoder.decode(byteBuffer, charBuffer, true);
        charBuffer.flip();
        byteBuffer.reset();
        return charBuffer;
    }
}

