/*
 * Decompiled with CFR 0.152.
 */
package morfologik.util;

import java.util.Locale;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerformanceTimer {
    private int rounds;
    private long startTime;
    private long stopTime;
    private double totalTime;
    private double perRoundTime;

    public static PerformanceTimer run(Callable<Void> callable, int n, int n2) {
        PerformanceTimer performanceTimer = new PerformanceTimer();
        try {
            while (n-- > 0) {
                callable.call();
            }
            performanceTimer.start();
            performanceTimer.rounds = n2;
            while (n2-- > 0) {
                callable.call();
            }
            performanceTimer.stop();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return performanceTimer;
    }

    private void start() {
        this.startTime = System.currentTimeMillis();
    }

    private void stop() {
        this.stopTime = System.currentTimeMillis();
        this.totalTime = (double)(this.stopTime - this.startTime) / 1000.0;
        this.perRoundTime = this.totalTime / (double)this.rounds;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "Rounds: %d, Time: %.3f, Time/round: %.3f", this.rounds, this.totalTime, this.perRoundTime);
    }

    public long elemsPerSecond(int n) {
        return (long)((double)n / this.perRoundTime);
    }
}

