/*
 * Decompiled with CFR 0.152.
 */
package morfologik.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static InputStream openInputStream(String string) throws IOException {
        try {
            URL uRL = new URL(string);
            return uRL.openStream();
        }
        catch (MalformedURLException malformedURLException) {
            InputStream inputStream;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string)) != null) {
                return inputStream;
            }
            inputStream = ResourceUtils.class.getResourceAsStream(string);
            if (inputStream != null) {
                return inputStream;
            }
            inputStream = ClassLoader.getSystemResourceAsStream(string);
            if (inputStream != null) {
                return inputStream;
            }
            File file = new File(string);
            if (file.exists() && file.isFile() && file.canRead()) {
                return new FileInputStream(file);
            }
            throw new IOException("Could not locate resource: " + string);
        }
    }
}

