/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.io.InputStream;
import jline.ConsoleOperations;
import jline.UnixTerminal;
import jline.UnsupportedTerminal;
import jline.WindowsTerminal;

public abstract class Terminal
implements ConsoleOperations {
    private static Terminal term;

    public static Terminal getTerminal() {
        return Terminal.setupTerminal();
    }

    public static synchronized Terminal setupTerminal() {
        Terminal terminal;
        if (term != null) {
            return term;
        }
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("jline.terminal");
        if (string2 != null && string2.length() > 0) {
            try {
                terminal = (Terminal)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                throw (IllegalArgumentException)new IllegalArgumentException(exception.toString()).fillInStackTrace();
            }
        } else {
            terminal = string.indexOf("windows") != -1 ? new WindowsTerminal() : new UnixTerminal();
        }
        try {
            terminal.initializeTerminal();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            term = new UnsupportedTerminal();
            return term;
        }
        term = terminal;
        return term;
    }

    public boolean isANSISupported() {
        return true;
    }

    public int readCharacter(InputStream inputStream) throws IOException {
        return inputStream.read();
    }

    public int readVirtualKey(InputStream inputStream) throws IOException {
        return this.readCharacter(inputStream);
    }

    public abstract void initializeTerminal() throws Exception;

    public abstract int getTerminalWidth();

    public abstract int getTerminalHeight();

    public abstract boolean isSupported();

    public abstract boolean getEcho();
}

