"""
File:		Import.py
Purpose:	Importation handler

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# Python
try :
	import	sys
except :
	#slException("Python")

	print("\nError: The required 'Python' modules can't be imported.  See the documentation for more info.\n")

	# Exit
	sys.exit()

# Q7Z
#import	Settings


### Slots

def slException(sAppName) :

	print("\nError: The required '" + sAppName + "' modules can't be imported.  See the documentation for more info.\n")

	# FIXME: Eventually get the app-name from somewhere that's already imported

	# PyQt
	if sAppName == "PyQt4" :
		print("In case it has become attached to another installed Python version, try rebuilding Q7Z.\n")

	# Q7Z
	if sAppName == "Q7Z" :
	#if sAppName == Settings.Application.sName :
		print("You must run \"cd ../Build/ ; make ; cd ../Source/\" first.")
		print("If the problem still occurs, it might be due to a bug in your current PyQt version.\n")

	# Exit
	sys.exit()


# PyQt4
try :
	from	PyQt4	import QtCore
except :
	slException("PyQt4")


### Variables

# Visibility
Init				= QtCore.QObject()


### Slots

# Visibility
def slInvisible() :

	# Help
	if len(sys.argv) >= 2 and "h" in sys.argv[1] :
		bHelp = True
	else :
		bHelp = False

	# Invisible
	if len(sys.argv) >= 3 and "i" in sys.argv[1] :
		bInvisible = True
	else :
		bInvisible = False

	return (bHelp or bInvisible)

	"""
	if len(sys.argv) >= 3 and "i" in sys.argv[1] :
			Init.bInvisible = True

	return (len(sys.argv) >= 3 and "i" in sys.argv[1])
	"""

# Verbosity
def slVerbose() :

	# Supplied arguments
	return (len(sys.argv) >= 2 and "v" in sys.argv[1])


### Execution

Init.bInvisible = slInvisible()
Init.bVerbose	= slVerbose()
