function stats = spqr_rank_order_fields ( stats )
%SPQR_RANK_ORDER_FIELDS orders the fields of stats in a convenient order.
% Not user-callable.
% Usage:  stats = sqpr_rank_remove_fields (stats)

% Copyright 2012, Leslie Foster and Timothy A Davis.

% create stats0 which has the desired order for all potential fields
stats0 = struct( ...
    'flag',[], ...
    'rank',[],...
    'rank_spqr',[], ...
    'tol',[],...
    'tol_alt',[], ...
    'normest_A',[],...
    'normest_R',[],...
    'est_sval_upper_bounds',[], ...
    'est_sval_lower_bounds',[],...
    'est_svals_of_R',[], ...
    'est_svals',[],...
    'est_error_bounds',[],...
    'sval_numbers_for_bounds',[], ...
    'est_norm_A_times_N',[],...
    'est_err_bound_norm_A_times_N',[], ...
    'est_norm_A_transpose_times_NT',[],...
    'est_err_bound_norm_A_transpose_times_NT',[],...
    'norm_R_times_N',[], ...
    'norm_R_transpose_times_NT',[],...
    'iters',[], ...
    'nsvals_large_found',[],...
    'final_blocksize',[]',...
    'ssi_max_block_used',[], ...
    'ssi_min_block_used',[],...
    'stats_spqr_basic',[], ...
    'stats_spqr_null',[],...
    'info_spqr1',[], ...
    'info_spqr2',[],...
    'stats_ssi',[], ...
    'stats_ssp_N',[], ...
    'stats_ssp_NT',[],...
    'opts_used',[], ...
    'time',[],...
    'time_initialize',[], ...
    'time_basis',[], ...
    'time_iters',[],...
    'time_est_error_bounds',[], ...
    'time_svd',[]...
    );

% MATLAB's orderfields(stats,stats0) requires that stats and stats0 have the
%   same fields. The following command requires that the set of fields of
%   stats is a subset of the set of fields of stats0.
stats = orderfields( stats, ...
    rmfield( stats0 , setdiff( fieldnames(stats0), fieldnames(stats) ) ) ) ;

