/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.ErrorExpr;
import org.exolab.adaptx.xpath.engine.MatchExpression;
import org.exolab.adaptx.xpath.engine.PathExpr;

public class UnionExpr
extends XPathExpression
implements MatchExpression {
    private ErrorExpr error = null;
    private PathExpr _pathExpr = null;
    private UnionExpr _unionExpr = null;

    public UnionExpr() {
    }

    public UnionExpr(ErrorExpr errorExpr) {
        this.error = errorExpr;
    }

    public UnionExpr(PathExpr pathExpr) {
        this._pathExpr = pathExpr;
    }

    public UnionExpr(PathExpr pathExpr, UnionExpr unionExpr) {
        this._pathExpr = pathExpr;
        this._unionExpr = unionExpr;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.error != null) {
            this.error.evaluate(xPathContext);
        }
        NodeSet nodeSet = null;
        if (this._pathExpr != null) {
            nodeSet = this._pathExpr.evaluate(xPathContext, true);
        }
        if (this._unionExpr != null) {
            nodeSet.add((NodeSet)this._unionExpr.evaluate(xPathContext));
        }
        if (nodeSet == null) {
            return xPathContext.newNodeSet();
        }
        return nodeSet;
    }

    public short getExprType() {
        return 9;
    }

    public PathExpr getMatchingExpr(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        PathExpr pathExpr;
        if (this.error != null) {
            this.error.evaluate(xPathContext);
        }
        PathExpr pathExpr2 = null;
        if (this._pathExpr != null && this._pathExpr.matches(xPathNode, xPathContext)) {
            pathExpr2 = this._pathExpr;
        }
        if (this._unionExpr != null && (pathExpr = this._unionExpr.getMatchingExpr(xPathNode, xPathContext)) != null) {
            if (pathExpr2 == null) {
                return pathExpr;
            }
            if (pathExpr.getDefaultPriority() > pathExpr2.getDefaultPriority()) {
                pathExpr2 = pathExpr;
            }
        }
        return pathExpr2;
    }

    public boolean matches(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        if (this.error != null) {
            this.error.evaluate(null);
        }
        if (this._pathExpr != null && this._pathExpr.matches(xPathNode, xPathContext)) {
            return true;
        }
        if (this._unionExpr != null) {
            return this._unionExpr.matches(xPathNode, xPathContext);
        }
        return false;
    }

    public void setPathExpr(PathExpr pathExpr) {
        this._pathExpr = pathExpr;
    }

    public void setUnionExpr(UnionExpr unionExpr) {
        this._unionExpr = unionExpr;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    private void toString(StringBuffer stringBuffer) {
        if (this._pathExpr != null) {
            stringBuffer.append(this._pathExpr.toString());
        }
        if (this._unionExpr != null) {
            stringBuffer.append(" | ");
            this._unionExpr.toString(stringBuffer);
        }
    }
}

