/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.PGConnection;
import org.postgresql.core.Encoding;
import org.postgresql.jdbc1.AbstractJdbc1ResultSet;
import org.postgresql.jdbc2.AbstractJdbc2Connection;
import org.postgresql.jdbc2.AbstractJdbc2Statement;
import org.postgresql.jdbc2.Array;
import org.postgresql.util.PSQLException;

public abstract class AbstractJdbc2ResultSet
extends AbstractJdbc1ResultSet {
    protected boolean updateable = false;
    protected boolean doingUpdates = false;
    protected boolean onInsertRow = false;
    protected Hashtable updateValues = new Hashtable();
    private boolean usingOID = false;
    private Vector primaryKeys;
    private int numKeys = 0;
    private boolean singleTable = false;
    protected String tableName = null;
    protected PreparedStatement updateStatement = null;
    protected PreparedStatement insertStatement = null;
    protected PreparedStatement deleteStatement = null;
    private PreparedStatement selectStatement = null;

    public AbstractJdbc2ResultSet(PGConnection conn, Statement statement, Field[] fields, Vector tuples, String status, int updateCount, long insertOID, boolean binaryCursor) {
        super(conn, statement, fields, tuples, status, updateCount, insertOID, binaryCursor);
    }

    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    public URL getURL(String columnName) throws SQLException {
        return null;
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        switch (field.getSQLType()) {
            case -7: {
                return this.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Short(this.getShort(columnIndex));
            }
            case 4: {
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                return new Long(this.getLong(columnIndex));
            }
            case 2: {
                return this.getBigDecimal(columnIndex, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
        }
        String type = field.getPGType();
        if (type.equals("unknown")) {
            return this.getString(columnIndex);
        }
        return this.connection.getObject(field.getPGType(), this.getString(columnIndex));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean absolute(int index) throws SQLException {
        int internalIndex;
        if (index == 0) {
            throw new SQLException("Cannot move to index of 0");
        }
        int rows_size = this.rows.size();
        if (index < 0) {
            if (index < -rows_size) {
                this.beforeFirst();
                return false;
            }
            internalIndex = rows_size + index;
        } else {
            if (index > rows_size) {
                this.afterLast();
                return false;
            }
            internalIndex = index - 1;
        }
        this.current_row = internalIndex;
        this.this_row = (byte[][])this.rows.elementAt(internalIndex);
        return true;
    }

    public void afterLast() throws SQLException {
        int rows_size = this.rows.size();
        if (rows_size > 0) {
            this.current_row = rows_size;
        }
    }

    public void beforeFirst() throws SQLException {
        if (this.rows.size() > 0) {
            this.current_row = -1;
        }
    }

    public boolean first() throws SQLException {
        if (this.rows.size() <= 0) {
            return false;
        }
        this.onInsertRow = false;
        this.current_row = 0;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public java.sql.Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public java.sql.Array getArray(int i) throws SQLException {
        boolean bl = this.wasNullFlag = this.this_row[i - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (i < 1 || i > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        return new Array(this.connection, i, this.fields[i - 1], (ResultSet)((Object)this));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, -1);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    public abstract Blob getBlob(int var1) throws SQLException;

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int i) throws SQLException {
        this.checkResultSet(i);
        boolean bl = this.wasNullFlag = this.this_row[i - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (((AbstractJdbc2Connection)this.connection).haveMinimumCompatibleVersion("7.2")) {
            return new CharArrayReader(this.getString(i).toCharArray());
        }
        Encoding encoding = this.connection.getEncoding();
        InputStream input = this.getBinaryStream(i);
        return encoding.getDecodingReader(input);
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public abstract Clob getClob(int var1) throws SQLException;

    public int getConcurrency() throws SQLException {
        if (this.statement == null) {
            return 1007;
        }
        return this.statement.getResultSetConcurrency();
    }

    public Date getDate(int i, Calendar cal) throws SQLException {
        return this.getDate(i);
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        return this.getTime(i);
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        return this.getTimestamp(i);
    }

    public Date getDate(String c, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(c), cal);
    }

    public Time getTime(String c, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(c), cal);
    }

    public Timestamp getTimestamp(String c, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(c), cal);
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.rows.size();
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.getObject(this.findColumn(columnName), map);
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    public Ref getRef(int i) throws SQLException {
        throw new PSQLException("postgresql.psqlnotimp");
    }

    public int getRow() throws SQLException {
        int rows_size = this.rows.size();
        if (this.current_row < 0 || this.current_row >= rows_size) {
            return 0;
        }
        return this.current_row + 1;
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public boolean isAfterLast() throws SQLException {
        int rows_size = this.rows.size();
        return this.current_row >= rows_size && rows_size > 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.current_row < 0 && this.rows.size() > 0;
    }

    public boolean isFirst() throws SQLException {
        return this.current_row == 0 && this.rows.size() >= 0;
    }

    public boolean isLast() throws SQLException {
        int rows_size = this.rows.size();
        return this.current_row == rows_size - 1 && rows_size > 0;
    }

    public boolean last() throws SQLException {
        int rows_size = this.rows.size();
        if (rows_size <= 0) {
            return false;
        }
        this.current_row = rows_size - 1;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public boolean previous() throws SQLException {
        if (--this.current_row < 0) {
            return false;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.current_row + 1 + rows);
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new PSQLException("postgresql.psqlnotimp");
    }

    public void setFetchSize(int rows) throws SQLException {
        throw Driver.notImplemented();
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer();
        }
    }

    public synchronized void deleteRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new PSQLException("postgresql.updateable.notupdateable");
        }
        if (this.onInsertRow) {
            throw new PSQLException("postgresql.updateable.oninsertrow");
        }
        if (this.rows.size() == 0) {
            throw new PSQLException("postgresql.updateable.emptydelete");
        }
        if (this.isBeforeFirst()) {
            throw new PSQLException("postgresql.updateable.beforestartdelete");
        }
        if (this.isAfterLast()) {
            throw new PSQLException("postgresql.updateable.afterlastdelete");
        }
        int numKeys = this.primaryKeys.size();
        if (this.deleteStatement == null) {
            StringBuffer deleteSQL = new StringBuffer("DELETE FROM ").append(this.tableName).append(" where ");
            int i = 0;
            while (i < numKeys) {
                deleteSQL.append(((PrimaryKey)this.primaryKeys.get((int)i)).name).append(" = ? ");
                if (i < numKeys - 1) {
                    deleteSQL.append(" and ");
                }
                ++i;
            }
            this.deleteStatement = ((Connection)((Object)this.connection)).prepareStatement(deleteSQL.toString());
        }
        this.deleteStatement.clearParameters();
        int i = 0;
        while (i < numKeys) {
            this.deleteStatement.setObject(i + 1, ((PrimaryKey)this.primaryKeys.get(i)).getValue());
            ++i;
        }
        this.deleteStatement.executeUpdate();
        this.rows.removeElementAt(this.current_row);
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new PSQLException("postgresql.updateable.notupdateable");
        }
        if (!this.onInsertRow) {
            throw new PSQLException("postgresql.updateable.notoninsertrow");
        }
        StringBuffer insertSQL = new StringBuffer("INSERT INTO ").append(this.tableName).append(" (");
        StringBuffer paramSQL = new StringBuffer(") values (");
        Enumeration columnNames = this.updateValues.keys();
        int numColumns = this.updateValues.size();
        int i = 0;
        while (columnNames.hasMoreElements()) {
            String columnName = (String)columnNames.nextElement();
            insertSQL.append(columnName);
            if (i < numColumns - 1) {
                insertSQL.append(", ");
                paramSQL.append("?,");
            } else {
                paramSQL.append("?)");
            }
            ++i;
        }
        insertSQL.append(paramSQL.toString());
        this.insertStatement = ((Connection)((Object)this.connection)).prepareStatement(insertSQL.toString());
        Enumeration keys = this.updateValues.keys();
        int i2 = 1;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object o = this.updateValues.get(key);
            if (o instanceof NullObject) {
                this.insertStatement.setNull(i2, 0);
            } else {
                this.insertStatement.setObject(i2, o);
            }
            ++i2;
        }
        this.insertStatement.executeUpdate();
        if (this.usingOID) {
            long insertedOID = ((AbstractJdbc2Statement)((Object)this.insertStatement)).getLastOID();
            this.updateValues.put("oid", new Long(insertedOID));
        }
        this.updateRowBuffer();
        this.rows.addElement(this.rowBuffer);
        this.this_row = this.rowBuffer;
        this.clearRowBuffer();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        if (!this.updateable) {
            throw new PSQLException("postgresql.updateable.notupdateable");
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        this.onInsertRow = false;
        this.doingUpdates = false;
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new PSQLException("postgresql.updateable.notupdateable");
        }
        if (this.insertStatement != null) {
            this.insertStatement = null;
        }
        this.clearRowBuffer();
        this.onInsertRow = true;
        this.doingUpdates = false;
    }

    private synchronized void clearRowBuffer() throws SQLException {
        this.rowBuffer = new byte[this.fields.length][];
        this.updateValues.clear();
    }

    public boolean rowDeleted() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean rowInserted() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean rowUpdated() throws SQLException {
        throw Driver.notImplemented();
    }

    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        byte[] theData = null;
        try {
            x.read(theData, 0, length);
        }
        catch (NullPointerException ex) {
            throw new PSQLException("postgresql.updateable.inputstream");
        }
        catch (IOException ie) {
            throw new PSQLException("postgresql.updateable.ioerror" + ie);
        }
        this.updateValue(columnIndex, theData);
    }

    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        byte[] theData = null;
        try {
            x.read(theData, 0, length);
        }
        catch (NullPointerException ex) {
            throw new PSQLException("postgresql.updateable.inputstream");
        }
        catch (IOException ie) {
            throw new PSQLException("postgresql.updateable.ioerror" + ie);
        }
        this.updateValue(columnIndex, theData);
    }

    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating boolean " + this.fields[columnIndex - 1].getName() + "=" + x);
        }
        this.updateValue(columnIndex, new Boolean(x));
    }

    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateValue(columnIndex, String.valueOf(x));
    }

    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        char[] theData = null;
        try {
            x.read(theData, 0, length);
        }
        catch (NullPointerException ex) {
            throw new PSQLException("postgresql.updateable.inputstream");
        }
        catch (IOException ie) {
            throw new PSQLException("postgresql.updateable.ioerror" + ie);
        }
        this.updateValue(columnIndex, theData);
    }

    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating double " + this.fields[columnIndex - 1].getName() + "=" + x);
        }
        this.updateValue(columnIndex, new Double(x));
    }

    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating float " + this.fields[columnIndex - 1].getName() + "=" + x);
        }
        this.updateValue(columnIndex, new Float(x));
    }

    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating int " + this.fields[columnIndex - 1].getName() + "=" + x);
        }
        this.updateValue(columnIndex, new Integer(x));
    }

    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating long " + this.fields[columnIndex - 1].getName() + "=" + x);
        }
        this.updateValue(columnIndex, new Long(x));
    }

    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.updateValue(columnIndex, new NullObject());
    }

    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating object " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (!this.isUpdateable()) {
            throw new PSQLException("postgresql.updateable.notupdateable");
        }
        this.updateObject(columnIndex, x);
    }

    public void refreshRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new PSQLException("postgresql.updateable.notupdateable");
        }
        try {
            StringBuffer selectSQL = new StringBuffer("select ");
            int numColumns = java.lang.reflect.Array.getLength(this.fields);
            int i = 0;
            while (i < numColumns) {
                selectSQL.append(this.fields[i].getName());
                if (i < numColumns - 1) {
                    selectSQL.append(", ");
                }
                ++i;
            }
            selectSQL.append(" from ").append(this.tableName).append(" where ");
            int numKeys = this.primaryKeys.size();
            int i2 = 0;
            while (i2 < numKeys) {
                PrimaryKey primaryKey = (PrimaryKey)this.primaryKeys.get(i2);
                selectSQL.append(primaryKey.name).append("= ?");
                if (i2 < numKeys - 1) {
                    selectSQL.append(" and ");
                }
                ++i2;
            }
            if (Driver.logDebug) {
                Driver.debug("selecting " + selectSQL.toString());
            }
            this.selectStatement = ((Connection)((Object)this.connection)).prepareStatement(selectSQL.toString());
            int j = 0;
            int i3 = 1;
            while (j < numKeys) {
                this.selectStatement.setObject(i3, ((PrimaryKey)this.primaryKeys.get(j)).getValue());
                ++j;
                ++i3;
            }
            AbstractJdbc2ResultSet rs = (AbstractJdbc2ResultSet)((Object)this.selectStatement.executeQuery());
            if (rs.first()) {
                this.rowBuffer = rs.rowBuffer;
            }
            this.rows.setElementAt(this.rowBuffer, this.current_row);
            if (Driver.logDebug) {
                Driver.debug("done updates");
            }
            rs.close();
            this.selectStatement.close();
            this.selectStatement = null;
        }
        catch (Exception e) {
            if (Driver.logDebug) {
                Driver.debug(e.getClass().getName() + e);
            }
            throw new SQLException(e.getMessage());
        }
    }

    public synchronized void updateRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new PSQLException("postgresql.updateable.notupdateable");
        }
        if (this.doingUpdates) {
            try {
                StringBuffer updateSQL = new StringBuffer("UPDATE " + this.tableName + " SET  ");
                int numColumns = this.updateValues.size();
                Enumeration columns = this.updateValues.keys();
                int i = 0;
                while (columns.hasMoreElements()) {
                    String column = (String)columns.nextElement();
                    updateSQL.append(column + "= ?");
                    if (i < numColumns - 1) {
                        updateSQL.append(", ");
                    }
                    ++i;
                }
                updateSQL.append(" WHERE ");
                int numKeys = this.primaryKeys.size();
                int i2 = 0;
                while (i2 < numKeys) {
                    PrimaryKey primaryKey = (PrimaryKey)this.primaryKeys.get(i2);
                    updateSQL.append(primaryKey.name).append("= ?");
                    if (i2 < numKeys - 1) {
                        updateSQL.append(" and ");
                    }
                    ++i2;
                }
                if (Driver.logDebug) {
                    Driver.debug("updating " + updateSQL.toString());
                }
                this.updateStatement = ((Connection)((Object)this.connection)).prepareStatement(updateSQL.toString());
                int i3 = 0;
                Iterator iterator = this.updateValues.values().iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (o instanceof NullObject) {
                        this.updateStatement.setNull(i3 + 1, 0);
                    } else {
                        this.updateStatement.setObject(i3 + 1, o);
                    }
                    ++i3;
                }
                int j = 0;
                while (j < numKeys) {
                    this.updateStatement.setObject(i3 + 1, ((PrimaryKey)this.primaryKeys.get(j)).getValue());
                    ++j;
                    ++i3;
                }
                this.updateStatement.executeUpdate();
                this.updateStatement.close();
                this.updateStatement = null;
                this.updateRowBuffer();
                if (Driver.logDebug) {
                    Driver.debug("copying data");
                }
                System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
                this.rows.setElementAt(this.rowBuffer, this.current_row);
                if (Driver.logDebug) {
                    Driver.debug("done updates");
                }
                this.doingUpdates = false;
            }
            catch (Exception e) {
                if (Driver.logDebug) {
                    Driver.debug(e.getClass().getName() + e);
                }
                throw new SQLException(e.getMessage());
            }
        }
    }

    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("in update Short " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, new Short(x));
    }

    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("in update String " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("in update Time " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating Timestamp " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    private int _findColumn(String columnName) {
        int flen = this.fields.length;
        int i = 0;
        while (i < flen) {
            if (this.fields[i].getName().equalsIgnoreCase(columnName)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    boolean isUpdateable() throws SQLException {
        if (this.updateable) {
            return true;
        }
        if (Driver.logDebug) {
            Driver.debug("checking if rs is updateable");
        }
        this.parseQuery();
        if (!this.singleTable) {
            if (Driver.logDebug) {
                Driver.debug("not a single table");
            }
            return false;
        }
        if (Driver.logDebug) {
            Driver.debug("getting primary keys");
        }
        this.primaryKeys = new Vector();
        this.usingOID = false;
        int oidIndex = this._findColumn("oid");
        int i = 0;
        if (oidIndex > 0) {
            ++i;
            this.primaryKeys.add(new PrimaryKey(oidIndex, "oid"));
            this.usingOID = true;
        } else {
            ResultSet rs = ((Connection)((Object)this.connection)).getMetaData().getPrimaryKeys("", "", this.tableName);
            while (rs.next()) {
                String columnName = rs.getString(4);
                int index = this.findColumn(columnName);
                if (index > 0) {
                    this.primaryKeys.add(new PrimaryKey(index, columnName));
                }
                ++i;
            }
            rs.close();
        }
        this.numKeys = this.primaryKeys.size();
        if (Driver.logDebug) {
            Driver.debug("no of keys=" + i);
        }
        if (i < 1) {
            throw new SQLException("No Primary Keys");
        }
        boolean bl = this.updateable = this.primaryKeys.size() > 0;
        if (Driver.logDebug) {
            Driver.debug("checking primary key " + this.updateable);
        }
        return this.updateable;
    }

    public void parseQuery() {
        String[] l_sqlFragments = ((AbstractJdbc2Statement)((Object)this.statement)).getSqlFragments();
        String l_sql = l_sqlFragments[0];
        StringTokenizer st = new StringTokenizer(l_sql, " \r\t");
        boolean tableFound = false;
        boolean tablesChecked = false;
        String name = "";
        this.singleTable = true;
        while (!tableFound && !tablesChecked && st.hasMoreTokens()) {
            name = st.nextToken();
            if (!tableFound) {
                if (!name.toLowerCase().equals("from")) continue;
                this.tableName = st.nextToken();
                tableFound = true;
                continue;
            }
            tablesChecked = true;
            boolean bl = this.singleTable = !name.equalsIgnoreCase(",");
        }
    }

    private void updateRowBuffer() throws SQLException {
        Enumeration columns = this.updateValues.keys();
        while (columns.hasMoreElements()) {
            String columnName = (String)columns.nextElement();
            int columnIndex = this._findColumn(columnName) - 1;
            switch (this.connection.getSQLType(this.fields[columnIndex].getPGType())) {
                case -7: 
                case -6: 
                case -5: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 91: 
                case 92: 
                case 93: {
                    this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(String.valueOf(this.updateValues.get(columnName)));
                }
                case 0: {
                    break;
                }
                default: {
                    this.rowBuffer[columnIndex] = (byte[])this.updateValues.get(columnName);
                }
            }
        }
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    protected void updateValue(int columnIndex, Object value) throws SQLException {
        if (!this.isUpdateable()) {
            throw new PSQLException("postgresql.updateable.notupdateable");
        }
        boolean bl = this.doingUpdates = !this.onInsertRow;
        if (value == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateValues.put(this.fields[columnIndex - 1].getName(), value);
        }
    }

    class NullObject {
        NullObject() {
        }
    }

    private class PrimaryKey {
        int index;
        String name;

        PrimaryKey(int index, String name) {
            this.index = index;
            this.name = name;
        }

        Object getValue() throws SQLException {
            return AbstractJdbc2ResultSet.this.getObject(this.index);
        }
    }
}

