/**
 * Redistribution and use of this software and associated documentation
 * ("Software"), with or without modification, are permitted provided
 * that the following conditions are met:
 *
 * 1. Redistributions of source code must retain copyright
 *    statements and notices.  Redistributions must also contain a
 *    copy of this document.
 *
 * 2. Redistributions in binary form must reproduce the
 *    above copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *
 * 3. The name "Exolab" must not be used to endorse or promote
 *    products derived from this Software without prior written
 *    permission of Intalio, Inc.  For written permission,
 *    please contact info@exolab.org.
 *
 * 4. Products derived from this Software may not be called "Exolab"
 *    nor may "Exolab" appear in their names without prior written
 *    permission of Intalio, Inc. Exolab is a registered
 *    trademark of Intalio, Inc.
 *
 * 5. Due credit should be given to the Exolab Project
 *    (http://www.exolab.org/).
 *
 * THIS SOFTWARE IS PROVIDED BY INTALIO, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * INTALIO, INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright 1999-2002 (C) Intalio, Inc. All Rights Reserved.
 *
 * $Id: FieldInfoFactory.java,v 1.1.1.1 2003/03/03 07:07:43 kvisco Exp $
 */

package org.exolab.castor.builder;

import org.exolab.castor.builder.types.*;
import org.exolab.castor.xml.JavaNaming;


/**
 * This class is used as a factory to create all the FieldInfo objects used by the
 * source generator. You may override the FieldInfo classes and this factory for
 * specific adaptions.
 *
 * @author <a href="mailto:frank.thelen@poet.de">Frank Thelen</a>
 * @author <a href="mailto:blandin@intalio.com">Arnaud Blandin</a>
 * @version $Revision: 1.1.1.1 $ $Date: 2003/03/03 07:07:43 $
**/
public class FieldInfoFactory {

    private static final String VECTOR = "vector";
    private static final String ARRAY_LIST = "arraylist";
    private static final String ODMG = "odmg";

    /**
     * The default collection name
     */
    private String _default;

    /**
     * Creates a new FieldInfoFactory. The default collection used will be
     * Java 1 type.
    **/
    public FieldInfoFactory () {
        this("vector");
    } //-- FieldInfoFactory

    public FieldInfoFactory(String collectionName) {
        super();
        if (!(collectionName.equals(VECTOR) || collectionName.equals(ARRAY_LIST) || collectionName.equals(ODMG)))
            throw new IllegalArgumentException(collectionName+" is currently not a supported Java collection.");
        _default = collectionName;
    }

    public IdentityInfo createIdentity (String name) {
        return new IdentityInfo(name);
    } //-- createIdentity


    public CollectionInfo createCollection
        (XSType contentType, String name, String elementName)
    {
        return createCollection(contentType, name, elementName, _default);
    }

    public CollectionInfo createCollection
        (XSType contentType, String name, String elementName, String collectionName)
    {

        String temp = collectionName;
        if (temp == null || temp.length() >0)
            temp = _default;
        if (temp.equals(VECTOR)) {
             return new CollectionInfo(contentType,name,elementName);
        } else if (temp.equals(ARRAY_LIST)) {
             return new CollectionInfoJ2(contentType,name,elementName);
        } else if (temp.equals(ODMG)) {
             return new CollectionInfoODMG30(contentType,name,elementName);
        }
        //--other to come here
        //--not sure it is pluggable enough, it is not really beautiful to specify
        //--the collection to use here
        return null;
    }

    public FieldInfo createFieldInfo (XSType type, String name) {
        return new FieldInfo(type,name);
    } //-- createFieldInfo


} //-- FieldInfoFactory
