/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * ParsePosition.java
 * ------------
 */

package org.pentaho.reporting.libraries.formula.lvalues;

import java.io.Serializable;

/**
 * Todo: Document me!
 *
 * @author : Thomas Morgner
 */
public class ParsePosition implements Serializable
{
  private int startColumn;
  private int startLine;
  private int endColumn;
  private int endLine;

  public ParsePosition(final int startLine,
                       final int startColumn,
                       final int endLine,
                       final int endColumn)
  {
    this.startLine = startLine;
    this.startColumn = startColumn;
    this.endLine = endLine;
    this.endColumn = endColumn;
  }

  public int getEndColumn()
  {
    return endColumn;
  }

  public int getEndLine()
  {
    return endLine;
  }

  public int getStartColumn()
  {
    return startColumn;
  }

  public int getStartLine()
  {
    return startLine;
  }

  public String toString ()
  {
    return "ParsePosition={startLine=" + startLine +
        "; startColumn=" + startColumn +
        "; endLine=" + endLine +
        "; endColumn=" + endColumn + "}";

  }
}
