/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * NumberSequence.java
 * ------------
 */
package org.pentaho.reporting.libraries.formula.typing.sequence;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Type;

/**
 * @author Cedric Pronzato
 */
public class DefaultNumberSequence extends AnySequence implements NumberSequence
{
  /**
   * Empty number sequence.
   */
  public DefaultNumberSequence(final FormulaContext context)
  {
    super(context);
  }

  /**
   * Number sequence bounded to only one number item.
   *
   * @param n A number
   */
  public DefaultNumberSequence(final LValue n, final FormulaContext context)
  {
    super(n, context);
  }

  /**
   * Number sequence bounded to an array.
   *
   * @param array
   */
  public DefaultNumberSequence(final ArrayCallback array, final FormulaContext context)
  {
    super(array, context);
  }

  public DefaultNumberSequence(final AnySequence anySequence)
  {
    super(anySequence);
  }

  protected boolean isValidNext(final LValue o)
  {
    if (o == null)
    {
      return false;
    }
    final Type type = o.getValueType();
    if (type == null)
    {
      throw new IllegalStateException();
    }
    if (type.isFlagSet(Type.NUMERIC_TYPE))
    {
      return true;
    }
    return false;
  }

  public Number nextNumber() throws EvaluationException
  {
    final Object value = super.next();
    if (value instanceof Number)
    {
      return (Number) value;
    }

    return null;
  }
}
