#!/bin/bash
# modified from 9realloc.sh in ptexlive-20100322

. ./common.sh $*

if [[ ${EUID} != 0 ]] ; then
  echo
  echo "This script may not run correctly because you are not root."
  echo "Press Return to continue, Ctrl+C to abort."
  read -r &>/dev/null
fi

confirm() {
    echo -n "$1 (yes/No) "
    read REPLY <&2
    case $REPLY in
        y*|Y*) true;;
        *) echo "Aborted."; exit 0;;
    esac
}

test -d "$PREFIX" && confirm "'$PREFIX' is found. Overwrite?"
mkdir -p $PREFIX
(cd $SRCDIR/inst && tar cf - *) \
    | (cd $PREFIX && tar xf -) || exit  1

cat <<EOF

****************
Installation is finished.
Please set $PATH: 

  (sh/bash user):  export PATH=$PREFIX/bin/$ARCH:\$PATH
  (csh/tcsh user): setenv PATH $PREFIX/bin/$ARCH:\$PATH
EOF

exit 0