#!/bin/bash

. ./common.sh $*

cd $SRCDIR/inst
rm -rf texmf-dist
ln -s $TLINSTDIR/texmf-dist texmf-dist

# japanese.sty
mkdir -p texmf/tex/platex/japanese
cd texmf/tex/platex/japanese
tarz $TLSRCDIR/ptex/japanese.zip
rm japanese.ldf sample.tex ; echo -e "\\input ptex.tex\\input japanese.ins\ny" | ptex -ini
mkdir -p ../../../doc/platex/japanese
mv sample.* ../../../doc/platex/japanese/
mv README ../../../doc/platex/japanese/
cd ../../../..

# utf package
tarz $TLSRCDIR/ptex/utfsrc.zip
cd utfsrc
sedwrite mkjvf "s/ovp2ovf/wovp2ovf/" && chmod +x mkjvf
for x in script/*.pl; do sedwrite $x "s/ovp2ovf/wovp2ovf/"; chmod +x $x; done
./makeutf
mkdir -p ../texmf/fonts/tfm/utf && cp tfm/*.tfm ../texmf/fonts/tfm/utf/
mkdir -p ../texmf/fonts/vf/utf && cp vf/*.vf ../texmf/fonts/vf/utf/
mkdir -p ../texmf/fonts/ofm/utf && cp ofm/*.ofm ../texmf/fonts/ofm/utf/
mkdir -p ../texmf/tex/latex/utf && cp sty/* ../texmf/tex/latex/utf
cd ..
rm -rf utfsrc

# otf package
tarz $TLSRCDIR/ptex/otfstable.zip
if [ "$FLG_UP" = "TRUE" ] ;then
    tar zxf $TLSRCDIR/uptex/otfstable-uptex-0.05.tar.gz
fi
cd otfstable
sedwrite mkjvf "s/ovp2ovf/wovp2ovf/" && chmod +x mkjvf
if [ "$FLG_UP" = "TRUE" ] ;then
    sedwrite umkjvf "s/'ovp2ovf/'wovp2ovf/" && chmod +x umkjvf
fi
for x in script/*.pl; do sedwrite $x "s/ovp2ovf/wovp2ovf/"; chmod +x $x; done
./makeotf
if [ "$FLG_UP" = "TRUE" ] ;then
    ./umakeotf
fi
mkdir -p ../texmf/fonts/tfm/otf && cp tfm/*.tfm ../texmf/fonts/tfm/otf/
mkdir -p ../texmf/fonts/vf/otf && cp vf/*.vf ../texmf/fonts/vf/otf/
mkdir -p ../texmf/fonts/ofm/otf && cp ofm/*.ofm ../texmf/fonts/ofm/otf/
mkdir -p ../texmf/tex/latex/otf && cp sty/* ../texmf/tex/latex/otf
cd ..
rm -rf otfstable

echo -e "\e[0;33m[rewriting] \e[0m updmap.cfg"
echo "KanjiMap otf-cktx.map" >> texmf/web2c/updmap.cfg || exit
echo -e "\e[0;33m[writing]   \e[0m otf-cktx.map"b
cat <<EOF > $XMAP/otf-cktx.map
otf-ukmr-h   UniKS-UCS2-H  HYSMyeongJoStd-Medium
otf-ukmr-v   UniKS-UCS2-V  HYSMyeongJoStd-Medium
otf-ukgr-h  UniKS-UCS2-H HYGoThic-Medium
otf-ukgr-v  UniKS-UCS2-V HYGoThic-Medium

otf-ucmr-h   UniGB-UCS2-H STSongStd-Light
otf-ucmr-v   UniGB-UCS2-V STSongStd-Light
otf-ucgr-h UniGB-UCS2-H STHeiti-Regular
otf-ucgr-v UniGB-UCS2-V STHeiti-Regular

otf-utmr-h   UniCNS-UCS2-H MSungStd-Light
otf-utmr-v   UniCNS-UCS2-V MSungStd-Light
otf-utgr-h  UniCNS-UCS2-H MHei-Medium
otf-utgr-v  UniCNS-UCS2-V MHei-Medium

otf-ckmr-h   Identity-H  HYSMyeongJoStd-Medium
otf-ckmr-v   Identity-V  HYSMyeongJoStd-Medium
otf-ckgr-h  Identity-H HYGoThic-Medium
otf-ckgr-v  Identity-V HYGoThic-Medium

otf-ccmr-h   Identity-H STSongStd-Light
otf-ccmr-v   Identity-V STSongStd-Light
otf-ccgr-h Identity-H STHeiti-Regular
otf-ccgr-v Identity-V STHeiti-Regular

otf-ctmr-h   Identity-H MSungStd-Light
otf-ctmr-v   Identity-V MSungStd-Light
otf-ctgr-h  Identity-H MHei-Medium
otf-ctgr-v  Identity-V MHei-Medium
EOF

echo "Finishing..."
mktexlsr &>/dev/null
updmap-sys --syncwithtrees --nomkmap &>/dev/null
exit 0
