/* ChannelList.c generated by valac 0.25.1, the Vala compiler
 * generated from ChannelList.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_ID_BUS_CHANNEL_LIST (dvb_id_bus_channel_list_get_type ())
#define DVB_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelList))
#define DVB_IS_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST))
#define DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelListIface))

typedef struct _DVBIDBusChannelList DVBIDBusChannelList;
typedef struct _DVBIDBusChannelListIface DVBIDBusChannelListIface;

#define DVB_TYPE_ID_BUS_CHANNEL_LIST_PROXY (dvb_id_bus_channel_list_proxy_get_type ())

#define DVB_TYPE_CHANNEL_INFO (dvb_channel_info_get_type ())
typedef struct _DVBChannelInfo DVBChannelInfo;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;
typedef struct _DVBChannelListPrivate DVBChannelListPrivate;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_IO_TYPE_CHANNEL_LIST_READER (dvb_io_channel_list_reader_get_type ())
#define DVB_IO_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReader))
#define DVB_IO_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))
#define DVB_IO_IS_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_IS_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_CHANNEL_LIST_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))

typedef struct _DVBioChannelListReader DVBioChannelListReader;
typedef struct _DVBioChannelListReaderClass DVBioChannelListReaderClass;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_FACTORY (dvb_factory_get_type ())
#define DVB_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_FACTORY, DVBFactory))
#define DVB_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_FACTORY, DVBFactoryClass))
#define DVB_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_FACTORY))
#define DVB_IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_FACTORY))
#define DVB_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_FACTORY, DVBFactoryClass))

typedef struct _DVBFactory DVBFactory;
typedef struct _DVBFactoryClass DVBFactoryClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DVBChannelInfo {
	guint id;
	gchar* name;
	gboolean is_radio;
};

struct _DVBIDBusChannelListIface {
	GTypeInterface parent_iface;
	guint* (*GetChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	guint* (*GetRadioChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	guint* (*GetTVChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	gboolean (*GetChannelName) (DVBIDBusChannelList* self, guint channel_id, gchar** channel_name, GError** error);
	gboolean (*GetChannelNetwork) (DVBIDBusChannelList* self, guint channel_id, gchar** network, GError** error);
	gboolean (*IsRadioChannel) (DVBIDBusChannelList* self, guint channel_id, gboolean* radio, GError** error);
	gboolean (*GetChannelURL) (DVBIDBusChannelList* self, guint channel_id, gchar** url, GError** error);
	DVBChannelInfo* (*GetChannelInfos) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	gboolean (*GetChannelsOfGroup) (DVBIDBusChannelList* self, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error);
	gboolean (*AddChannelToGroup) (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
	gboolean (*RemoveChannelFromGroup) (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
};

struct _DVBChannelList {
	GObject parent_instance;
	DVBChannelListPrivate * priv;
	GeeHashMap* channels;
};

struct _DVBChannelListClass {
	GObjectClass parent_class;
};

struct _DVBChannelListPrivate {
	GFile* _channels_file;
	guint _GroupId;
	GRecMutex __lock_channels;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_TERRESTRIAL,
	DVB_ADAPTER_TYPE_SATELLITE,
	DVB_ADAPTER_TYPE_CABLE
} DVBAdapterType;

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	DVBDeviceGroup* (*get_device_group) (DVBdatabaseConfigStore* self, guint group_id, GError** error);
	gboolean (*is_last_device) (DVBdatabaseConfigStore* self, guint group_id, GError** error);
	gboolean (*is_group_member) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* group, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_groups) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint** group_ids, int* group_ids_length1, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};


static gpointer dvb_channel_list_parent_class = NULL;
static DVBLoggingLogger* dvb_channel_list_log;
static DVBLoggingLogger* dvb_channel_list_log = NULL;
static GeeTraversableIface* dvb_channel_list_gee_traversable_parent_iface = NULL;
static GeeIterableIface* dvb_channel_list_gee_iterable_parent_iface = NULL;
static DVBIDBusChannelListIface* dvb_channel_list_dvb_id_bus_channel_list_parent_iface = NULL;

GType dvb_id_bus_channel_list_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_channel_list_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_channel_info_get_type (void) G_GNUC_CONST;
DVBChannelInfo* dvb_channel_info_dup (const DVBChannelInfo* self);
void dvb_channel_info_free (DVBChannelInfo* self);
void dvb_channel_info_copy (const DVBChannelInfo* self, DVBChannelInfo* dest);
void dvb_channel_info_destroy (DVBChannelInfo* self);
GType dvb_id_bus_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
#define DVB_CHANNEL_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_LIST, DVBChannelListPrivate))
enum  {
	DVB_CHANNEL_LIST_DUMMY_PROPERTY,
	DVB_CHANNEL_LIST_CHANNELS_FILE,
	DVB_CHANNEL_LIST_GROUP_ID,
	DVB_CHANNEL_LIST_SIZE,
	DVB_CHANNEL_LIST_ELEMENT_TYPE
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
guint dvb_channel_get_Sid (DVBChannel* self);
void dvb_channel_list_remove (DVBChannelList* self, guint sid);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
void dvb_channel_list_clear (DVBChannelList* self);
static GeeIterator* dvb_channel_list_real_iterator (GeeIterable* base);
static gboolean dvb_channel_list_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
void dvb_channel_list_load (DVBChannelList* self, DVBAdapterType type, GError** error);
GType dvb_io_channel_list_reader_get_type (void) G_GNUC_CONST;
DVBioChannelListReader* dvb_io_channel_list_reader_new (DVBChannelList* channels, DVBAdapterType type);
DVBioChannelListReader* dvb_io_channel_list_reader_construct (GType object_type, DVBChannelList* channels, DVBAdapterType type);
void dvb_io_channel_list_reader_read_into (DVBioChannelListReader* self, GError** error);
static guint* dvb_channel_list_real_GetChannels (DVBIDBusChannelList* base, int* result_length1, GError** error);
gint dvb_channel_list_get_size (DVBChannelList* self);
static guint* dvb_channel_list_real_GetRadioChannels (DVBIDBusChannelList* base, int* result_length1, GError** error);
guint dvb_channel_get_VideoPID (DVBChannel* self);
static guint* dvb_channel_list_real_GetTVChannels (DVBIDBusChannelList* base, int* result_length1, GError** error);
gboolean dvb_channel_is_radio (DVBChannel* self);
static gboolean dvb_channel_list_real_GetChannelName (DVBIDBusChannelList* base, guint channel_id, gchar** channel_name, GError** error);
const gchar* dvb_channel_get_Name (DVBChannel* self);
static gboolean dvb_channel_list_real_GetChannelNetwork (DVBIDBusChannelList* base, guint channel_id, gchar** network, GError** error);
const gchar* dvb_channel_get_Network (DVBChannel* self);
static gboolean dvb_channel_list_real_IsRadioChannel (DVBIDBusChannelList* base, guint channel_id, gboolean* radio, GError** error);
static gboolean dvb_channel_list_real_GetChannelURL (DVBIDBusChannelList* base, guint channel_id, gchar** url, GError** error);
gchar* dvb_channel_get_URL (DVBChannel* self);
static DVBChannelInfo* dvb_channel_list_real_GetChannelInfos (DVBIDBusChannelList* base, int* result_length1, GError** error);
static void _vala_DVBChannelInfo_array_free (DVBChannelInfo* array, gint array_length);
static gboolean dvb_channel_list_real_GetChannelsOfGroup (DVBIDBusChannelList* base, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_construct (GType object_type);
GType dvb_factory_get_type (void) G_GNUC_CONST;
DVBdatabaseConfigStore* dvb_factory_get_config_store (DVBFactory* self);
GeeList* dvb_database_config_store_get_channels_of_group (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
guint dvb_channel_list_get_GroupId (DVBChannelList* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
static gboolean dvb_channel_list_real_AddChannelToGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error);
gboolean dvb_database_config_store_add_channel_to_group (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
static gboolean dvb_channel_list_real_RemoveChannelFromGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error);
gboolean dvb_database_config_store_remove_channel_from_group (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
GFile* dvb_channel_list_get_channels_file (DVBChannelList* self);
static void dvb_channel_list_set_channels_file (DVBChannelList* self, GFile* value);
void dvb_channel_list_set_GroupId (DVBChannelList* self, guint value);
static GObject * dvb_channel_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_channel_list_finalize (GObject* obj);
static void _vala_dvb_channel_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_channel_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels) {
	DVBChannelList * self = NULL;
	GFile* _tmp0_ = NULL;
	_tmp0_ = channels;
	self = (DVBChannelList*) g_object_new (object_type, "channels-file", _tmp0_, NULL);
	return self;
}


DVBChannelList* dvb_channel_list_new (GFile* channels) {
	return dvb_channel_list_construct (DVB_TYPE_CHANNEL_LIST, channels);
}


DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid) {
	DVBChannel* result = NULL;
	DVBChannel* val = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	val = NULL;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->channels;
			_tmp2_ = sid;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				gpointer _tmp6_ = NULL;
				_tmp4_ = self->channels;
				_tmp5_ = sid;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) _tmp5_));
				_g_object_unref0 (val);
				val = (DVBChannel*) _tmp6_;
			}
		}
		__finally32:
		{
			GeeHashMap* _tmp7_ = NULL;
			_tmp7_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (val);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = val;
	return result;
}


void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeHashMap* _tmp1_ = NULL;
			DVBChannel* _tmp2_ = NULL;
			guint _tmp3_ = 0U;
			guint _tmp4_ = 0U;
			DVBChannel* _tmp5_ = NULL;
			_tmp1_ = self->channels;
			_tmp2_ = channel;
			_tmp3_ = dvb_channel_get_Sid (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = channel;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp4_), _tmp5_);
		}
		__finally33:
		{
			GeeHashMap* _tmp6_ = NULL;
			_tmp6_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_channel_list_remove (DVBChannelList* self, guint sid) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint _tmp2_ = 0U;
			_tmp1_ = self->channels;
			_tmp2_ = sid;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_), NULL);
		}
		__finally34:
		{
			GeeHashMap* _tmp3_ = NULL;
			_tmp3_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->channels;
			_tmp2_ = sid;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			val = _tmp3_;
		}
		__finally35:
		{
			GeeHashMap* _tmp4_ = NULL;
			_tmp4_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


void dvb_channel_list_clear (DVBChannelList* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeHashMap* _tmp1_ = NULL;
			_tmp1_ = self->channels;
			gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
		}
		__finally36:
		{
			GeeHashMap* _tmp2_ = NULL;
			_tmp2_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static GeeIterator* dvb_channel_list_real_iterator (GeeIterable* base) {
	DVBChannelList * self;
	GeeIterator* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	GeeCollection* _tmp3_ = NULL;
	GeeIterator* _tmp4_ = NULL;
	GeeIterator* _tmp5_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = self->channels;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static gboolean dvb_channel_list_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	DVBChannelList * self;
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* _tmp2_ = NULL;
	GeeForallFunc _tmp3_ = NULL;
	void* _tmp3__target = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	self = (DVBChannelList*) base;
	_tmp0_ = self->channels;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = f;
	_tmp3__target = f_target;
	_tmp4_ = gee_traversable_foreach ((GeeTraversable*) _tmp2_, _tmp3_, _tmp3__target);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


void dvb_channel_list_load (DVBChannelList* self, DVBAdapterType type, GError** error) {
	DVBioChannelListReader* reader = NULL;
	DVBAdapterType _tmp0_ = 0;
	DVBioChannelListReader* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = type;
	_tmp1_ = dvb_io_channel_list_reader_new (self, _tmp0_);
	reader = _tmp1_;
	dvb_io_channel_list_reader_read_into (reader, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (reader);
		return;
	}
	_g_object_unref0 (reader);
}


/**
         * @returns: List of channel IDs aka SIDs
         */
static guint* dvb_channel_list_real_GetChannels (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	guint* result = NULL;
	guint* ids = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	guint* _tmp2_ = NULL;
	gint ids_length1 = 0;
	gint _ids_size_ = 0;
	gint i = 0;
	guint* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = dvb_channel_list_get_size (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (guint, _tmp1_);
	ids = _tmp2_;
	ids_length1 = _tmp1_;
	_ids_size_ = ids_length1;
	i = 0;
	{
		GeeHashMap* _tmp3_ = NULL;
		_tmp3_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			{
				GeeIterator* _id_it = NULL;
				GeeHashMap* _tmp4_ = NULL;
				GeeSet* _tmp5_ = NULL;
				GeeSet* _tmp6_ = NULL;
				GeeSet* _tmp7_ = NULL;
				GeeIterator* _tmp8_ = NULL;
				GeeIterator* _tmp9_ = NULL;
				_tmp4_ = self->channels;
				_tmp5_ = gee_abstract_map_get_keys ((GeeMap*) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = _tmp6_;
				_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (_tmp7_);
				_id_it = _tmp9_;
				while (TRUE) {
					GeeIterator* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					guint id = 0U;
					GeeIterator* _tmp12_ = NULL;
					gpointer _tmp13_ = NULL;
					guint* _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					guint _tmp16_ = 0U;
					guint _tmp17_ = 0U;
					gint _tmp18_ = 0;
					_tmp10_ = _id_it;
					_tmp11_ = gee_iterator_next (_tmp10_);
					if (!_tmp11_) {
						break;
					}
					_tmp12_ = _id_it;
					_tmp13_ = gee_iterator_get (_tmp12_);
					id = (guint) ((guintptr) _tmp13_);
					_tmp14_ = ids;
					_tmp14__length1 = ids_length1;
					_tmp15_ = i;
					_tmp16_ = id;
					_tmp14_[_tmp15_] = _tmp16_;
					_tmp17_ = _tmp14_[_tmp15_];
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_g_object_unref0 (_id_it);
			}
		}
		__finally37:
		{
			GeeHashMap* _tmp19_ = NULL;
			_tmp19_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp20_ = ids;
	_tmp20__length1 = ids_length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	return result;
}


/**
         * @returns: List of channel IDs aka SIDs of radio channels
         */
static guint* dvb_channel_list_real_GetRadioChannels (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	guint* result = NULL;
	GSList* radio_channels = NULL;
	guint* ids = NULL;
	GSList* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint* _tmp21_ = NULL;
	gint ids_length1 = 0;
	gint _ids_size_ = 0;
	guint* _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	radio_channels = NULL;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			{
				GeeIterator* _id_it = NULL;
				GeeHashMap* _tmp1_ = NULL;
				GeeSet* _tmp2_ = NULL;
				GeeSet* _tmp3_ = NULL;
				GeeSet* _tmp4_ = NULL;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_ = NULL;
				_tmp1_ = self->channels;
				_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_id_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
					guint id = 0U;
					GeeIterator* _tmp9_ = NULL;
					gpointer _tmp10_ = NULL;
					DVBChannel* chan = NULL;
					GeeHashMap* _tmp11_ = NULL;
					guint _tmp12_ = 0U;
					gpointer _tmp13_ = NULL;
					DVBChannel* _tmp14_ = NULL;
					guint _tmp15_ = 0U;
					guint _tmp16_ = 0U;
					_tmp7_ = _id_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _id_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					id = (guint) ((guintptr) _tmp10_);
					_tmp11_ = self->channels;
					_tmp12_ = id;
					_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, (gpointer) ((guintptr) _tmp12_));
					chan = (DVBChannel*) _tmp13_;
					_tmp14_ = chan;
					_tmp15_ = dvb_channel_get_VideoPID (_tmp14_);
					_tmp16_ = _tmp15_;
					if (_tmp16_ == ((guint) 0)) {
						guint _tmp17_ = 0U;
						_tmp17_ = id;
						radio_channels = g_slist_prepend (radio_channels, (gpointer) ((guintptr) _tmp17_));
					}
					_g_object_unref0 (chan);
				}
				_g_object_unref0 (_id_it);
			}
		}
		__finally38:
		{
			GeeHashMap* _tmp18_ = NULL;
			_tmp18_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_slist_free0 (radio_channels);
				return NULL;
			} else {
				_g_slist_free0 (radio_channels);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	radio_channels = g_slist_reverse (radio_channels);
	_tmp19_ = radio_channels;
	_tmp20_ = g_slist_length (_tmp19_);
	_tmp21_ = g_new0 (guint, _tmp20_);
	ids = _tmp21_;
	ids_length1 = _tmp20_;
	_ids_size_ = ids_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gint _tmp24_ = 0;
				GSList* _tmp25_ = NULL;
				guint _tmp26_ = 0U;
				guint* _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gint _tmp28_ = 0;
				GSList* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gconstpointer _tmp31_ = NULL;
				guint _tmp32_ = 0U;
				if (!_tmp22_) {
					gint _tmp23_ = 0;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = radio_channels;
				_tmp26_ = g_slist_length (_tmp25_);
				if (!(((guint) _tmp24_) < _tmp26_)) {
					break;
				}
				_tmp27_ = ids;
				_tmp27__length1 = ids_length1;
				_tmp28_ = i;
				_tmp29_ = radio_channels;
				_tmp30_ = i;
				_tmp31_ = g_slist_nth_data (_tmp29_, (guint) _tmp30_);
				_tmp27_[_tmp28_] = (guint) ((guintptr) _tmp31_);
				_tmp32_ = _tmp27_[_tmp28_];
			}
		}
	}
	_tmp33_ = ids;
	_tmp33__length1 = ids_length1;
	if (result_length1) {
		*result_length1 = _tmp33__length1;
	}
	result = _tmp33_;
	_g_slist_free0 (radio_channels);
	return result;
}


/**
         * @returns: List of channel IDs aka SIDs of TV channels
         */
static guint* dvb_channel_list_real_GetTVChannels (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	guint* result = NULL;
	GSList* video_channels = NULL;
	guint* ids = NULL;
	GSList* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	guint* _tmp20_ = NULL;
	gint ids_length1 = 0;
	gint _ids_size_ = 0;
	guint* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	video_channels = NULL;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			{
				GeeIterator* _id_it = NULL;
				GeeHashMap* _tmp1_ = NULL;
				GeeSet* _tmp2_ = NULL;
				GeeSet* _tmp3_ = NULL;
				GeeSet* _tmp4_ = NULL;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_ = NULL;
				_tmp1_ = self->channels;
				_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_id_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
					guint id = 0U;
					GeeIterator* _tmp9_ = NULL;
					gpointer _tmp10_ = NULL;
					DVBChannel* chan = NULL;
					GeeHashMap* _tmp11_ = NULL;
					guint _tmp12_ = 0U;
					gpointer _tmp13_ = NULL;
					DVBChannel* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
					_tmp7_ = _id_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _id_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					id = (guint) ((guintptr) _tmp10_);
					_tmp11_ = self->channels;
					_tmp12_ = id;
					_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, (gpointer) ((guintptr) _tmp12_));
					chan = (DVBChannel*) _tmp13_;
					_tmp14_ = chan;
					_tmp15_ = dvb_channel_is_radio (_tmp14_);
					if (!_tmp15_) {
						guint _tmp16_ = 0U;
						_tmp16_ = id;
						video_channels = g_slist_prepend (video_channels, (gpointer) ((guintptr) _tmp16_));
					}
					_g_object_unref0 (chan);
				}
				_g_object_unref0 (_id_it);
			}
		}
		__finally39:
		{
			GeeHashMap* _tmp17_ = NULL;
			_tmp17_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_slist_free0 (video_channels);
				return NULL;
			} else {
				_g_slist_free0 (video_channels);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	video_channels = g_slist_reverse (video_channels);
	_tmp18_ = video_channels;
	_tmp19_ = g_slist_length (_tmp18_);
	_tmp20_ = g_new0 (guint, _tmp19_);
	ids = _tmp20_;
	ids_length1 = _tmp19_;
	_ids_size_ = ids_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gint _tmp23_ = 0;
				GSList* _tmp24_ = NULL;
				guint _tmp25_ = 0U;
				guint* _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				GSList* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gconstpointer _tmp30_ = NULL;
				guint _tmp31_ = 0U;
				if (!_tmp21_) {
					gint _tmp22_ = 0;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp23_ = i;
				_tmp24_ = video_channels;
				_tmp25_ = g_slist_length (_tmp24_);
				if (!(((guint) _tmp23_) < _tmp25_)) {
					break;
				}
				_tmp26_ = ids;
				_tmp26__length1 = ids_length1;
				_tmp27_ = i;
				_tmp28_ = video_channels;
				_tmp29_ = i;
				_tmp30_ = g_slist_nth_data (_tmp28_, (guint) _tmp29_);
				_tmp26_[_tmp27_] = (guint) ((guintptr) _tmp30_);
				_tmp31_ = _tmp26_[_tmp27_];
			}
		}
	}
	_tmp32_ = ids;
	_tmp32__length1 = ids_length1;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	_g_slist_free0 (video_channels);
	return result;
}


/**
         * @channel_id: ID of channel
         * @channel_name: Name of channel if channel with id exists
         * otherwise an empty string
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_GetChannelName (DVBIDBusChannelList* base, guint channel_id, gchar** channel_name, GError** error) {
	DVBChannelList * self;
	gchar* _vala_channel_name = NULL;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gchar* val = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	ret = FALSE;
	_tmp0_ = g_strdup ("");
	val = _tmp0_;
	{
		GeeHashMap* _tmp1_ = NULL;
		_tmp1_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeHashMap* _tmp2_ = NULL;
			guint _tmp3_ = 0U;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->channels;
			_tmp3_ = channel_id;
			_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, (gpointer) ((guintptr) _tmp3_));
			if (_tmp4_) {
				gchar* name = NULL;
				GeeHashMap* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				gpointer _tmp7_ = NULL;
				DVBChannel* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp16_ = NULL;
				_tmp5_ = self->channels;
				_tmp6_ = channel_id;
				_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, (gpointer) ((guintptr) _tmp6_));
				_tmp8_ = (DVBChannel*) _tmp7_;
				_tmp9_ = dvb_channel_get_Name (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = _tmp11_;
				_g_object_unref0 (_tmp8_);
				name = _tmp12_;
				_tmp14_ = name;
				if (_tmp14_ == NULL) {
					_tmp13_ = "";
				} else {
					const gchar* _tmp15_ = NULL;
					_tmp15_ = name;
					_tmp13_ = _tmp15_;
				}
				_tmp16_ = g_strdup (_tmp13_);
				_g_free0 (val);
				val = _tmp16_;
				ret = TRUE;
				_g_free0 (name);
			}
		}
		__finally40:
		{
			GeeHashMap* _tmp17_ = NULL;
			_tmp17_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (val);
				return FALSE;
			} else {
				_g_free0 (val);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp18_ = val;
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (_vala_channel_name);
	_vala_channel_name = _tmp19_;
	result = ret;
	_g_free0 (val);
	if (channel_name) {
		*channel_name = _vala_channel_name;
	} else {
		_g_free0 (_vala_channel_name);
	}
	return result;
}


/**
         * @channel_id: ID of channel
         * @network: Name of network the channel belongs to
         * if the channel with id exists, otherwise an empty
         * string
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_GetChannelNetwork (DVBIDBusChannelList* base, guint channel_id, gchar** network, GError** error) {
	DVBChannelList * self;
	gchar* _vala_network = NULL;
	gboolean result = FALSE;
	gchar* val = NULL;
	gchar* _tmp0_ = NULL;
	gboolean ret = FALSE;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = g_strdup ("");
	val = _tmp0_;
	ret = FALSE;
	{
		GeeHashMap* _tmp1_ = NULL;
		_tmp1_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeHashMap* _tmp2_ = NULL;
			guint _tmp3_ = 0U;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->channels;
			_tmp3_ = channel_id;
			_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, (gpointer) ((guintptr) _tmp3_));
			if (_tmp4_) {
				gchar* tmp = NULL;
				GeeHashMap* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				gpointer _tmp7_ = NULL;
				DVBChannel* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp16_ = NULL;
				_tmp5_ = self->channels;
				_tmp6_ = channel_id;
				_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, (gpointer) ((guintptr) _tmp6_));
				_tmp8_ = (DVBChannel*) _tmp7_;
				_tmp9_ = dvb_channel_get_Network (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = _tmp11_;
				_g_object_unref0 (_tmp8_);
				tmp = _tmp12_;
				_tmp14_ = tmp;
				if (_tmp14_ == NULL) {
					_tmp13_ = "";
				} else {
					const gchar* _tmp15_ = NULL;
					_tmp15_ = tmp;
					_tmp13_ = _tmp15_;
				}
				_tmp16_ = g_strdup (_tmp13_);
				_g_free0 (val);
				val = _tmp16_;
				ret = TRUE;
				_g_free0 (tmp);
			}
		}
		__finally41:
		{
			GeeHashMap* _tmp17_ = NULL;
			_tmp17_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (val);
				return FALSE;
			} else {
				_g_free0 (val);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp18_ = val;
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (_vala_network);
	_vala_network = _tmp19_;
	result = ret;
	_g_free0 (val);
	if (network) {
		*network = _vala_network;
	} else {
		_g_free0 (_vala_network);
	}
	return result;
}


/**
         * @channel_id: ID of channel
         * @radio: Whether the channel is a radio channel or not
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_IsRadioChannel (DVBIDBusChannelList* base, guint channel_id, gboolean* radio, GError** error) {
	DVBChannelList * self;
	gboolean _vala_radio = FALSE;
	gboolean result = FALSE;
	gboolean val = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	val = FALSE;
	ret = FALSE;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->channels;
			_tmp2_ = channel_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				gpointer _tmp6_ = NULL;
				DVBChannel* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp4_ = self->channels;
				_tmp5_ = channel_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) _tmp5_));
				_tmp7_ = (DVBChannel*) _tmp6_;
				_tmp8_ = dvb_channel_is_radio (_tmp7_);
				val = _tmp8_;
				_g_object_unref0 (_tmp7_);
				ret = TRUE;
			}
		}
		__finally42:
		{
			GeeHashMap* _tmp9_ = NULL;
			_tmp9_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp10_ = val;
	_vala_radio = _tmp10_;
	result = ret;
	if (radio) {
		*radio = _vala_radio;
	}
	return result;
}


/**
         * @channel_id: ID of channel
         * @url: URL to watch the channel
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_GetChannelURL (DVBIDBusChannelList* base, guint channel_id, gchar** url, GError** error) {
	DVBChannelList * self;
	gchar* _vala_url = NULL;
	gboolean result = FALSE;
	DVBChannel* channel = NULL;
	DVBChannel* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	channel = NULL;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->channels;
			_tmp2_ = channel_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				gpointer _tmp6_ = NULL;
				_tmp4_ = self->channels;
				_tmp5_ = channel_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) _tmp5_));
				_g_object_unref0 (channel);
				channel = (DVBChannel*) _tmp6_;
			}
		}
		__finally43:
		{
			GeeHashMap* _tmp7_ = NULL;
			_tmp7_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (channel);
				return FALSE;
			} else {
				_g_object_unref0 (channel);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp8_ = channel;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup ("");
		_g_free0 (_vala_url);
		_vala_url = _tmp9_;
		result = FALSE;
		_g_object_unref0 (channel);
		if (url) {
			*url = _vala_url;
		} else {
			_g_free0 (_vala_url);
		}
		return result;
	} else {
		DVBChannel* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp10_ = channel;
		_tmp11_ = dvb_channel_get_URL (_tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_vala_url);
		_vala_url = _tmp12_;
		result = TRUE;
		_g_object_unref0 (channel);
		if (url) {
			*url = _vala_url;
		} else {
			_g_free0 (_vala_url);
		}
		return result;
	}
	_g_object_unref0 (channel);
	if (url) {
		*url = _vala_url;
	} else {
		_g_free0 (_vala_url);
	}
}


static void _vala_DVBChannelInfo_array_free (DVBChannelInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_channel_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBChannelInfo* dvb_channel_list_real_GetChannelInfos (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	DVBChannelInfo* result = NULL;
	DVBChannelInfo* channels = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	DVBChannelInfo* _tmp3_ = NULL;
	gint channels_length1 = 0;
	gint _channels_size_ = 0;
	gint i = 0;
	DVBChannelInfo* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = self->channels;
	_tmp1_ = gee_abstract_map_get_size ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (DVBChannelInfo, _tmp2_);
	channels = _tmp3_;
	channels_length1 = _tmp2_;
	_channels_size_ = channels_length1;
	i = 0;
	{
		GeeHashMap* _tmp4_ = NULL;
		_tmp4_ = self->channels;
		g_rec_mutex_lock (&self->priv->__lock_channels);
		{
			{
				GeeIterator* _id_it = NULL;
				GeeHashMap* _tmp5_ = NULL;
				GeeSet* _tmp6_ = NULL;
				GeeSet* _tmp7_ = NULL;
				GeeSet* _tmp8_ = NULL;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _tmp10_ = NULL;
				_tmp5_ = self->channels;
				_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				_id_it = _tmp10_;
				while (TRUE) {
					GeeIterator* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					guint id = 0U;
					GeeIterator* _tmp13_ = NULL;
					gpointer _tmp14_ = NULL;
					DVBChannel* channel = NULL;
					GeeHashMap* _tmp15_ = NULL;
					guint _tmp16_ = 0U;
					gpointer _tmp17_ = NULL;
					DVBChannelInfo chan_info = {0};
					guint _tmp18_ = 0U;
					DVBChannel* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					gchar* _tmp22_ = NULL;
					DVBChannel* _tmp23_ = NULL;
					gboolean _tmp24_ = FALSE;
					DVBChannelInfo* _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					DVBChannelInfo _tmp27_ = {0};
					DVBChannelInfo _tmp28_ = {0};
					DVBChannelInfo _tmp29_ = {0};
					gint _tmp30_ = 0;
					_tmp11_ = _id_it;
					_tmp12_ = gee_iterator_next (_tmp11_);
					if (!_tmp12_) {
						break;
					}
					_tmp13_ = _id_it;
					_tmp14_ = gee_iterator_get (_tmp13_);
					id = (guint) ((guintptr) _tmp14_);
					_tmp15_ = self->channels;
					_tmp16_ = id;
					_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, (gpointer) ((guintptr) _tmp16_));
					channel = (DVBChannel*) _tmp17_;
					memset (&chan_info, 0, sizeof (DVBChannelInfo));
					_tmp18_ = id;
					chan_info.id = _tmp18_;
					_tmp19_ = channel;
					_tmp20_ = dvb_channel_get_Name (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (chan_info.name);
					chan_info.name = _tmp22_;
					_tmp23_ = channel;
					_tmp24_ = dvb_channel_is_radio (_tmp23_);
					chan_info.is_radio = _tmp24_;
					_tmp25_ = channels;
					_tmp25__length1 = channels_length1;
					_tmp26_ = i;
					_tmp27_ = chan_info;
					dvb_channel_info_copy (&_tmp27_, &_tmp28_);
					dvb_channel_info_destroy (&_tmp25_[_tmp26_]);
					_tmp25_[_tmp26_] = _tmp28_;
					_tmp29_ = _tmp25_[_tmp26_];
					_tmp30_ = i;
					i = _tmp30_ + 1;
					dvb_channel_info_destroy (&chan_info);
					_g_object_unref0 (channel);
				}
				_g_object_unref0 (_id_it);
			}
		}
		__finally44:
		{
			GeeHashMap* _tmp31_ = NULL;
			_tmp31_ = self->channels;
			g_rec_mutex_unlock (&self->priv->__lock_channels);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				channels = (_vala_DVBChannelInfo_array_free (channels, channels_length1), NULL);
				return NULL;
			} else {
				channels = (_vala_DVBChannelInfo_array_free (channels, channels_length1), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp32_ = channels;
	_tmp32__length1 = channels_length1;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	return result;
}


/**
         * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_GetChannelsOfGroup (DVBIDBusChannelList* base, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error) {
	DVBChannelList * self;
	guint* _vala_channel_ids = NULL;
	int _vala_channel_ids_length1 = 0;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* config = NULL;
	DVBFactory* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_ = NULL;
	GeeList* channels = NULL;
	GeeList* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	guint* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config = _tmp3_;
	{
		GeeList* _tmp4_ = NULL;
		DVBdatabaseConfigStore* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		gint _tmp7_ = 0;
		GeeList* _tmp8_ = NULL;
		GeeList* _tmp9_ = NULL;
		_tmp5_ = config;
		_tmp6_ = self->priv->_GroupId;
		_tmp7_ = channel_group_id;
		_tmp8_ = dvb_database_config_store_get_channels_of_group (_tmp5_, _tmp6_, _tmp7_, &_inner_error_);
		_tmp4_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch45_dvb_database_sql_error;
			}
			_g_object_unref0 (channels);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp9_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (channels);
		channels = _tmp9_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally45;
	__catch45_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		guint* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = dvb_channel_list_log;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		dvb_logging_logger_error (_tmp10_, "ChannelList.vala:283: %s", _tmp12_);
		_tmp13_ = g_new0 (guint, 0);
		_vala_channel_ids = (g_free (_vala_channel_ids), NULL);
		_vala_channel_ids = _tmp13_;
		_vala_channel_ids_length1 = 0;
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (channels);
		_g_object_unref0 (config);
		if (channel_ids) {
			*channel_ids = _vala_channel_ids;
		} else {
			_vala_channel_ids = (g_free (_vala_channel_ids), NULL);
		}
		if (channel_ids_length1) {
			*channel_ids_length1 = _vala_channel_ids_length1;
		}
		return result;
	}
	__finally45:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (channels);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (channels);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp14_ = channels;
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_new0 (guint, _tmp16_);
	_vala_channel_ids = (g_free (_vala_channel_ids), NULL);
	_vala_channel_ids = _tmp17_;
	_vala_channel_ids_length1 = _tmp16_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gint _tmp20_ = 0;
				guint* _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				guint* _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				GeeList* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gpointer _tmp26_ = NULL;
				guint _tmp27_ = 0U;
				if (!_tmp18_) {
					gint _tmp19_ = 0;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = i;
				_tmp21_ = _vala_channel_ids;
				_tmp21__length1 = _vala_channel_ids_length1;
				if (!(_tmp20_ < _tmp21__length1)) {
					break;
				}
				_tmp22_ = _vala_channel_ids;
				_tmp22__length1 = _vala_channel_ids_length1;
				_tmp23_ = i;
				_tmp24_ = channels;
				_tmp25_ = i;
				_tmp26_ = gee_list_get (_tmp24_, _tmp25_);
				_tmp22_[_tmp23_] = (guint) ((guintptr) _tmp26_);
				_tmp27_ = _tmp22_[_tmp23_];
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (channels);
	_g_object_unref0 (config);
	if (channel_ids) {
		*channel_ids = _vala_channel_ids;
	} else {
		_vala_channel_ids = (g_free (_vala_channel_ids), NULL);
	}
	if (channel_ids_length1) {
		*channel_ids_length1 = _vala_channel_ids_length1;
	}
	return result;
}


/**
         * @channel_id: ID of channel
         * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_AddChannelToGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* config = NULL;
	DVBFactory* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_ = NULL;
	DVBChannel* chan = NULL;
	guint _tmp4_ = 0U;
	DVBChannel* _tmp5_ = NULL;
	DVBChannel* _tmp6_ = NULL;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config = _tmp3_;
	_tmp4_ = channel_id;
	_tmp5_ = dvb_channel_list_get_channel (self, _tmp4_);
	chan = _tmp5_;
	_tmp6_ = chan;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_g_object_unref0 (chan);
		_g_object_unref0 (config);
		return result;
	}
	{
		gboolean _tmp7_ = FALSE;
		DVBdatabaseConfigStore* _tmp8_ = NULL;
		DVBChannel* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		_tmp8_ = config;
		_tmp9_ = chan;
		_tmp10_ = channel_group_id;
		_tmp11_ = dvb_database_config_store_add_channel_to_group (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
		_tmp7_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch46_dvb_database_sql_error;
			}
			_g_object_unref0 (chan);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = _tmp7_;
	}
	goto __finally46;
	__catch46_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = dvb_channel_list_log;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		dvb_logging_logger_error (_tmp12_, "ChannelList.vala:313: %s", _tmp14_);
		ret = FALSE;
		_g_error_free0 (e);
	}
	__finally46:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (chan);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (chan);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (chan);
	_g_object_unref0 (config);
	return result;
}


/**
         * @channel_id: ID of channel
         * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_RemoveChannelFromGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* config = NULL;
	DVBFactory* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_ = NULL;
	DVBChannel* chan = NULL;
	guint _tmp4_ = 0U;
	DVBChannel* _tmp5_ = NULL;
	DVBChannel* _tmp6_ = NULL;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config = _tmp3_;
	_tmp4_ = channel_id;
	_tmp5_ = dvb_channel_list_get_channel (self, _tmp4_);
	chan = _tmp5_;
	_tmp6_ = chan;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_g_object_unref0 (chan);
		_g_object_unref0 (config);
		return result;
	}
	{
		gboolean _tmp7_ = FALSE;
		DVBdatabaseConfigStore* _tmp8_ = NULL;
		DVBChannel* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		_tmp8_ = config;
		_tmp9_ = chan;
		_tmp10_ = channel_group_id;
		_tmp11_ = dvb_database_config_store_remove_channel_from_group (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
		_tmp7_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch47_dvb_database_sql_error;
			}
			_g_object_unref0 (chan);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = _tmp7_;
	}
	goto __finally47;
	__catch47_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = dvb_channel_list_log;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		dvb_logging_logger_error (_tmp12_, "ChannelList.vala:336: %s", _tmp14_);
		ret = FALSE;
		_g_error_free0 (e);
	}
	__finally47:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (chan);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (chan);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (chan);
	_g_object_unref0 (config);
	return result;
}


GFile* dvb_channel_list_get_channels_file (DVBChannelList* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_channels_file;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_channel_list_set_channels_file (DVBChannelList* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_channels_file);
	self->priv->_channels_file = _tmp1_;
	g_object_notify ((GObject *) self, "channels-file");
}


guint dvb_channel_list_get_GroupId (DVBChannelList* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_GroupId;
	result = _tmp0_;
	return result;
}


void dvb_channel_list_set_GroupId (DVBChannelList* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_GroupId = _tmp0_;
	g_object_notify ((GObject *) self, "GroupId");
}


gint dvb_channel_list_get_size (DVBChannelList* self) {
	gint result;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->channels;
	_tmp1_ = gee_abstract_map_get_size ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GType dvb_channel_list_real_get_element_type (GeeTraversable* base) {
	GType result;
	DVBChannelList* self;
	self = (DVBChannelList*) base;
	result = DVB_TYPE_CHANNEL;
	return result;
}


static GObject * dvb_channel_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBChannelList * self;
	GeeHashMap* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_channel_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_CHANNEL_LIST, DVBChannelList);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->channels);
	self->channels = _tmp0_;
	return obj;
}


static void dvb_channel_list_class_init (DVBChannelListClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_channel_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelListPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_channel_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_channel_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_channel_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_CHANNELS_FILE, g_param_spec_object ("channels-file", "channels-file", "channels-file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_GROUP_ID, g_param_spec_uint ("GroupId", "GroupId", "GroupId", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_ELEMENT_TYPE, g_param_spec_gtype ("element-type", "element-type", "element-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_channel_list_log = _tmp1_;
}


static GType dvb_channel_list_gee_traversable_get_g_type (DVBChannelList* self) {
	return DVB_TYPE_CHANNEL;
}


static GBoxedCopyFunc dvb_channel_list_gee_traversable_get_g_dup_func (DVBChannelList* self) {
	return g_object_ref;
}


static GDestroyNotify dvb_channel_list_gee_traversable_get_g_destroy_func (DVBChannelList* self) {
	return g_object_unref;
}


static void dvb_channel_list_gee_traversable_interface_init (GeeTraversableIface * iface) {
	dvb_channel_list_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) dvb_channel_list_real_foreach;
	iface->get_g_type = (GType(*)(GeeTraversable*)) dvb_channel_list_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) dvb_channel_list_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) dvb_channel_list_gee_traversable_get_g_destroy_func;
	iface->get_element_type = dvb_channel_list_real_get_element_type;
}


static GType dvb_channel_list_gee_iterable_get_g_type (DVBChannelList* self) {
	return DVB_TYPE_CHANNEL;
}


static GBoxedCopyFunc dvb_channel_list_gee_iterable_get_g_dup_func (DVBChannelList* self) {
	return g_object_ref;
}


static GDestroyNotify dvb_channel_list_gee_iterable_get_g_destroy_func (DVBChannelList* self) {
	return g_object_unref;
}


static void dvb_channel_list_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_channel_list_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) dvb_channel_list_real_iterator;
	iface->get_g_type = (GType(*)(GeeIterable*)) dvb_channel_list_gee_iterable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeIterable*)) dvb_channel_list_gee_iterable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeIterable*)) dvb_channel_list_gee_iterable_get_g_destroy_func;
}


static void dvb_channel_list_dvb_id_bus_channel_list_interface_init (DVBIDBusChannelListIface * iface) {
	dvb_channel_list_dvb_id_bus_channel_list_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetChannels = (guint* (*)(DVBIDBusChannelList*, int*, GError**)) dvb_channel_list_real_GetChannels;
	iface->GetRadioChannels = (guint* (*)(DVBIDBusChannelList*, int*, GError**)) dvb_channel_list_real_GetRadioChannels;
	iface->GetTVChannels = (guint* (*)(DVBIDBusChannelList*, int*, GError**)) dvb_channel_list_real_GetTVChannels;
	iface->GetChannelName = (gboolean (*)(DVBIDBusChannelList*, guint, gchar**, GError**)) dvb_channel_list_real_GetChannelName;
	iface->GetChannelNetwork = (gboolean (*)(DVBIDBusChannelList*, guint, gchar**, GError**)) dvb_channel_list_real_GetChannelNetwork;
	iface->IsRadioChannel = (gboolean (*)(DVBIDBusChannelList*, guint, gboolean*, GError**)) dvb_channel_list_real_IsRadioChannel;
	iface->GetChannelURL = (gboolean (*)(DVBIDBusChannelList*, guint, gchar**, GError**)) dvb_channel_list_real_GetChannelURL;
	iface->GetChannelInfos = (DVBChannelInfo* (*)(DVBIDBusChannelList*, int*, GError**)) dvb_channel_list_real_GetChannelInfos;
	iface->GetChannelsOfGroup = (gboolean (*)(DVBIDBusChannelList*, gint, guint**, int*, GError**)) dvb_channel_list_real_GetChannelsOfGroup;
	iface->AddChannelToGroup = (gboolean (*)(DVBIDBusChannelList*, guint, gint, GError**)) dvb_channel_list_real_AddChannelToGroup;
	iface->RemoveChannelFromGroup = (gboolean (*)(DVBIDBusChannelList*, guint, gint, GError**)) dvb_channel_list_real_RemoveChannelFromGroup;
}


static void dvb_channel_list_instance_init (DVBChannelList * self) {
	self->priv = DVB_CHANNEL_LIST_GET_PRIVATE (self);
	g_rec_mutex_init (&self->priv->__lock_channels);
}


static void dvb_channel_list_finalize (GObject* obj) {
	DVBChannelList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_CHANNEL_LIST, DVBChannelList);
	_g_object_unref0 (self->priv->_channels_file);
	g_rec_mutex_clear (&self->priv->__lock_channels);
	_g_object_unref0 (self->channels);
	G_OBJECT_CLASS (dvb_channel_list_parent_class)->finalize (obj);
}


GType dvb_channel_list_get_type (void) {
	static volatile gsize dvb_channel_list_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelList), 0, (GInstanceInitFunc) dvb_channel_list_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) dvb_channel_list_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_channel_list_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo dvb_id_bus_channel_list_info = { (GInterfaceInitFunc) dvb_channel_list_dvb_id_bus_channel_list_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_channel_list_type_id;
		dvb_channel_list_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelList", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_channel_list_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (dvb_channel_list_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (dvb_channel_list_type_id, DVB_TYPE_ID_BUS_CHANNEL_LIST, &dvb_id_bus_channel_list_info);
		g_once_init_leave (&dvb_channel_list_type_id__volatile, dvb_channel_list_type_id);
	}
	return dvb_channel_list_type_id__volatile;
}


static void _vala_dvb_channel_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_CHANNEL_LIST, DVBChannelList);
	switch (property_id) {
		case DVB_CHANNEL_LIST_CHANNELS_FILE:
		g_value_set_object (value, dvb_channel_list_get_channels_file (self));
		break;
		case DVB_CHANNEL_LIST_GROUP_ID:
		g_value_set_uint (value, dvb_channel_list_get_GroupId (self));
		break;
		case DVB_CHANNEL_LIST_SIZE:
		g_value_set_int (value, dvb_channel_list_get_size (self));
		break;
		case DVB_CHANNEL_LIST_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_traversable_get_element_type ((GeeTraversable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_channel_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_CHANNEL_LIST, DVBChannelList);
	switch (property_id) {
		case DVB_CHANNEL_LIST_CHANNELS_FILE:
		dvb_channel_list_set_channels_file (self, g_value_get_object (value));
		break;
		case DVB_CHANNEL_LIST_GROUP_ID:
		dvb_channel_list_set_GroupId (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



