using System;
using Gtk;
using System.Reflection;

namespace gnomeguitar_cs
{
	
	public class ChordCreator : Window 
	{
		//used for debuggin2 can be got rid of
		int i;
		ChordRendererUI renderer;
		ChordGroup allChords;
		AboutDialog about = null;
		VBox contents;
		ChordRendererPrefs prefs;
		bool rightHanded;
		
		ChordTypesOM typesOM;
		TuningsOM tuningsOM;
		ShapesOM shapesOM;
		VoiceingsOM  voiceingsOM;
		PrioritiesOM prioritiesOM;
		
		ChordList chordList;
		WrittensList writtensList;
		
		ConstructionView constructionView;		
		InfoView infoView;
		
		Container stringEditorsContainer;
		string dbFile;

		ChordType currentType;
		Tuning currentTuning = new Tuning("");
		
		HomogeneousChordGroup typeChords;
		HomogeneousChordGroup tuningChords;
		HomogeneousChordGroup shapeChords;
		
		FileChooserDialog openFileSelector = null;
		FileChooserDialog saveAsFileSelector = null;
		
		public ChordCreator () : base("Chord-Creator")
		{
			prefs = new ChordRendererPrefs();
			prefs.PreferencesChanged += preferences_changed_cb;
			SetDefaultSize(300,450);	
			contents = new VBox (false, 0);
			Add (contents);
			create_menus_toolBar_and_statusBar();
			Icon = new Gdk.Pixbuf(Assembly.GetExecutingAssembly().GetManifestResourceStream("chord-creator-logo.png"));	
			build_widget();
//			connect_signals();
		}
		
		public ChordCreator(string dbFile): this()
		{
	
			if(set_allChords(dbFile)){
				set_dbFile(dbFile);
			}
		}
		
		public ChordCreator(ChordDb db): this()
		{
	
			if(set_allChords(db)){
				set_dbFile(null);
			}
		}
/******************************************************************
****************************** PRIVATE STUFF **********************
 *****************************************************************/
		
		void create_menus_toolBar_and_statusBar()
		{
			const string uiInfo =
				"<ui>" +
					"  <menubar name='MenuBar'>" +
					"    <menu action='FileMenu'>" +
					"      <menuitem action='New'/>" +
					"      <menuitem action='Open'/>" +
					"      <menuitem action='Save'/>" +
					"      <menuitem action='SaveAs'/>" +
					"      <menuitem action='Close'/>" +
					"      <separator/>" +
					"      <menuitem action='Quit'/>" +
					"    </menu>" +
					"    <menu action='PreferencesMenu'>" +
					"      <menu action='StringOrder'>" +
					"        <menuitem action='LowToHigh'/>" +
					"        <menuitem action='HighToLow'/>" +
					"      </menu>" +
					"      <menu action='ChordRotation'>" +
					"        <menuitem action='Horizontal'/>" +
					"        <menuitem action='Vertical'/>" +
					"      </menu>" +
					"      <separator action='Sep1'/>" +
					"      <menuitem action='RightHanded'/>" +
					"    </menu>" +
					"    <menu action='HelpMenu'>" +
					"      <menuitem action='Help'/>" +
					"      <separator/>" +
					"      <menuitem action='About'/>" +
					"    </menu>" +
					"  </menubar>" +
					"  <toolbar  name='ToolBar'>" +
					"    <toolitem name='new' action='New'/>" +
					"    <toolitem name='quit' action='Quit'/>" +
					"    <separator action='Sep1'/>" +
					"    <toolitem name='help' action='Help'/>" +
					"  </toolbar>" +
					"</ui>";	
			
			ActionEntry[] actions = new ActionEntry[]
			{
				new ActionEntry ("FileMenu", null, "_File", null, null, null),
				new ActionEntry ("PreferencesMenu", null, "_Preferences", null, null, null),
				new ActionEntry ("StringOrder", null, "_String Order", null, null, null),
				new ActionEntry ("ChordRotation", null, "_Chord Rotation", null, null, null),
				new ActionEntry ("HelpMenu", null, "_Help", null, null, null),
				new ActionEntry ("New", Stock.New, "_New", "<control>N", "Open a new Gnome-Scale window", newMI_cb),
				new ActionEntry ("Open", Stock.Open, "_Open", "<control>O", "Open a new Gnome-Chord database", openMI_cb),
				new ActionEntry ("Save", Stock.Save, "_Save", "<control>S", "Save the changes to the Gnome-Scale database", saveMI_cb),
				new ActionEntry ("SaveAs", Stock.SaveAs, "Save _As", "<control>V", "Save the current Gnome-Chord database as a new file", saveAsMI_cb),
				new ActionEntry ("Close", Stock.Close, "_Close", "<control>C", "Close the current Gnome-Scale window", closeMI_cb),
				new ActionEntry ("Quit", Stock.Quit, "_Quit", "<control>Q", "Quit all open Gnome-Scale windows", quitMI_cb),
				new ActionEntry ("About", Stock.About, "_About", "<control>A", "About", aboutMI_cb),				
				new ActionEntry ("Help", Stock.Help, "_Help", "<control>H", "Help", helpMI_cb)
			};
			rightHanded = prefs.RightHanded;						
			ToggleActionEntry[] toggleActions = new ToggleActionEntry[]
			{
				new ToggleActionEntry ("RightHanded", null, "_Right Handed?", "<control>R", "Display the guitar for right or left handed players", rightHandedMI_cb, rightHanded)
			};

			RadioActionEntry[] stringOrderActions = new RadioActionEntry[]
			{
				new RadioActionEntry ("HighToLow", null, "_High To Low", "<control>H", "Order strings as if looking down at your guitar", (int)StringOrder.HighToLow),
				new RadioActionEntry ("LowToHigh", null, "_Low To High", "<control>L", "Order strings as if looking at someone else guitar", (int)StringOrder.LowToHigh),
			};
			RadioActionEntry[] chordRotationActions = new RadioActionEntry[]
			{
				new RadioActionEntry ("Horizontal", null, "_Horizontal", "<control>H", "Display the chord horizontaly", (int)ChordRotation.Horizontal),
				new RadioActionEntry ("Vertical", null, "_Vertical", "<control>V", "Display the chord vertically", (int)ChordRotation.Vertical),
			};
			ActionGroup group = new ActionGroup ("AppWindowActions");
			group.Add (actions);
			group.Add (toggleActions);
			StringOrder stringOrder = prefs.HighStringFirst?StringOrder.HighToLow:StringOrder.LowToHigh;
			group.Add (stringOrderActions, (int)stringOrder, stringOrderMI_cb);
			ChordRotation chordRotation = prefs.ChordRotation;
			group.Add (chordRotationActions, (int)chordRotation, chordRotationMI_cb);
			UIManager uim = new UIManager ();
			uim.InsertActionGroup (group, 0);
			uim.AddUiFromString (uiInfo);
			AddAccelGroup (uim.AccelGroup);
			
			contents.PackStart (uim.GetWidget ("/MenuBar"), false, false, 0);
			contents.PackEnd(new Statusbar(), false, false, 0);
		}
		
		void build_widget()
		{
			Notebook notebook = new Notebook();
			notebook.BorderWidth = 5;
			Widget chordFamilyParams = create_chordFamilyParams();
			Widget voiceingsStrings = create_voiceingsStrings();
			notebook.AppendPage(chordFamilyParams, new Label("Chord Family Params"));
			notebook.AppendPage(voiceingsStrings, new Label("Voiceings/Strings"));

			contents.PackEnd(notebook);
		}

		Widget create_chordFamilyParams()
		{
			Box vBox;
			Widget typesTunings;
			Widget writtens;
			Widget construction;

			vBox = new VBox(false, 5);
			vBox.BorderWidth = 5;
			typesTunings = create_typesTunings();
			vBox.PackStart(typesTunings, false, false, 0);
	
			writtens = create_writtens();
			vBox.PackStart(writtens, false, false, 0);
	
			construction = create_construction();
			vBox.PackStart(construction, false, false, 0);

			return vBox;
		}

		Widget create_typesTunings()
		{
			Frame frame;
			Table table;
			
			Button newTypeButton;
			Button newTuningButton;
			Label typesLabel;
			Label tuningsLabel;
	
			frame = new Frame("Types/Tunings");
			table = new Table(2,3, false);

			typesLabel = new Label("Types:");
			typesOM = new ChordTypesOM();
			typesOM.Changed += typesOM_cb;

			newTypeButton = new Button("New Type");
			newTypeButton.Clicked += new EventHandler(newTypeButton_cb);
			
			table.Attach(typesLabel, 
			             0,1,0,1,
			             AttachOptions.Fill, 0,
			             5,5);
			table.Attach(typesOM,
			             1,2,0,1,
			             AttachOptions.Fill | AttachOptions.Expand, AttachOptions.Shrink,
			             5,5);
			table.Attach(newTypeButton,
			             2,3,0,1,
			             AttachOptions.Fill, 0,
			             5,5);

			tuningsLabel = new Label("Tunings:");
			tuningsOM = new TuningsOM();
			tuningsOM.Changed += new EventHandler(tuningsOM_cb);

			newTuningButton = new Button("New Tuning");
			newTuningButton.Clicked += new EventHandler(newTuningButton_cb);

			table.Attach(tuningsLabel,
			             0,1,1,2,
			             AttachOptions.Fill, 0,
			             5,5);
			table.Attach(tuningsOM,
			             1,2,1,2,
			             AttachOptions.Fill | AttachOptions.Expand, 0,
			             5,5);
			table.Attach(newTuningButton,
			             2,3,1,2,
			             AttachOptions.Fill, 0,
			             5,5);
	
			frame.Add(table);
		
			return frame;	
		}

		Widget create_writtens()
		{
			Frame frame;
	
			frame = new Frame("Writtens");
			writtensList = new WrittensList();
			writtensList.onWrittenAdded += writtensList_added_cb;
			writtensList.onWrittenEdited += writtensList_edited_cb;
			writtensList.onWrittenRemoved += writtensList_removed_cb;
			frame.Add(writtensList);
			
			return frame;
		}

		Widget create_construction()
		{
			Frame frame;
			Frame padding;

			frame = new Frame("Construction");
			padding = new Frame();
			padding.ShadowType = ShadowType.None;
			padding.BorderWidth = 5;
			constructionView = new ConstructionView();
	
			padding.Add(constructionView);
			frame.Add(padding);
			constructionView.onChanged += constructionView_cb;

			return frame;
			}
				
		Widget create_voiceingsStrings()
		{
			VBox vBox;
			HBox hBox;
			Widget chords;
			Widget voiceingParams;
			Widget stringParams;
			Widget chordPreview;

			vBox = new VBox(false, 10);
			hBox = new HBox(false, 10);
			hBox.BorderWidth = 5;

			chords = create_chords();
			voiceingParams = create_voiceingParams();
			stringParams = create_stringParams();
			chordPreview = create_chordPreview();

			vBox.PackStart (chords, true, true, 0);
			vBox.PackStart (voiceingParams, false, false, 0);
	
			hBox.PackStart (vBox, true, true, 0);
			hBox.PackStart (stringParams, true, true, 0);
			hBox.PackStart (chordPreview, true, true, 0);

			return hBox;
		}

		Widget create_chords()
		{
			Frame frame;
			VBox vBox;
			ScrolledWindow scrolledWindow;
			Button deleteButton;
			
			ObjGroup shapes;

			frame = new Frame("Chords");
			vBox = new VBox(false, 10);
			vBox.BorderWidth = 5;
	
			shapes = new ObjGroup();
			foreach (ChordShapeValue csv in ChordShape.chordShapeValues){
				if(csv != ChordShapeValue.NO_SHAPE){
					shapes.Add(new ChordShape (csv));
				}
			}
			
			shapesOM = new ShapesOM(shapes);
			shapesOM.Changed += shapesOM_cb;

			chordList = new ChordList();
			chordList.onSelectionChanged += chordList_selection_changed;
			
			scrolledWindow = new ScrolledWindow();
			scrolledWindow.ShadowType = ShadowType.In;
			scrolledWindow.Add(chordList);
	
			deleteButton = new Button("Delete Chord(s)");
			deleteButton.Clicked += new EventHandler(deleteChordButton_cb);

			vBox.PackStart(shapesOM, false, false, 0);
			vBox.PackStart(scrolledWindow, true, true, 0);
			vBox.PackStart(deleteButton, false, false, 0);
	
			frame.Add(vBox);

			return frame;
		}

		Widget create_voiceingParams()
		{
			Frame frame;
			VBox vBox;

			HBox voiceingHBox;
			Label voiceingLabel;
			
			Button newVoiceingButton;
	
			HBox priorityHBox;
			Label priorityLabel;
			
	
			Box infoHBox;
			Label infoLabel;
			
			ScrolledWindow scrolledWindow;

			frame = new Frame("Voiceings");
			vBox = new VBox(false, 5);
	
			voiceingHBox = new HBox(false, 5);
			voiceingLabel = new Label("Voiceing:");
			voiceingsOM = new VoiceingsOM();
			voiceingsOM.Changed += new EventHandler(voiceingsOM_cb);

			newVoiceingButton = new Button("New Voiceing");
			newVoiceingButton.Clicked += new EventHandler(newVoiceingButton_cb);

			voiceingHBox.PackStart(voiceingLabel, false, false, 5);
			voiceingHBox.PackStart(voiceingsOM, true, true, 5);
			voiceingHBox.PackStart(newVoiceingButton, true, true, 5);

			priorityHBox = new HBox(false, 5);	
			priorityLabel = new Label("Priority:");
			prioritiesOM = new PrioritiesOM();
			prioritiesOM.Changed += new EventHandler (prioritesOM_cb);
	
			priorityHBox.PackStart(priorityLabel, false, false, 5);
			priorityHBox.PackStart(prioritiesOM, true, true, 5);

			infoHBox = new HBox(false, 5);
			infoLabel = new Label("Info:");
			infoView = new InfoView();
			infoView.onChanged += infoEntry_cb;
			scrolledWindow = new ScrolledWindow();
			scrolledWindow.ShadowType = ShadowType.In;
			scrolledWindow.Add(infoView);
			infoHBox.PackStart(infoLabel, false, false, 5);
			infoHBox.PackStart(scrolledWindow, true, true, 5);

			vBox.PackStart(voiceingHBox, false, false, 5);
			vBox.PackStart(priorityHBox, false, false, 5);
			vBox.PackStart(infoHBox, false, false, 5);

			frame.Add(vBox);

			return frame;
		}

		Widget create_stringParams()
		{
			stringEditorsContainer = new Frame("Strings");	
			return stringEditorsContainer;
		}

		Widget create_chordPreview()
		{
			Frame frame;
			Frame padding;

			frame = new Frame("Chord Preview");
			padding = new Frame();
			padding.BorderWidth = 5;
			padding.ShadowType = ShadowType.None;
			renderer = new ChordCairoRenderer(prefs);
	
			padding.Add(renderer.get_widget());
			frame.Add(padding);

			return frame;
		}

		void set_dbFile(string dbFile)
		{
			this.dbFile = dbFile;
		}

		public string get_dbFile()
		{
			return dbFile;
		}

// void 
// set_renderer(ChordCreator self,  
// 	     GChordRenderer renderer) 
// { 
// 	 
// 	 
//
// 	g_return_if_fail(renderer != null); 
// 	g_return_if_fail(IS_GCHORD_RENDERER(renderer)); 
//
// 	if (self->renderer != null){ 
// 		g_object_unref(G_OBJECT(self->renderer)); 
// 	} 
//
// 	g_object_ref(G_OBJECT(renderer)); 
// 	self->renderer = renderer; 
// } 

		bool set_allChords(string dbFile)
		{
			XmlChordParser parser;
			FileReader reader;

			reader = new FileReader(dbFile);
			if (reader.check()){
				parser = new XmlChordParser(reader);
				allChords = parser.parse();
				allChords.onContentsChanged += allChords_changed_cb;
				allChords_changed_cb(allChords, new EventArgs());
				return true;
			} else {
				return false;
			}
		}
		
		bool set_allChords(ChordDb db)
		{
			XmlChordParser parser;
			FileReader reader;

			reader = new FileReader(db);
			if (reader.check()){
				parser = new XmlChordParser(reader);
				allChords = parser.parse();
				allChords.onContentsChanged += allChords_changed_cb;
				allChords_changed_cb(allChords, new EventArgs());
				return true;
			} else {
				return false;
			}
		}
		
		void set_typesOM()
		{
			ObjGroup chordTypes;

			chordTypes = get_chordTypes();

			//	g_signal_handler_block(self->typesOM, self->typesSignalHandler);
			typesOM.set_chordTypes(chordTypes);
			//	g_signal_handler_unblock(self->typesOM, self->typesSignalHandler);

			typesOM.set_chordType(currentType);
		}
 
		ObjGroup get_chordTypes()
		{
			return allChords.get_chordTypes();
		}

		void set_typeChords()
		{		
			ChordGroup tempChords;
			ChordType selectedType;
	
			selectedType = get_selected_type();
			tempChords = allChords.create_type_sub_group(selectedType);
			//System.Console.WriteLine("ChordCreator.set_typeChords: tempChords = {0}", tempChords.to_xml());
			typeChords = new HomogeneousChordGroup(tempChords);
			//System.Console.WriteLine("ChordCreator.set_typeChords: typeChords = {0}", typeChords.to_xml());
			typeChords.onNotesChanged += typeChords_notes_changed_cb;
			typeChords.onWrittensChanged += typeChords_writtens_changed_cb;
		}

		ChordType get_selected_type()
		{
			ChordType chordType;

			chordType = typesOM.get_chordType();
		
			return chordType;
		}
	
		void set_tuningChords()
		{
			Tuning tuning;
			
			tuning = get_selected_tuning();

			tuningChords = (HomogeneousChordGroup)typeChords.create_tuning_sub_group(tuning);	
		}

		Tuning get_selected_tuning()
		{
			Tuning tuning;	

			tuning = tuningsOM.get_tuning();
       
			return tuning;
		}

		void set_writtensList()
		{
			GenericWrittenGroup writtens;

			writtens = get_writtens();
			writtensList.set_writtens(writtens);
		}

		GenericWrittenGroup get_writtens()
		{
			GenericWrittenGroup writtens;

			writtens = tuningChords.get_genericWrittens();

			return writtens;
		}

		void set_construction()
		{
			Construction construction;
	
			construction = get_construction(); 
			constructionView.set_construction(construction);
		}

		Construction get_construction()
		{
			Construction construction;
			
			construction = tuningChords.get_construction();
			
			return construction;
		}
		
		void set_tuningsOM()
		{
			TuningGroup tunings;

			tunings = get_tunings();

			//	g_signal_handler_block(G_OBJECT(self->tuningsOM), self->tuningsSignalHandler);
			tuningsOM.set_tunings(tunings);
			//	g_signal_handler_unblock(G_OBJECT(self->tuningsOM), self->tuningsSignalHandler);
	
			tuningsOM.set_tuning(currentTuning);
		}

		TuningGroup get_tunings()
		{
			TuningGroup tunings;
			System.Console.Write ("in get_tunings()");
			if (typeChords == null){
			//	System.Console.WriteLine ("ChordCreator.get_tunings: typeChords == null");
				tunings = new TuningGroup();
			} else {
			//	System.Console.WriteLine ("ChordCreator.get_tunings: typeChords != null");
				tunings = typeChords.get_tunings();
			//	System.Console.WriteLine("ChordCreator.get_tunings: {0}", typeChords.to_xml());
			}

			return tunings;
		}

		void set_shapeChords()
		{
			ChordShape shape;
	
			shape = get_selected_shape();
			shapeChords = (HomogeneousChordGroup)tuningChords.create_shape_sub_group(shape);
		}

		ChordShape get_selected_shape()
		{
			ChordShape shape;

			shape = shapesOM.get_shape();
		
			return shape;
		}

		void set_chordList()
		{
			i++;
			System.Console.WriteLine("ChordCreator.set_chordList: set_chordList called {0} times", i);
			chordList.add_chordTree(shapeChords, new TreeLayout(new ChordTreeNodeType(ChordTreeNodeTypeValue.TUNING),
			                                  new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD_SHAPE),
			                                  new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD_TYPE),
			                                  new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD_ROOT),
			                                  new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD)));
			
			chordList.ExpandToPath(new TreePath(new int[] {0,0,0}));
			//treePath = new TreePath("0");
			//chordList.ExpandRow(treePath, false);

			//	chordList_selection_changed(null, self);
		}
 
		void set_voiceing_params ()
		{
			set_voiceingsOM(0);
		}

		void set_voiceingsOM(int selected)
		{
			int noVoiceings;

			noVoiceings = get_noVoiceings();

//FIXME if we do this than the signal never gets emited if the number stays the same
//	g_signal_handler_block(G_OBJECT(self->voiceingsOM),
//			       self->voiceingsSignalHandler);
			voiceingsOM.set_voiceings(get_voiceings());
//	g_signal_handler_unblock(G_OBJECT(self->voiceingsOM),
//				 self->voiceingsSignalHandler);

			if (selected == -1){
				selected = noVoiceings -1;
			}
			voiceingsOM.Active = selected;
		}
 
		int get_noVoiceings ()
		{
			VoiceingGroup voiceings;
			int noVoiceings;

			voiceings = get_voiceings();
			noVoiceings = voiceings.get_no();
	
			return noVoiceings;
		}

		VoiceingGroup get_voiceings ()
		{
			Chord currentChord;
			VoiceingGroup voiceings;
	
			currentChord = get_currentChord();
			if (currentChord == null){
				voiceings = new VoiceingGroup();
			} else {
				voiceings = currentChord.get_voiceings();
			}

			return voiceings;
		}

		Chord get_currentChord()
		{
			ChordGroup selectedChords;
			Chord chord;

			selectedChords = chordList.get_selected_chords();
			chord = selectedChords.nth(0) as Chord;
			
			return chord;
		}

		void set_prioritiesOM ()
		{
			Priority priority;

			priority = get_priority();
			prioritiesOM.set_priority(priority);
		}

		Priority get_priority()
		{
			Voiceing currentVoiceing;
			Priority priority;
			
			currentVoiceing = get_currentVoiceing();
	
			if (currentVoiceing == null){
				priority = new Priority(0);
			} else {
				priority = currentVoiceing.get_priority();
			}
			System.Console.WriteLine("ChordCreator.get_priority: Priority = {0}", priority.to_text());
			return priority;
		}

		Voiceing get_currentVoiceing()
		{
			Voiceing currentVoiceing;
			Chord currentChord; 
			int selectedNo;

			currentChord = get_currentChord();
			if(currentChord == null){
				return null;
			}
			selectedNo = get_current_voiceingNo();
			currentVoiceing = currentChord.get_voiceing(selectedNo);
	
			return currentVoiceing;
		}
	
		void set_voiceingInfo ()
		{
			string info;

			info = get_voiceingInfo();
			infoView.set_info(info);
		}

		string get_voiceingInfo()
		{
			Voiceing currentVoiceing;
			string info;

			currentVoiceing = get_currentVoiceing();
			if (currentVoiceing == null){
				info = "";
			} else {
				info = currentVoiceing.get_info();
			}

			return info;
		}

		void set_string_params ()
		{
			Voiceing voiceing;
			VBox stringEditorsBox;
			GuitarStringEditor stringEditor;
			NoteGroup possibleNotes;
			Chord currentChord;
			short stringNo;

			remove_string_params();

			currentChord = get_currentChord();
			if(currentChord == null){
				return;
			}
			possibleNotes = currentChord.get_possibleNotes();

			stringEditorsBox = new VBox(true, 5);
			stringEditorsBox.BorderWidth =  5;

			voiceing = get_currentVoiceing();
			stringNo = 0;
			foreach (GuitarString guitarString in voiceing.get_strings()){
				stringEditor = new GuitarStringEditor(guitarString,
				                                      possibleNotes,
				                                      stringNo);
				stringNo++;
				stringEditor.onFingerChanged += stringEditor_finger_changed_cb;
				stringEditor.onFrettedChanged += stringEditor_fretted_changed_cb;
				stringEditor.onIs12PlusChanged += stringEditor_is12plus_changed_cb;
				stringEditorsBox.PackStart(stringEditor, false, false, 0);
			}
	
			stringEditorsBox.ShowAll();
			stringEditorsContainer.Add(stringEditorsBox);
		}

		void remove_string_params()
		{
			if (stringEditorsContainer.Children[0] != null){
				stringEditorsContainer.Remove(stringEditorsContainer.Children[0]);
			}
		}

		void render()
		{
			ChordGroup toRender;
			Chord voiceingChord;

			if (!is_chord_selected()){
				renderer.render_default();
				System.Console.WriteLine("ChordCreator.render: no chord selected");
				return;
			}

			voiceingChord = create_single_voiceing_chord();
	
			toRender = new ChordGroup();
			toRender.add(voiceingChord);
			renderer.render(toRender);
		}

		bool is_chord_selected()
		{
			return chordList.is_chord_selected();
		}

		Chord create_single_voiceing_chord()
		{
			Voiceing currentVoiceing;
			string name;
			ChordType type;
			Note root;
			ChordShape shape;
			Construction construction;
			WrittenGroup writtens;
			Chord voiceingChord;
			Chord chord;

			chord = get_currentChord();
			System.Console.WriteLine("ChordCreator.create_single_voiceing_chord: currentChord = {0}", chord.to_xml());

			name = chord.get_name();
			type = chord.get_chordType();
			root = chord.get_root();
			shape = chord.get_shape();
			construction = chord.get_construction();
			writtens = chord.get_writtens();

			voiceingChord = new Chord(true);
			voiceingChord.set_name(name);
			voiceingChord.set_type(type);
			voiceingChord.set_root(root);
			voiceingChord.set_construction(construction); 
			voiceingChord.set_writtens(writtens);
			voiceingChord.set_shape(shape);
			
			currentVoiceing = get_currentVoiceing();

			voiceingChord.add_voiceing(currentVoiceing);
			System.Console.WriteLine("ChordCreator.create_single_voiceing_chord: single voiceig Chord = {0}", voiceingChord.to_xml());

			return voiceingChord;
		}

		void add_new_type(ChordType newType)
		{
			set_current_type(newType);
			allChords.add_chordType(newType);
		}

		void add_new_tuning(Tuning tuning)
		{
			ChordType type;

			type = typesOM.get_chordType();

			//so the optionmenu gets set right
			set_current_tuning(tuning);
			allChords.add_tuning(type, tuning);
		}

		void set_current_type(ChordType type)
		{
			currentType = type;
		}

		void set_current_tuning(Tuning tuning)
		{
			currentTuning = tuning;
		}

		ChordGroup get_chords_to_change()
		{
			Chord chord;
			ChordGroup chords;
			ChordShape shape;

			chord = get_currentChord();
			shape = chord.get_shape();

			if (shape == ChordShapeValue.OPEN){
				chords = new ChordGroup();
				chords.append(chord);
			} else {
				if (shape == ChordShapeValue.NO_SHAPE){
					chords = tuningChords;
				} else {
					chords = tuningChords.create_shape_sub_group(shape);
				}
			}

			return chords;
		}

		HomogeneousChordGroup get_chords_from_shape(ChordShape shape)
		{
			System.Console.WriteLine("FIX ME! ChordCreator.get_chords_from_shape: get chords from shape doesn't seem to do any thing!");
			if (tuningChords == null){
				return null;
			}
			return shapeChords;
		}

		VoiceingGroup get_voiceings_to_change()
		{
			Chord chord;
			VoiceingGroup voiceings;
			ChordShape shape;
			Voiceing currentVoiceing;

			chord = get_currentChord();
			shape = chord.get_shape();

			if (shape == ChordShapeValue.OPEN){
				voiceings = new VoiceingGroup();
				currentVoiceing =  get_currentVoiceing();
				voiceings.append(currentVoiceing);
			} else {
				voiceings = get_voiceings_from_shape(shape);
			}
			return voiceings;
		}

		VoiceingGroup get_voiceings_from_shape(ChordShape shape)
		{
			HomogeneousChordGroup shapeGroup;
			int voiceingNo = -1;
			VoiceingGroup voiceings;
			Voiceing voiceing;

			shapeGroup = get_chords_from_shape(shape);
			voiceingNo = get_current_voiceingNo();
	
			voiceings = new VoiceingGroup();
	
			foreach (Chord chord in shapeGroup){
				voiceing = chord.get_voiceing(voiceingNo);
				voiceings.append(voiceing);
			}

			return voiceings;
		}

		int get_current_voiceingNo()
		{
			int voiceingNo;
	
			voiceingNo = voiceingsOM.Active;
	
			return voiceingNo;
		}

		void set_shapesOM()
		{
			ShapesOM shapesOM;

			shapesOM = get_shapesOM();
			shapesOM.set_shapes(tuningChords.get_chordShapes());
		}
	
		ShapesOM get_shapesOM()
		{
			return shapesOM;
		}

//		ChordShape get_current_shape()
//		{
//			return shapesOM.get_shape();
//		}

		void load_file(string fileName) 
		{ 
			if(set_allChords(fileName)){
				set_dbFile(fileName);
			}
		}

		void save_file(string fileName) 
		{
			bool okToOverWrite = false;
			string xml;
			FileWriter writer;
			
			writer = new FileWriter(fileName, okToOverWrite);
			if (!writer.check())
			{
				Console.WriteLine(writer.get_error());
				throw new System.Exception(writer.get_error());				
			}
		
			xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><chords version=\"1.0\">" + allChords.to_xml() + "</chords>\n";
			writer.write(xml);
		}

/*******************************************************
 ************************CALLBACKS**********************
 ******************************************************/


		void allChords_changed_cb(object obj, EventArgs args)
		{
			set_typesOM();
		}

		void chordList_selection_changed(object obj, EventArgs args)
		{
			//	set_deleteChordButton_sensitive();
			set_voiceing_params();
			//	set_voiceing_params_sensitive();
		}

		void typesOM_cb(object obj, EventArgs args)
		{
			ChordType type;

			type = typesOM.get_chordType();
			set_current_type(type);
	
			set_typeChords();
			set_tuningsOM();
		}

		void typeEntered_cb(string text)
		{
			add_new_type(new ChordType(text));
		}

		void newTypeButton_cb(object obj, EventArgs args)
		{
			new GetStringDialog(this, "Type Name:", typeEntered_cb, ChordType.is_valid);
		}

		void tuningsOM_cb(object obj, EventArgs args)
		{
			Tuning tuning;	

			tuning = tuningsOM.get_tuning();
			set_current_tuning(tuning);

			set_tuningChords();
			set_writtensList();
			set_construction();
			set_shapesOM();
		}

		void tuningEntered_cb(string text)
		{
			Tuning tuning;	
			
			tuning = new Tuning(text);
			add_new_tuning(tuning);
		}

		void newTuningButton_cb(object obj, EventArgs args)
		{
			new GetStringDialog(this, "Tuning Name:", tuningEntered_cb, Tuning.text_is_valid_tuning);
		}

		void writtensList_added_cb(object obj, WrittenAddedArgs args)
		{
			typeChords.add_written(args.written);
		}
		
		void writtensList_removed_cb(object obj, WrittenRemovedArgs args)
		{
			typeChords.remove_written(args.written);
		}
		
		void writtensList_edited_cb(object obj, WrittenEditedArgs args)
		{
			typeChords.remove_written(args.written);
			typeChords.add_written(new GenericWritten(args.newText));
		}		
	
		void typeChords_writtens_changed_cb(object obj, EventArgs args)
		{
			set_writtensList();
		}
		
		void typeChords_notes_changed_cb(object obj, NotesChangedArgs args)
		{
			;
		}
		
		void constructionView_cb(object obj, EventArgs args)
		{
			Construction construction;
			
			construction = constructionView.get_construction();
			typeChords.set_construction(construction);
		}

		void shapesOM_cb(object obj, EventArgs args)
		{
			set_shapeChords();
			set_chordList();
		}

		void deleteChordButton_cb(object obj, EventArgs args)
		{
			ChordGroup chords;

			chords = get_chords_to_change();

			foreach (Chord chord in chords){
				allChords.remove(chord);
			}
		}

		void voiceingsOM_cb(object obj, EventArgs args)
		{
			set_prioritiesOM();
			set_voiceingInfo();
			set_string_params();
			render();
		}

		void prioritesOM_cb(object obj, EventArgs args)
		{
			VoiceingGroup voiceings;
			Priority priority;
		
			priority = prioritiesOM.get_priority();

			voiceings = get_voiceings_to_change();
			foreach (Voiceing voiceing in voiceings){
				voiceing.set_priority(priority);
			}
		}	

		void newVoiceingButton_cb(object obj, EventArgs args)
		{
			Voiceing newVoiceing;
			Tuning tuning;
			
			foreach (Chord chord in shapeChords){
				tuning = chord.get_tuning();
				newVoiceing = new Voiceing(tuning);
				chord.add_voiceing(newVoiceing);
			}	
			set_voiceingsOM(-1);
		}

		void infoEntry_cb(object obj, EventArgs args)
		{
			Voiceing currentVoiceing;
			string text;

			text = infoView.get_info();
			currentVoiceing = get_currentVoiceing();
			if (currentVoiceing != null){
				currentVoiceing.set_info(text);
			}
		}

		void stringEditor_finger_changed_cb(object obj, EventArgs args)
		{
			GuitarStringEditor stringEditor;
			VoiceingGroup voiceings;
			GuitarString guitarString;
			Finger finger;
			int stringNo;

			stringEditor = obj as GuitarStringEditor;
			finger = stringEditor.get_finger();
			stringNo = stringEditor.get_string_no();

			voiceings = get_voiceings_to_change();
			foreach (Voiceing voiceing in voiceings){
				guitarString = voiceing.get_string(stringNo);
				guitarString.set_finger(finger);
		
			}
			render();
		}

		void stringEditor_fretted_changed_cb(object obj, EventArgs args)
		{
			GuitarStringEditor stringEditor;
			GuitarString guitarString;
			ChordGroup chords;
			Note fretted;
			Relation relation;
			Voiceing voiceing;
			int stringNo;
			Chord currentChord;
	
			stringEditor = obj as GuitarStringEditor;
			fretted = stringEditor.get_fretted();
			stringNo = stringEditor.get_string_no();

			currentChord = get_currentChord();
			relation = currentChord.relation_from_note(fretted);
	
			chords = get_chords_to_change();
			foreach (Chord chord in chords){
				fretted = chord.note_from_relation(relation);
				voiceing = chord.get_voiceing(get_current_voiceingNo());
				guitarString = voiceing.get_string(stringNo);
				guitarString.set_fretted(fretted);
				guitarString.set_relation(relation);
				guitarString.auto_set_fretNo();	
			}
			render();
			
			//if the strings been deselected then we set as the finger as it's allways NO_FINGER
			//	if (strcmp(relation, "X") == 0){
			//		set_finger(self, stringNo, NO_FINGER);
			//	}
		}

		void stringEditor_is12plus_changed_cb(object obj, EventArgs args)
		{
			GuitarStringEditor stringEditor;
			Voiceing voiceing;
			GuitarString guitarString;
			bool is12plus;
			int stringNo;
	
			stringEditor = obj as GuitarStringEditor;
			is12plus = stringEditor.is12plus();
			stringNo = stringEditor.get_string_no();

			voiceing = get_currentVoiceing();
			guitarString = voiceing.get_string(stringNo);
			guitarString.set_12plus(is12plus);

			render();
		}
		
		void newMI_cb(object obj, EventArgs args)
		{
			MainClass.CreateWindow();
		}

		void stringOrderMI_cb (object sender, ChangedArgs args)
		{
			StringOrder order = (StringOrder)args.Current.Value;
			prefs.HighStringFirst = order==StringOrder.HighToLow?true:false;
		}
		
		void chordRotationMI_cb (object sender, ChangedArgs args)
		{
			ChordRotation rotation = (ChordRotation)args.Current.Value;
			prefs.ChordRotation = rotation;
		}
		
		void rightHandedMI_cb(object mi, EventArgs e)
		{
			rightHanded = !rightHanded;
			prefs.RightHanded = rightHanded;
		}
		
		void helpMI_cb(object mi, EventArgs e)
		{
			MessageDialog md = new MessageDialog (this, 
			                                      DialogFlags.DestroyWithParent,
			                                      MessageType.Error, 
			                                      ButtonsType.Close,
			                                      "helpMI clicked");
     
			md.Run ();
			md.Destroy();
		}
		
		void preferences_changed_cb(object obj, EventArgs args)
		{ 
			;
		}

		
		void openMI_cb(object obj, EventArgs args)
		{
				if(openFileSelector != null){
				openFileSelector.Present();
			} else {
				openFileSelector= new Gtk.FileChooserDialog("Choose the file to open",
                                      this,
                                      FileChooserAction.Open,
                                      "Cancel",ResponseType.Cancel,
                                      "Open",ResponseType.Accept);
			}
			if (openFileSelector.Run() == (int)ResponseType.Accept) 
			{
				load_file(openFileSelector.Filename);
			}
		}
		
		void saveMI_cb(object obj, EventArgs args)
		{
			save_file(dbFile);
		}
		
		void saveAsMI_cb(object obj, EventArgs args)
		{
			if(saveAsFileSelector != null){
				saveAsFileSelector.Present();
			} else {
				saveAsFileSelector= new Gtk.FileChooserDialog("Choose the file to save",
				                                              this,
				                                              FileChooserAction.Save,
				                                              "Cancel",ResponseType.Cancel,
				                                              "Open",ResponseType.Accept);
			}
			if (openFileSelector.Run() == (int)ResponseType.Accept) 
			{
				save_file(saveAsFileSelector.Filename);
			}
		}
		
		void closeMI_cb(object mi, EventArgs e)
		{
			Destroy();
			MainClass.OnDelete(this, new EventArgs());
		}
		
		void quitMI_cb(object mi, EventArgs e)
		{
			Application.Quit();
		}
		
		void aboutMI_cb(object obj, EventArgs args)
		{	
			about = new AboutDialog ();
			Assembly asm = Assembly.GetExecutingAssembly ();
          
			about.ProgramName = (asm.GetCustomAttributes(typeof (AssemblyTitleAttribute), false)[0] as AssemblyTitleAttribute).Title;
			about.Version = asm.GetName().Version.ToString ();
			about.Comments = (asm.GetCustomAttributes (typeof (AssemblyDescriptionAttribute), false)[0] as AssemblyDescriptionAttribute).Description;
			about.Copyright = (asm.GetCustomAttributes( typeof (AssemblyCopyrightAttribute), false) [0] as AssemblyCopyrightAttribute).Copyright;     
			about.License = new System.IO.StreamReader(Assembly.GetExecutingAssembly().GetManifestResourceStream("gpl-3.0.txt")).ReadToEnd();
			about.Authors =  new string [] {"Rob Wood <rob@pangolin.org.uk>"};
          	about.Logo = Icon;
			about.Website = "www.gnome-chord.sourceforge.net";
			about.Run ();
			about.Destroy();
		}
	}
}