using System;
using System.Reflection;
using Gtk;

namespace gnomeguitar_cs
{

	public class GChord: Window{
		ChordList chordList;
		RendererContainer rendererContainer;
		ChordGroup allChords;
		ChordGroup selectedChords;
		TreeCreator treeCreator = null;
		AboutDialog about = null;
		VBox contents;
		ChordRendererPrefs prefs;
		bool rightHanded;
		Button removeButton;
		
		public GChord () : base("Gnome-chord")
		{
			prefs = new ChordRendererPrefs();
			if (prefs.Error){
				GConfWorkaround fixer = new GConfWorkaround();
				fixer.fix(this);
			}
			SetDefaultSize(300,450);
			contents = new VBox (false, 0);
			Add (contents);
			create_menus_toolBar_and_statusBar();
			Icon = new Gdk.Pixbuf(Assembly.GetExecutingAssembly().GetManifestResourceStream("gnome-chord-logo.png"));	
			build_widget();
			connect_signals();
		}

		public GChord(string dbFile): this()
		{
			load_file(dbFile);	
		}

		public GChord(ChordDb db): this()
		{
			load_file(db);	
		}

		public void merge_and_select_chord (Chord chord)
		{
			System.Console.WriteLine("GChord.merge_and_select_chord: This function isn't implemented as I don't know what it is meant to do");
//			ChordGroup allChords;
////			ChordList chordList;
//			Chord realChord;
//
//			allChords = get_allChords();
//			realChord = allChords.merge_chord(chord);
	
	//		chordList = get_chordList();
		//	chordList.select_chord(realChord);
		}

/*******************************************
 ****************PRIVATE STUFF**************
 *******************************************/
		
		void create_menus_toolBar_and_statusBar()
		{
			const string uiInfo =
				"<ui>" +
					"  <menubar name='MenuBar'>" +
					"    <menu action='FileMenu'>" +
					"      <menuitem action='New'/>" +
					"      <menuitem action='Close'/>" +
					"      <separator/>" +
					"      <menuitem action='Quit'/>" +
					"    </menu>" +
					"    <menu action='PreferencesMenu'>" +
					"      <menu action='StringOrder'>" +
					"        <menuitem action='LowToHigh'/>" +
					"        <menuitem action='HighToLow'/>" +
					"      </menu>" +
					"      <menu action='ChordRotation'>" +
					"        <menuitem action='Horizontal'/>" +
					"        <menuitem action='Vertical'/>" +
					"      </menu>" +
					"      <separator action='Sep1'/>" +
					"      <menuitem action='RightHanded'/>" +
					"    </menu>" +
					"    <menu action='HelpMenu'>" +
					"      <menuitem action='Help'/>" +
					"      <separator/>" +
					"      <menuitem action='About'/>" +
					"    </menu>" +
					"  </menubar>" +
					"  <toolbar  name='ToolBar'>" +
					"    <toolitem name='new' action='New'/>" +
					"    <toolitem name='quit' action='Quit'/>" +
					"    <separator action='Sep1'/>" +
					"    <toolitem name='help' action='Help'/>" +
					"  </toolbar>" +
					"</ui>";	
			
			ActionEntry[] actions = new ActionEntry[]
			{
				new ActionEntry ("FileMenu", null, "_File", null, null, null),
				new ActionEntry ("PreferencesMenu", null, "_Preferences", null, null, null),
				new ActionEntry ("StringOrder", null, "_String Order", null, null, null),
				new ActionEntry ("ChordRotation", null, "_Chord Rotation", null, null, null),
				new ActionEntry ("HelpMenu", null, "_Help", null, null, null),
				new ActionEntry ("New", Stock.New, "_New", "<control>N", "Open a new Gnome-Scale window", newMI_cb),
				new ActionEntry ("Close", Stock.Close, "_Close", "<control>C", "Close the current Gnome-Scale window", closeMI_cb),
				new ActionEntry ("Quit", Stock.Quit, "_Quit", "<control>Q", "Quit all open Gnome-Scale windows", quitMI_cb),
				new ActionEntry ("About", Stock.About, "_About", "<control>A", "About", aboutMI_cb),				
				new ActionEntry ("Help", Stock.Help, "_Help", "<control>H", "Help", helpMI_cb)
			};
			rightHanded = prefs.RightHanded;						
			ToggleActionEntry[] toggleActions = new ToggleActionEntry[]
			{
				new ToggleActionEntry ("RightHanded", null, "_Right Handed?", "<control>R", "Display the guitar for right or left handed players", rightHandedMI_cb, rightHanded)
			};

			RadioActionEntry[] stringOrderActions = new RadioActionEntry[]
			{
				new RadioActionEntry ("HighToLow", null, "_High To Low", "<control>H", "Order strings as if looking down at your guitar", (int)StringOrder.HighToLow),
				new RadioActionEntry ("LowToHigh", null, "_Low To High", "<control>L", "Order strings as if looking at someone else guitar", (int)StringOrder.LowToHigh),
			};
			RadioActionEntry[] chordRotationActions = new RadioActionEntry[]
			{
				new RadioActionEntry ("Horizontal", null, "_Horizontal", "<control>H", "Display the chord horizontaly", (int)ChordRotation.Horizontal),
				new RadioActionEntry ("Vertical", null, "_Vertical", "<control>V", "Display the chord vertically", (int)ChordRotation.Vertical),
			};
			ActionGroup group = new ActionGroup ("AppWindowActions");
			group.Add (actions);
			group.Add (toggleActions);
			StringOrder stringOrder = prefs.HighStringFirst?StringOrder.HighToLow:StringOrder.LowToHigh;
			group.Add (stringOrderActions, (int)stringOrder, stringOrderMI_cb);
			ChordRotation chordRotation = prefs.ChordRotation;
			group.Add (chordRotationActions, (int)chordRotation, chordRotationMI_cb);
			UIManager uim = new UIManager ();
			uim.InsertActionGroup (group, 0);
			uim.AddUiFromString (uiInfo);
			AddAccelGroup (uim.AccelGroup);
			
			
			contents.PackStart (uim.GetWidget ("/MenuBar"), false, false, 0);
			Widget prefsMenu = uim.GetWidget("/MenuBar/PreferencesMenu");
			prefsMenu.Sensitive = !prefs.Error;
//	xyz.PackStart (uim.GetWidget ("/ToolBar"), false, false, 0);
			contents.PackEnd(new Statusbar(), false, false, 0);
		}
		
		void build_widget()
		{
			HPaned hpaned;

			VBox vbox;
			ScrolledWindow scrolledWindow;
			ChordRendererUI renderer;
			HButtonBox buttonBox;
			Button button;
						
			hpaned = new HPaned();
			hpaned.BorderWidth = 10;

			chordList = new ChordList();
			scrolledWindow = new ScrolledWindow();
			scrolledWindow.HscrollbarPolicy = PolicyType.Always;
			scrolledWindow.VscrollbarPolicy = PolicyType.Always;
			scrolledWindow.ShadowType = ShadowType.In;		
			scrolledWindow.Add(chordList);

			buttonBox = new HButtonBox();
			button = new Button(Gtk.Stock.Add);
			button.Clicked += addTreeButton_cb;
			buttonBox.PackEnd(button);
			removeButton = new Button(Gtk.Stock.Remove);
			removeButton.Clicked += removeTreeButton_cb;
			buttonBox.PackEnd(removeButton);
			
			vbox = new VBox(false,5);
			vbox.PackStart(scrolledWindow,true, true,0);
			vbox.PackEnd(buttonBox,false,false, 0);
			vbox.BorderWidth = 5;
			
			renderer = new ChordCairoRenderer(prefs);	
			rendererContainer = new RendererContainer(renderer);
			
			hpaned.Pack1(vbox, true, false);
			hpaned.Pack2(rendererContainer, true, false);
			//hpaned.Position = 375;
			hpaned.ShowAll();
			
			contents.PackEnd(hpaned);		
		//	renderer.render_default();
		}

//		void create_toolbar()
//		{
//			Toolbar toolbar = new Toolbar();
//			ToolButton item;
//			
////			item = new ToolButton(Gtk.Stock.New);
////			item.Clicked += new_cb;
////			toolbar.Insert(item, -1);
////			
////			item = new ToolButton(Gtk.Stock.Open);
////			item.Clicked += open_cb;
////			toolbar.Insert(item, -1);
////			
////			item = new ToolButton(Gtk.Stock.Close);
////			item.Clicked += exit_cb;
////			toolbar.Insert(item, -1);
////			
////			item = new ToolButton(Gtk.Stock.Preferences);
////			item.Clicked += preferences_cb;
////			toolbar.Insert(item, -1);
////			
////			item = new ToolButton(Gtk.Stock.About);
////			item.Clicked += about_cb;
////			toolbar.Insert(item, -1);
//			
//			zoomOM = new ZoomOM();
//			zoomOM.Changed += zoom_cb;
//			toolbar.AppendElement(ToolbarChildType.Widget, zoomOM, "_Zoom", "The type of zooming to be preformed.", "Don't know what this is used for.", null, null);
//			
//			spinner = new SpinButton(0, 10, 1);
//			spinner.Sensitive = false;
//			spinner.ValueChanged += spinner_cb;
//			toolbar.AppendElement(ToolbarChildType.Widget, spinner, "_Number", "The number of chords to zoom to.", "Don't know what this is used for.", null, null);
//			
//			rotationOM = new RotationOM();
//			rotationOM.set_rotation(new Rotation((int)client.Get(gconfPath + "/chordRotation")));
//			rotationOM.Changed += rotation_cb;
//			toolbar.AppendElement(ToolbarChildType.Widget, rotationOM, "_Rotation", "The rotation of the chords.", "Don't know what this is used for.", null, null);
//			
//			rightyCB = new CheckButton("Right Handed");
//			rightyCB.Active = (bool)client.Get(gconfPath + "/rightHanded");
//			rightyCB.Toggled += handedness_cb;
//			toolbar.AppendElement(ToolbarChildType.Widget, rightyCB, "Right _Handed", "Sets the chords to right or left handed.", "Don't know what this is used for.", null, null);
//	
//			toolbar.ShowAll();
//			Toolbar = toolbar;
//		}
			                              
		void  set_allChords(ChordGroup chords)
		{
		//	System.Console.WriteLine("GChord.set_allChords: {0}",chords.to_xml());
			allChords = chords;
			set_up_chord_tree();
		}

		void set_up_chord_tree()
		{
			chordList.add_chordTree(allChords,new TreeLayout(
			                                  new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD_SHAPE),
			                                  new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD_TYPE),
			                                  new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD)),
			                        "Default Chord Tree");
		
//			chordList.add_chordTree(allChords, new TreeLayout(new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD)));
			//chordList.ExpandToPath(new TreePath(new int[] {0,0}));
			//chordList.NodeSelection.SelectPath(new TreePath(new int[] {0}));
			chordList.ShowAll();
		}

		void render_chords(ChordGroup chords)
		{
			RendererContainer rendererContainer;
	
			rendererContainer = get_renderer_container();
			rendererContainer.render(chords);
		}

		RendererContainer get_renderer_container()
		{
			return rendererContainer;
		}
		
		void load_file(string fileName)
		{
			XmlChordParser parser;
			FileReader reader;
			
			reader= new FileReader(fileName);
			if (!reader.check())
			{
				Console.WriteLine(reader.get_error());
				throw new System.Exception(reader.get_error());										
			}
		
			parser = new XmlChordParser(reader);
			set_allChords(parser.parse());
		}
	
		void load_file(ChordDb db)
		{
			XmlChordParser parser;
			FileReader reader;
			
			reader= new FileReader(db);
			if (!reader.check())
			{
				Console.WriteLine(reader.get_error());
				throw new System.Exception(reader.get_error());										
			}
			
			parser = new XmlChordParser(reader);
			set_allChords(parser.parse());
		}
		
		void show_treeCreator()
		{
			if(treeCreator != null){
				treeCreator.Present();
			} else {
				treeCreator = new TreeCreator(allChords);
				treeCreator.Response += treeCreator_cb;
				treeCreator.ShowAll();
			}
		}
		

/******************************************************************
 *********************CALLBACKS***********************************
 *****************************************************************/

		void connect_signals()
		{
			chordList.onSelectionChanged += selection_changed_cb;
		}

		void selection_changed_cb (object obj, EventArgs args)
		{
			selectedChords = chordList.get_selected_chords();
			//System.Console.WriteLine("GChord.selection_changed_cb: {0}",selectedChords.to_xml());
			if(selectedChords.get_no() != 0){
				render_chords (selectedChords);
			} else {
				rendererContainer.clear();
			}
			removeButton.Sensitive = chordList.is_root_selected();
		}

		void newMI_cb(object obj, EventArgs args)
		{
			MainClass.CreateWindow();
		}
		
		void closeMI_cb(object mi, EventArgs e)
		{
			Destroy();
			MainClass.OnDelete(this, new EventArgs());
		}
		
		void quitMI_cb(object mi, EventArgs e)
		{
			Application.Quit();
		}

		void stringOrderMI_cb (object sender, ChangedArgs args)
		{
			StringOrder order = (StringOrder)args.Current.Value;
			prefs.HighStringFirst = order==StringOrder.HighToLow?true:false;
		}
		
		void chordRotationMI_cb (object sender, ChangedArgs args)
		{
			ChordRotation rotation = (ChordRotation)args.Current.Value;
			prefs.ChordRotation = rotation;
		}
		
		void rightHandedMI_cb(object mi, EventArgs e)
		{
			MessageDialog md = new MessageDialog (this, 
			                                      DialogFlags.DestroyWithParent,
			                                      MessageType.Info, 
			                                      ButtonsType.Ok, "Setting 'Right/Left Handed' only effects the layout of horizontal chords.");
     
			md.Run ();
			md.Destroy();
			rightHanded = !rightHanded;
			prefs.RightHanded = rightHanded;
		}
		
		void helpMI_cb(object mi, EventArgs e)
		{
			MessageDialog md = new MessageDialog (this, 
			                                      DialogFlags.DestroyWithParent,
			                                      MessageType.Error, 
			                                      ButtonsType.Close,
			                                      "Sorry, you are own for the time being!");
     
			md.Run ();
			md.Destroy();
		}
		

		void aboutMI_cb(object obj, EventArgs args)
		{	
			about = new AboutDialog ();
			Assembly asm = Assembly.GetExecutingAssembly ();
          
			about.ProgramName = (asm.GetCustomAttributes(typeof (AssemblyTitleAttribute), false)[0] as AssemblyTitleAttribute).Title;
			about.Version = asm.GetName().Version.ToString ();
			about.Comments = (asm.GetCustomAttributes (typeof (AssemblyDescriptionAttribute), false)[0] as AssemblyDescriptionAttribute).Description;
			about.Copyright = (asm.GetCustomAttributes( typeof (AssemblyCopyrightAttribute), false) [0] as AssemblyCopyrightAttribute).Copyright;     
			about.License = new System.IO.StreamReader(Assembly.GetExecutingAssembly().GetManifestResourceStream("gpl-3.0.txt")).ReadToEnd();
			about.Authors =  new string [] {"Rob Wood <rob@pangolin.org.uk>"};
          	about.Logo = Icon;
			about.Website = "www.gnome-chord.sourceforge.net";
			about.Run ();
			about.Destroy();
		}
		

		void addTreeButton_cb (object obj, EventArgs args)
		{
			show_treeCreator();
		}
		
		void removeTreeButton_cb (object obj, EventArgs args)
		{
			chordList.remove_selected();
		}
		
		void treeCreator_cb(object obj, ResponseArgs args)
		{
			TreeLayout layout;
			ChordGroup chords;
			
			if(args.ResponseId == ResponseType.Ok){
				chords = treeCreator.get_subGroup();
				if(chords.get_no() == 0){
					MessageDialog md = new MessageDialog (this, 
					                                      DialogFlags.DestroyWithParent,
					                                      MessageType.Warning, 
					                                      ButtonsType.Ok, "You are currently filtering out all the Chords!");
     
					md.Run ();
					md.Destroy();
					return;
				}
				layout = treeCreator.get_treeLayout();				
//				System.Console.WriteLine("GChord.treeCreator_cb: layout = {0}, chords = {1}", layout, chords);
				chordList.add_chordTree(chords, layout, treeCreator.get_name());	
			}

		
			treeCreator.Destroy();
			treeCreator = null;
		}
	}
}
			
