using Gtk;
using System;
using System.Reflection;

namespace gnomeguitar_cs
{
	public class GScale : Window{
		
		ScaleCairoRenderer scaleRenderer;
		
		ScaleTypesOM typesOM;
		NotesOM rootsOM;
		ScaleModesOM modesOM;
		ScaleList scaleList;
		//not sure why we need to do this
		Tuning tuning = new Tuning("E,A,D,G,B,E");
		AboutDialog about = null;
		VBox contents;
		ScaleRendererPrefs prefs;
		
		public GScale(): base("Gnome-Scale")
		{
			prefs = new ScaleRendererPrefs();
			prefs.PreferencesChanged += preferences_changed_cb;
			if (prefs.Error){
				GConfWorkaround fixer = new GConfWorkaround();
				fixer.fix(this);
			}
			contents = new VBox (false, 0);
			Add (contents);
			SetDefaultSize(675,370);
			Icon = new Gdk.Pixbuf(Assembly.GetExecutingAssembly().GetManifestResourceStream("gnome-scale-logo.png"));
			create_menus_toolBar_and_statusBar();
			create_contents();
			connect_signals();
			render_scale();
		}

		void create_menus_toolBar_and_statusBar()
		{
			const string uiInfo =
				"<ui>" +
					"  <menubar name='MenuBar'>" +
					"    <menu action='FileMenu'>" +
					"      <menuitem action='New'/>" +
					"      <menuitem action='Close'/>" +
					"      <separator/>" +
					"      <menuitem action='Quit'/>" +
					"    </menu>" +
					"    <menu action='PreferencesMenu'>" +
					"      <menu action='StringOrder'>" +
					"        <menuitem action='LowToHigh'/>" +
					"        <menuitem action='HighToLow'/>" +
					"      </menu>" +
					"      <separator action='Sep1'/>" +
					"      <menuitem action='RightHanded'/>" +
					"    </menu>" +
					"    <menu action='HelpMenu'>" +
					"      <menuitem action='Help'/>" +
					"      <separator/>" +
					"      <menuitem action='About'/>" +
					"    </menu>" +
					"  </menubar>" +
					"  <toolbar  name='ToolBar'>" +
					"    <toolitem name='new' action='New'/>" +
					"    <toolitem name='quit' action='Quit'/>" +
					"    <separator action='Sep1'/>" +
					"    <toolitem name='help' action='Help'/>" +
					"  </toolbar>" +
					"</ui>";	
			
			ActionEntry[] actions = new ActionEntry[]
			{
				new ActionEntry ("FileMenu", null, "_File", null, null, null),
				new ActionEntry ("PreferencesMenu", null, "_Preferences", null, null, null),
				new ActionEntry ("StringOrder", null, "_String Order", null, null, null),
				new ActionEntry ("HelpMenu", null, "_Help", null, null, null),
				new ActionEntry ("New", Stock.New, "_New", "<control>N", "Open a new Gnome-Scale window", newMI_cb),
				new ActionEntry ("Close", Stock.Close, "_Close", "<control>C", "Close the current Gnome-Scale window", closeMI_cb),
				new ActionEntry ("Quit", Stock.Quit, "_Quit", "<control>Q", "Quit all open Gnome-Scale windows", quitMI_cb),
				new ActionEntry ("About", Stock.About, "_About", "<control>A", "About", aboutMI_cb),				
				new ActionEntry ("Help", Stock.Help, "_Help", "<control>H", "Help", helpMI_cb)
			};
								
			ToggleActionEntry[] toggleActions = new ToggleActionEntry[]
			{
				new ToggleActionEntry ("RightHanded", null, "_Right Handed?", "<control>R", "Display the guitar for right or left handed players", rightHandedMI_cb, prefs.RightHanded)
			};

			RadioActionEntry[] stringOrderActions = new RadioActionEntry[]
			{
				new RadioActionEntry ("HighToLow", null, "_High To Low", "<control>H", "Order strings as if looking down at your guitar", (int)StringOrder.HighToLow),
				new RadioActionEntry ("LowToHigh", null, "_Low To High", "<control>L", "Order strings as if looking at someone else guitar", (int)StringOrder.LowToHigh),
			};

			ActionGroup group = new ActionGroup ("AppWindowActions");
			group.Add (actions);
			group.Add (toggleActions);
			StringOrder stringOrder = prefs.HighStringFirst?StringOrder.HighToLow:StringOrder.LowToHigh;
			group.Add (stringOrderActions, (int)stringOrder, stringOrderMI_cb);

			UIManager uim = new UIManager ();
			uim.InsertActionGroup (group, 0);
			uim.AddUiFromString (uiInfo);
			AddAccelGroup (uim.AccelGroup);
			
			contents.PackStart (uim.GetWidget ("/MenuBar"), false, false, 0);
			Widget prefsMenu = uim.GetWidget("/MenuBar/PreferencesMenu");
			prefsMenu.Sensitive = !prefs.Error;
			//	contents.PackStart (uim.GetWidget ("/ToolBar"), false, false, 0);
			contents.PackEnd(new Statusbar(), false, false, 0);
		}

		void connect_signals()
		{
			rootsOM.Changed += rootOM_cb;
			modesOM.Changed += new EventHandler(modesOM_cb);
			typesOM.Changed += new EventHandler(typesOM_cb);
		}

		void create_contents()
		{
			VBox vbox;
			Widget topBox;
			Widget bottomBox;
			Widget rendererBox;
	
			vbox = new VBox(false, 5);
			vbox.BorderWidth = 5;
			topBox = create_scaleSelectors();
			bottomBox = create_scaleText();
			rendererBox = create_renderer();
	
			Frame padding = new Frame();
			padding.Shadow = ShadowType.None;
//			padding.BorderWidth = 0;
			
			vbox.PackStart(topBox, false, false, 0);
			vbox.PackStart(padding, false, false, 0);
			vbox.PackStart(rendererBox, true, true, 0);
			vbox.PackStart(bottomBox, false, false, 0);
			contents.PackEnd(vbox);
			
			//don't know why this is needed
			//render_scale();
		}


		Widget create_scaleSelectors()
		{
			Box hBox;
			Frame typeFrame;
			Frame rootFrame;
			Frame modeFrame;
			Frame padding;
			
			hBox = new HBox(false, 5);

			typeFrame = new Frame("Type");
			padding = new Frame();
			padding.BorderWidth = 2;
			padding.Shadow = ShadowType.None;
			typesOM = new ScaleTypesOM();
			padding.Add(typesOM);
			typeFrame.Add(padding);
			
			rootFrame = new Frame("Root");
			padding = new Frame();
			padding.BorderWidth = 2;
			padding.Shadow = ShadowType.None;
			rootsOM = new NotesOM(false);
			rootsOM.set_note(new Note(NoteValue.C));
			padding.Add(rootsOM);
			rootFrame.Add(padding);
			
			modeFrame = new Frame("Mode");
			padding = new Frame();
			padding.BorderWidth = 2;
			padding.Shadow = ShadowType.None;
			modesOM = new ScaleModesOM(new ScaleType(ScaleTypeValue.MAJOR));
			padding.Add(modesOM);
			modeFrame.Add(padding);

			hBox.PackStart(typeFrame, true, true, 0);
			hBox.PackStart(rootFrame, true, true, 0);
			hBox.PackStart(modeFrame, true, true, 0);

			return hBox;
		}

		Widget create_scaleText()
		{
			Frame scaleTextFrame = null;
			Scale scale = null;

			scaleTextFrame = new Frame("Scale");
			
			scale = get_scale();
			scaleList = new ScaleList(scale);		

			scaleTextFrame.Add(scaleList);
			
			return scaleTextFrame;
		}

		Widget create_renderer()
		{
			scaleRenderer = new ScaleCairoRenderer(prefs);
			return scaleRenderer.GetWidget();
		}

		void set_scaleList(Scale scale)
		{
//			System.Console.WriteLine(GScale.set_scaleList: scale.get_name());
			scaleList.set_scale(scale);
		}

		void set_modeOM()
		{
			ScaleType scaleType;

			scaleType = get_scaleType();
			modesOM.set_scale(scaleType);
		}

		ScaleType get_scaleType()
		{
			ScaleType scaleType; 
	
			scaleType = typesOM.get_scaleType();
	
			return scaleType;
		}

		Note get_scaleRoot()
		{
			return rootsOM.get_note();
		}

 
		int get_scaleMode()
		{
			return modesOM.get_mode();
		}

		Scale get_scale()
		{
			Note root;
			int mode = 0;
			ScaleType type;
			Scale scale;

			type = get_scaleType();
			root = get_scaleRoot();
			mode = get_scaleMode();
			
			//System.Console.WriteLine("GScale.get_scale: type = {0} root = {1} mode = {2}", type.to_text(), root.to_text(), mode.ToString());
	
			scale = new Scale (new Note(root), type, mode);

			return scale;
		}

		void render_scale()
		{
			Scale scale = null;

			scale = get_scale();
			scaleRenderer.Render(scale, tuning);
		}

/**********************************************
 ****************CALLBACKS*********************
 *********************************************/


		void rootOM_cb (object rootOM, EventArgs e)
		{
	//		System.Console.WriteLine("GScale.rootOMcb: Root = {0}",((NotesOM)rootOM).get_note().to_text());
			set_scaleList(get_scale());
			render_scale();
		}

		void modesOM_cb (object modesOM, EventArgs e)
		{
			set_scaleList(get_scale());
			render_scale();
		}

		void typesOM_cb (object typesOM, EventArgs e)
		{
			set_modeOM();
			//	set_scaleList(self);
		}

		void newMI_cb(object mi, EventArgs e)
		{
			MainClass.CreateWindow();
		}
		void closeMI_cb(object mi, EventArgs e)
		{
			Destroy();
			MainClass.OnDelete(this, new EventArgs());
		}
		void quitMI_cb(object mi, EventArgs e)
		{
			Application.Quit();
		}

		void stringOrderMI_cb (object sender, ChangedArgs args)
		{
			StringOrder order = (StringOrder)args.Current.Value;
			//System.Console.WriteLine("GScale.stringOrderMI_cb: Setting string order to: {0}", order);
			prefs.HighStringFirst = order==StringOrder.HighToLow?true:false;
		}
		
		void rightHandedMI_cb(object mi, EventArgs e)
		{
			prefs.RightHanded = !prefs.RightHanded;
		}
		
		void helpMI_cb(object mi, EventArgs e)
		{
			MessageDialog md = new MessageDialog (this, 
			                                      DialogFlags.DestroyWithParent,
			                                      MessageType.Error, 
			                                      ButtonsType.Close,
			                                      "helpMI clicked");
     
			md.Run ();
			md.Destroy();
		}
		
		void preferences_changed_cb(object obj, EventArgs args)
		{ 
			;
		}


	
		void aboutMI_cb(object obj, EventArgs args)
		{	
			about = new AboutDialog ();
			Assembly asm = Assembly.GetExecutingAssembly ();
          
			about.ProgramName = (asm.GetCustomAttributes(typeof (AssemblyTitleAttribute), false)[0] as AssemblyTitleAttribute).Title;
			about.Version = asm.GetName().Version.ToString ();
			about.Comments = (asm.GetCustomAttributes (typeof (AssemblyDescriptionAttribute), false)[0] as AssemblyDescriptionAttribute).Description;
			about.Copyright = (asm.GetCustomAttributes( typeof (AssemblyCopyrightAttribute), false) [0] as AssemblyCopyrightAttribute).Copyright;     
			about.License = new System.IO.StreamReader(Assembly.GetExecutingAssembly().GetManifestResourceStream("gpl-3.0.txt")).ReadToEnd();
			about.Authors =  new string [] {"Rob Wood <rob@pangolin.org.uk>"};
          	about.Logo = Icon;
			about.Website = "www.gnome-chord.sourceforge.net";
			
			about.Run ();
			about.Destroy();		
		}
		
	}
}
