using System;
using GConf;

namespace gnomeguitar_cs
{
	public class ChordRendererPrefs {
		string path = "/apps/gnome-guitar/libgnomeguitar/chordRenderer";
		GConf.Client client;

		bool error = false;
		public bool Error{
			get {return error;}
		}
		
		ChordRotation chordRotation;
		public ChordRotation ChordRotation{
			get {return chordRotation;}
			set {
				if(!Error){client.Set(path + "/chordRotation", (int)value);}
				chordRotation = value;
			}				
		}
		
		bool rightHanded;
		public bool RightHanded{
			get {return rightHanded;}
			set {
				if(!Error){client.Set(path + "/rightHanded", value);}
				rightHanded = value;
			}
		}
		bool highStringFirst;
		public bool HighStringFirst{
			get {return highStringFirst;}
			set {
				if(!Error){client.Set(path + "/highStringFirst", value);}
				highStringFirst = value;
			}
		}
		
		string backgroundColor = "#FFFFFF";
		public string BackgroundColor{get {return backgroundColor;}}
			
		string borderColor = "#000000";
		public string BorderColor{get {return borderColor;}}
		double borderWidth = 1;
		public double BorderWidth{get {return borderWidth;}}
		
		double chordXPadding = 5;
		public double ChordXPadding{get {return chordXPadding;}}
		double chordYPadding = 5;
       	public double ChordYPadding{get {return chordYPadding;}}

		string fingerColor = "#ff9b30";
		public string FingerColor{get {return fingerColor;}}
		double fingerDiameter = 10;
		public double FingerDiameter{get {return fingerDiameter;}}
		string fingerFont = "Times New Roman";
		public string FingerFont{get {return fingerFont;}}
		string fingerFontColor = "#000000";
		public string FingerFontColor{get {return fingerFontColor;}}		
		int fingerFontSize = 7;
		public int FingerFontSize{get {return fingerFontSize;}}
		
		string fingerOutlineColor = "#d894f1";
		public string FingerOutlineColor{get {return fingerOutlineColor;}}	
		double fingerOutlineWidth = 1;
		public double FingerOutlineWidth{get {return fingerOutlineWidth;}}

		string fretNoColor = "#000000";
		public string FretNoColor{get {return fretNoColor;}}
		string fretNoFont = "Times New Roman";
		public string FretNoFont{get {return fretNoFont;}}
		double fretNoPadding = 1;
		public double FretNoPadding{get {return fretNoPadding;}}
		int fretNoSize = 6;
		public int FretNoSize{get {return fretNoSize;}}

		double fretPadding = 10;
		public double FretPadding{get {return fretPadding;}}
		
		string frettedColor = "#000000";
		public string FrettedColor{get {return frettedColor;}}
		string frettedFont = "Times New Roman";
		public string FrettedFont{get {return frettedFont;}}
		double frettedPadding = 1;
		public double FrettedPadding{get {return frettedPadding;}}
		int frettedSize = 6;
		public int FrettedSize{get {return frettedSize;}}
		
		string fretWireColor = "#000000";
		public string FretWireColor{get {return fretWireColor;}}
		double fretWireWidth = 1;
		public double FretWireWidth{get {return fretWireWidth;}}

		int minNoFrets = 5;
		public int MinNoFrets{get {return minNoFrets;}}

		string neckColor = "#000000";
		public string NeckColor{get {return neckColor;}}
		double neckWidth = 2;
		public double NeckWidth{get {return neckWidth;}}
		
		string relationColor = "#000000";
		public string RelationColor{get {return relationColor;}}
		string relationFont = "Times New Roman";
		public string RelationFont{get {return relationFont;}}
		double relationPadding = 1;
		public double RelationPadding{get {return relationPadding;}}
		int relationSize = 6;
		public int RelationSize{get {return relationSize;}}
		
		string stringColor = "#000000";
		public string StringColor{get {return stringColor;}}
		double stringDashLength = 1;
		public double StringDashLength{get {return stringDashLength;}}
		double stringExtraPercent = 0.75;
		public double StringExtraPercent{get {return stringExtraPercent;}}
		double stringPadding = 0;
		public double StringPadding{get {return stringPadding;}}
		double stringWidth = 1;
		public double StringWidth{get {return stringWidth;}}
		
		string titleColor = "#000000";
		public string TitleColor{get {return titleColor;}}
		string titleFont = "Times New Roman";
		public string TitleFont{get {return titleFont;}}
		double titlePadding = 1;
		public double TitlePadding{get {return titlePadding;}}
		int titleSize = 10;
		public int TitleSize{get {return titleSize;}}

		string tuningColor = "#000000";
		public string TuningColor{get {return tuningColor;}}
		string tuningFont = "Times New Roman";
		public string TuningFont{get {return tuningFont;}}
		double tuningPadding = 2;
		public double TuningPadding{get {return tuningPadding;}}
		int tuningSize = 6;
		public int TuningSize{get {return tuningSize;}}
		
		double voiceingBottomPadding = 2;
		public double VoiceingBottomPadding{get {return voiceingBottomPadding;}}
		double voiceingLeftPadding = 0;
		public double VoiceingLeftPadding{get {return voiceingLeftPadding;}}
		double voiceingRightPadding = 0;
		public double VoiceingRightPadding{get {return voiceingRightPadding;}}
		double voiceingTopPadding = 2;
		public double VoiceingTopPadding{get {return voiceingTopPadding;}}
		

		public delegate void PreferencesChangedHandler (object o, 
		                                                EventArgs args);
		
		public event PreferencesChangedHandler PreferencesChanged;
		
		public ChordRendererPrefs ()
		{
			client = new GConf.Client();
			client.AddNotify (path, preferences_changed_cb);
			set_up_prefs();
		}


/***********************************************************
 ***********************PRIVATE*****************************
 ***********************************************************/
		
		private void set_up_prefs()
		{
			error = false;
			try{chordRotation = (ChordRotation)client.Get(path + "/chordRotation");}
			catch (GConf.NoSuchKeyException){chordRotation = ChordRotation.Vertical; error = true;}
			try{rightHanded = (bool)client.Get(path + "/rightHanded");}
			catch (GConf.NoSuchKeyException){rightHanded = true; error = true;}
			try{highStringFirst = (bool)client.Get(path + "/highStringFirst");}
			catch (GConf.NoSuchKeyException){highStringFirst = false; error = true;}
				
//			backgroundColor = (string)client.Get(path + "/backgroundColor");
//			
//			chordXPadding = (double)client.Get(path + "/chordXPadding");
//			chordYPadding = (double)client.Get(path + "/chordYPadding");
//
//			voiceingLeftPadding = (double)client.Get(path + "/voiceingLeftPadding");
//			voiceingRightPadding = (double)client.Get(path + "/voiceingRightPadding");
//			voiceingTopPadding = (double)client.Get(path + "/voiceingTopPadding");
//			voiceingBottomPadding = (double)client.Get(path + "/voiceingBottomPadding");
//
//			minNoFrets = (int)client.Get(path + "/minNoFrets");
//
//			borderColor = (string)client.Get(path + "/borderColor");
//			borderWidth = (double)client.Get(path + "/borderWidth");
//
//			titleColor = (string)client.Get(path + "/titleColor");	
//			titleFont = (string)client.Get(path + "/titleFont");
//
//			titleSize = (int)client.Get(path + "/titleSize");
//			titlePadding = (double)client.Get(path + "/titlePadding");
//
//			tuningColor = (string)client.Get(path + "/tuningColor");
//			tuningFont = (string)client.Get(path + "/tuningFont");
//			tuningSize = (int)client.Get(path + "/tuningSize");
//			tuningPadding = (double)client.Get(path + "/tuningPadding");
//	
//			neckColor = (string)client.Get(path + "/neckColor");
//			neckWidth = (double)client.Get(path + "/neckWidth");
//
//			fretWireColor = (string)client.Get(path + "/fretWireColor");
//			fretWireWidth = (double)client.Get(path + "/fretWireWidth");
//					
//			fretPadding = (double)client.Get(path + "/fretPadding");
//
//			fretNoColor = (string)client.Get(path + "/fretNoColor");
//			fretNoFont = (string)client.Get(path + "/fretNoFont");
//			fretNoSize = (int)client.Get(path + "/fretNoSize");
//			fretNoPadding = (double)client.Get(path + "/fretNoPadding");
//
//			stringColor = (string)client.Get(path + "/stringColor");
//			stringWidth = (double)client.Get(path + "/stringWidth");
//
//			stringPadding = (double)client.Get(path + "/stringPadding");
//
//			stringExtraPercent = (double)client.Get(path + "/stringExtraPercent");
//
//			stringDashLength = (double)client.Get(path + "/stringDashLength");
//
//			relationColor = (string)client.Get(path + "/relationColor");
//			relationFont = (string)client.Get(path + "/relationFont");
//			relationSize = (int)client.Get(path + "/relationSize");
//			relationPadding = (double)client.Get(path + "/relationPadding");
//
//			fingerFontColor = (string)client.Get(path + "/fingerFontColor");
//			fingerFont = (string)client.Get(path + "/fingerFont");
//			fingerFontSize = (int)client.Get(path + "/fingerFontSize");
//
//			fingerColor = (string)client.Get(path + "/fingerColor");
//			fingerDiameter = (double)client.Get(path + "/fingerDiameter");
//
//			fingerOutlineWidth = (double)client.Get(path + "/fingerOutlineWidth");
//			fingerOutlineColor = (string)client.Get(path + "/fingerOutlineColor");
//
//			frettedColor = (string)client.Get(path + "/frettedColor");
//			frettedFont = (string)client.Get(path + "/frettedFont");
//			frettedSize = (int)client.Get(path + "/frettedSize");
//			frettedPadding = (double)client.Get(path + "/frettedPadding");
		
		}

/****************************************************************
 ***********************CALLBACKS********************************
 ***************************************************************/

		void preferences_changed_cb (object sender, NotifyEventArgs args)
		{
			//System.Console.WriteLine("ChordRenderer.preferences_changed_cb: Prefs changed");
			set_up_prefs();
			if(PreferencesChanged != null){PreferencesChanged(this, new EventArgs());}
		}
	}
}