using System;

namespace gnomeguitar_cs
{
	public enum ChordShapeValue {
			NO_SHAPE,
			ANY,
			OPEN,
			E_SHAPED,
			G_SHAPED,
			A_SHAPED,
			C_SHAPED,	
			D_SHAPED,
			MOVEABLE,
			UNKNOWN	
		}
	
	public class ChordShape
	{
		
		static public readonly ChordShapeValue[] chordShapeValues = new ChordShapeValue[10] {
			ChordShapeValue.NO_SHAPE,
			ChordShapeValue.ANY,
			ChordShapeValue.OPEN,
			ChordShapeValue.E_SHAPED,
			ChordShapeValue.G_SHAPED,
			ChordShapeValue.A_SHAPED,
			ChordShapeValue.C_SHAPED,	
			ChordShapeValue.D_SHAPED,
			ChordShapeValue.MOVEABLE,
			ChordShapeValue.UNKNOWN};
		
		ChordShapeValue csv;
		
		public ChordShape()
		{
			csv = ChordShapeValue.NO_SHAPE;
		}
	
		public ChordShape(string text){
			csv = text_to_shape(text);
		}
		
		public ChordShape(ChordShapeValue csv){
			this.csv = csv;
		}
		
		public static bool operator == (ChordShape x, ChordShape y) {
			return x.csv == y.csv;
		}
		
		public static bool operator != (ChordShape x, ChordShape y) {
			return x.csv != y.csv;
		}
		
		public override bool Equals(object o) {
			if(!(o is ChordShape))
				return false;
			return this == (ChordShape)o;
		}
		
		public override int GetHashCode()
		{
			return (int)csv;
		}
		
		public string to_text(){
			return shape_to_text(csv);
		}
		
		private ChordShapeValue text_to_shape (string text)
		{
			ChordShapeValue shape = ChordShapeValue.NO_SHAPE;
			switch (text){
			case "Any": shape = ChordShapeValue.ANY; break;
			case "Unknown":	shape = ChordShapeValue.UNKNOWN; break;
			case "Open": shape = ChordShapeValue.OPEN; break;
			case "E Shaped": shape = ChordShapeValue.E_SHAPED; break;
			case "G Shaped": shape = ChordShapeValue.G_SHAPED; break;
			case "A Shaped": shape = ChordShapeValue.A_SHAPED; break;
			case "C Shaped": shape = ChordShapeValue.C_SHAPED; break;
			case "D Shaped": shape = ChordShapeValue.D_SHAPED; break;
			case "Moveable": shape = ChordShapeValue.MOVEABLE; break;
			}
			return shape;
		}

		private string shape_to_text(ChordShapeValue shape)
		{
			string text = null;

			switch (shape){
			case ChordShapeValue.NO_SHAPE: text = "None"; break;
			case ChordShapeValue.ANY: text = "Any"; break;
			case ChordShapeValue.UNKNOWN: text = "Unknown"; break;
			case ChordShapeValue.OPEN: text = "Open"; break;
			case ChordShapeValue.E_SHAPED: text = "E Shaped"; break;
			case ChordShapeValue.G_SHAPED: text = "G Shaped"; break;
			case ChordShapeValue.A_SHAPED: text = "A Shaped"; break;
			case ChordShapeValue.C_SHAPED: text = "C Shaped"; break;
			case ChordShapeValue.D_SHAPED: text = "D Shaped"; break;
			case ChordShapeValue.MOVEABLE: text = "Moveable"; break;
			default: text = ""; break;
			
			}
			return text;
		}
		public static implicit operator ChordShapeValue(ChordShape x) {
			return x.csv;
		}
	}
}